/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.AnimationSupport;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.SVGAnimationEngine;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.anim.AnimationTargetListener;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.SVGAnimationContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGElement;

public abstract class SVGAnimationElementBridge
extends AbstractSVGBridge
implements GenericBridge,
BridgeUpdateHandler,
SVGAnimationContext,
AnimatableElement {
    protected SVGOMElement element;
    protected BridgeContext ctx;
    protected SVGAnimationEngine eng;
    protected TimedElement timedElement;
    protected AbstractAnimation animation;
    protected String attributeNamespaceURI;
    protected String attributeLocalName;
    protected short animationType;
    protected SVGOMElement targetElement;
    protected AnimationTarget animationTarget;

    public TimedElement getTimedElement() {
        return this.timedElement;
    }

    public AnimatableValue getUnderlyingValue() {
        if (this.animationType == 0) {
            return this.animationTarget.getUnderlyingValue(this.attributeNamespaceURI, this.attributeLocalName);
        }
        return this.eng.getUnderlyingCSSValue(this.element, this.animationTarget, this.attributeLocalName);
    }

    public void handleElement(BridgeContext bridgeContext, Element element) {
        if (bridgeContext.isDynamic() && BridgeContext.getSVGContext(element) == null) {
            SVGAnimationElementBridge sVGAnimationElementBridge = (SVGAnimationElementBridge)this.getInstance();
            sVGAnimationElementBridge.element = (SVGOMElement)element;
            sVGAnimationElementBridge.ctx = bridgeContext;
            sVGAnimationElementBridge.eng = bridgeContext.getAnimationEngine();
            sVGAnimationElementBridge.element.setSVGContext(sVGAnimationElementBridge);
            if (sVGAnimationElementBridge.eng.hasStarted()) {
                sVGAnimationElementBridge.initializeAnimation();
                sVGAnimationElementBridge.initializeTimedElement();
            } else {
                sVGAnimationElementBridge.eng.addInitialBridge(sVGAnimationElementBridge);
            }
        }
    }

    protected void initializeAnimation() {
        Node node;
        String string = XLinkSupport.getXLinkHref(this.element);
        if (string.length() == 0) {
            node = this.element.getParentNode();
        } else {
            node = this.ctx.getReferencedElement(this.element, string);
            if (node.getOwnerDocument() != this.element.getOwnerDocument()) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
            }
        }
        this.animationTarget = null;
        if (node instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)node;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
        }
        String string2 = this.element.getAttributeNS(null, "attributeName");
        int n2 = string2.indexOf(58);
        if (n2 == -1) {
            if (this.element.hasProperty(string2)) {
                this.animationType = 1;
                this.attributeLocalName = string2;
            } else {
                this.animationType = 0;
                this.attributeLocalName = string2;
            }
        } else {
            this.animationType = 0;
            String string3 = string2.substring(0, n2);
            this.attributeNamespaceURI = this.element.lookupNamespaceURI(string3);
            this.attributeLocalName = string2.substring(n2 + 1);
        }
        if (this.animationType == 1 && !this.targetElement.isPropertyAnimatable(this.attributeLocalName) || this.animationType == 0 && !this.targetElement.isAttributeAnimatable(this.attributeNamespaceURI, this.attributeLocalName)) {
            throw new BridgeException(this.ctx, this.element, "attribute.not.animatable", new Object[]{this.targetElement.getNodeName(), string2});
        }
        int n3 = this.animationType == 1 ? this.targetElement.getPropertyType(this.attributeLocalName) : this.targetElement.getAttributeType(this.attributeNamespaceURI, this.attributeLocalName);
        if (!this.canAnimateType(n3)) {
            throw new BridgeException(this.ctx, this.element, "type.not.animatable", new Object[]{this.targetElement.getNodeName(), string2, this.element.getNodeName()});
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, this.animationType, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
    }

    protected abstract boolean canAnimateType(int var1);

    protected boolean checkValueType(AnimatableValue animatableValue) {
        return true;
    }

    protected void initializeTimedElement() {
        this.initializeTimedElement(this.timedElement);
        this.timedElement.initialize();
    }

    protected TimedElement createTimedElement() {
        return new SVGTimedElement();
    }

    protected abstract AbstractAnimation createAnimation(AnimationTarget var1);

    protected AnimatableValue parseAnimatableValue(String string) {
        String string2;
        if (!this.element.hasAttributeNS(null, string)) {
            return null;
        }
        AnimatableValue animatableValue = this.eng.parseAnimatableValue(this.element, this.animationTarget, this.attributeNamespaceURI, this.attributeLocalName, this.animationType == 1, string2 = this.element.getAttributeNS(null, string));
        if (!this.checkValueType(animatableValue)) {
            throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{string, string2});
        }
        return animatableValue;
    }

    protected void initializeTimedElement(TimedElement timedElement) {
        timedElement.parseAttributes(this.element.getAttributeNS(null, "begin"), this.element.getAttributeNS(null, "dur"), this.element.getAttributeNS(null, "end"), this.element.getAttributeNS(null, "min"), this.element.getAttributeNS(null, "max"), this.element.getAttributeNS(null, "repeatCount"), this.element.getAttributeNS(null, "repeatDur"), this.element.getAttributeNS(null, "fill"), this.element.getAttributeNS(null, "restart"));
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        this.element.setSVGContext(null);
        this.dispose();
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
    }

    public void handleOtherAnimationChanged(String string) {
    }

    public void dispose() {
        if (this.element.getSVGContext() == null) {
            this.eng.removeAnimation(this.animation);
            this.timedElement.deinitialize();
            this.timedElement = null;
            this.element = null;
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        return null;
    }

    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.ctx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getCTM() {
        return null;
    }

    public AffineTransform getGlobalTransform() {
        return null;
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.element);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.element);
    }

    public float getFontSize() {
        return 0.0f;
    }

    public float svgToUserSpace(float f2, int n2, int n3) {
        return 0.0f;
    }

    public void addTargetListener(String string, AnimationTargetListener animationTargetListener) {
    }

    public void removeTargetListener(String string, AnimationTargetListener animationTargetListener) {
    }

    public SVGElement getTargetElement() {
        return this.targetElement;
    }

    public float getStartTime() {
        return this.timedElement.getCurrentBeginTime();
    }

    public float getCurrentTime() {
        return this.timedElement.getLastSampleTime();
    }

    public float getSimpleDuration() {
        return this.timedElement.getSimpleDur();
    }

    public float getHyperlinkBeginTime() {
        return this.timedElement.getHyperlinkBeginTime();
    }

    public boolean beginElement() throws DOMException {
        this.timedElement.beginElement();
        return this.timedElement.canBegin();
    }

    public boolean beginElementAt(float f2) throws DOMException {
        this.timedElement.beginElement(f2);
        return true;
    }

    public boolean endElement() throws DOMException {
        this.timedElement.endElement();
        return this.timedElement.canEnd();
    }

    public boolean endElementAt(float f2) throws DOMException {
        this.timedElement.endElement(f2);
        return true;
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    protected class SVGTimedElement
    extends TimedElement {
        protected SVGTimedElement() {
        }

        public Element getElement() {
            return SVGAnimationElementBridge.this.element;
        }

        protected void fireTimeEvent(String string, Calendar calendar, int n2) {
            AnimationSupport.fireTimeEvent(SVGAnimationElementBridge.this.element, string, calendar, n2);
        }

        protected void toActive(float f2) {
            SVGAnimationElementBridge.this.eng.toActive(SVGAnimationElementBridge.this.animation, f2);
        }

        protected void toInactive(boolean bl, boolean bl2) {
            SVGAnimationElementBridge.this.eng.toInactive(SVGAnimationElementBridge.this.animation, bl2);
        }

        protected void removeFill() {
            SVGAnimationElementBridge.this.eng.removeFill(SVGAnimationElementBridge.this.animation);
        }

        protected void sampledAt(float f2, float f3, int n2) {
            SVGAnimationElementBridge.this.eng.sampledAt(SVGAnimationElementBridge.this.animation, f2, f3, n2);
        }

        protected void sampledLastValue(int n2) {
            SVGAnimationElementBridge.this.eng.sampledLastValue(SVGAnimationElementBridge.this.animation, n2);
        }

        protected TimedElement getTimedElementById(String string) {
            return AnimationSupport.getTimedElementById(string, SVGAnimationElementBridge.this.element);
        }

        protected EventTarget getEventTargetById(String string) {
            return AnimationSupport.getEventTargetById(string, SVGAnimationElementBridge.this.element);
        }

        protected EventTarget getRootEventTarget() {
            return (EventTarget)((Object)SVGAnimationElementBridge.this.element.getOwnerDocument());
        }

        protected EventTarget getAnimationEventTarget() {
            return SVGAnimationElementBridge.this.targetElement;
        }

        public boolean isBefore(TimedElement timedElement) {
            Element element = ((SVGTimedElement)timedElement).getElement();
            short s2 = SVGAnimationElementBridge.this.element.compareDocumentPosition(element);
            return (s2 & 2) != 0;
        }

        public String toString() {
            String string;
            if (SVGAnimationElementBridge.this.element != null && (string = SVGAnimationElementBridge.this.element.getAttributeNS(null, "id")).length() != 0) {
                return string;
            }
            return super.toString();
        }

        protected boolean isConstantAnimation() {
            return SVGAnimationElementBridge.this.isConstantAnimation();
        }
    }
}

