/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGBrokenLinkProvider;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.AbstractSVGAnimatedLength;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMAnimatedPreserveAspectRatio;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.MimeTypeConstants;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
extends AbstractGraphicsNodeBridge {
    protected SVGDocument imgDocument;
    protected EventListener listener = null;
    protected BridgeContext subCtx = null;
    protected boolean hitCheckChildren = false;
    static SVGBrokenLinkProvider brokenLinkProvider = new SVGBrokenLinkProvider();

    public String getLocalName() {
        return "image";
    }

    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        ImageNode imageNode = (ImageNode)super.createGraphicsNode(bridgeContext, element);
        if (imageNode == null) {
            return null;
        }
        this.associateSVGContext(bridgeContext, element, imageNode);
        this.hitCheckChildren = false;
        GraphicsNode graphicsNode = this.buildImageGraphicsNode(bridgeContext, element);
        if (graphicsNode == null) {
            SVGImageElement sVGImageElement = (SVGImageElement)element;
            String string = sVGImageElement.getHref().getAnimVal();
            throw new BridgeException(bridgeContext, element, "uri.image.invalid", new Object[]{string});
        }
        imageNode.setImage(graphicsNode);
        imageNode.setHitCheckChildren(this.hitCheckChildren);
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertImageRendering(element, renderingHints);
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if (renderingHints != null) {
            imageNode.setRenderingHints(renderingHints);
        }
        return imageNode;
    }

    protected GraphicsNode buildImageGraphicsNode(BridgeContext bridgeContext, Element element) {
        SVGImageElement sVGImageElement = (SVGImageElement)element;
        String string = sVGImageElement.getHref().getAnimVal();
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"xlink:href"});
        }
        if (string.indexOf(35) != -1) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"xlink:href", string});
        }
        String string2 = AbstractNode.getBaseURI(element);
        ParsedURL parsedURL = string2 == null ? new ParsedURL(string) : new ParsedURL(string2, string);
        return this.createImageGraphicsNode(bridgeContext, element, parsedURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphicsNode createImageGraphicsNode(BridgeContext bridgeContext, Element element, ParsedURL parsedURL) {
        Object object;
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            return shapeNode;
        }
        SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
        String string = sVGDocument.getURL();
        ParsedURL parsedURL2 = null;
        if (string != null) {
            parsedURL2 = new ParsedURL(string);
        }
        UserAgent userAgent = bridgeContext.getUserAgent();
        try {
            userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
        }
        catch (SecurityException securityException) {
            throw new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{parsedURL});
        }
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        ICCColorSpaceExt iCCColorSpaceExt = SVGImageElementBridge.extractColorSpace(element, bridgeContext);
        try {
            object = documentLoader.checkCache(parsedURL.toString());
            if (object != null) {
                this.imgDocument = (SVGDocument)object;
                return this.createSVGImageNode(bridgeContext, element, this.imgDocument);
            }
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = imageTagRegistry.checkCache(parsedURL, iCCColorSpaceExt);
        if (object != null) {
            return this.createRasterImageNode(bridgeContext, element, (Filter)object, parsedURL);
        }
        object = null;
        try {
            object = this.openStream(element, parsedURL);
        }
        catch (SecurityException securityException) {
            throw new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{parsedURL});
        }
        catch (IOException iOException) {
            return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString(), iOException.getLocalizedMessage());
        }
        Object object2 = imageTagRegistry.readURL((InputStream)object, parsedURL, iCCColorSpaceExt, false, false);
        if (object2 != null) {
            return this.createRasterImageNode(bridgeContext, element, (Filter)object2, parsedURL);
        }
        try {
            ((ProtectedStream)object).retry();
        }
        catch (IOException iOException) {
            ((ProtectedStream)object).release();
            object = null;
            try {
                object = this.openStream(element, parsedURL);
            }
            catch (IOException iOException2) {
                return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString(), iOException2.getLocalizedMessage());
            }
        }
        try {
            object2 = documentLoader.loadDocument(parsedURL.toString(), (InputStream)object);
            this.imgDocument = (SVGDocument)object2;
            return this.createSVGImageNode(bridgeContext, element, this.imgDocument);
        }
        catch (BridgeException bridgeException) {
            throw bridgeException;
        }
        catch (SecurityException securityException) {
            throw new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{parsedURL});
        }
        catch (InterruptedIOException interruptedIOException) {
            if (HaltingThread.hasBeenHalted()) {
                throw new InterruptedBridgeException();
            }
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            throw interruptedBridgeException;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ProtectedStream)object).retry();
        }
        catch (IOException iOException) {
            ((ProtectedStream)object).release();
            object = null;
            try {
                object = this.openStream(element, parsedURL);
            }
            catch (IOException iOException3) {
                return this.createBrokenImageNode(bridgeContext, element, parsedURL.toString(), iOException3.getLocalizedMessage());
            }
        }
        try {
            Filter filter = imageTagRegistry.readURL((InputStream)object, parsedURL, iCCColorSpaceExt, true, true);
            if (filter != null) {
                GraphicsNode graphicsNode = this.createRasterImageNode(bridgeContext, element, filter, parsedURL);
                return graphicsNode;
            }
        }
        finally {
            ((ProtectedStream)object).release();
        }
        return null;
    }

    protected ProtectedStream openStream(Element element, ParsedURL parsedURL) throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(ImageTagRegistry.getRegistry().getRegisteredMimeTypes());
        arrayList.add(MimeTypeConstants.MIME_TYPES_SVG);
        InputStream inputStream = parsedURL.openStream(arrayList.iterator());
        return new ProtectedStream(inputStream);
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new ImageNode();
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (!bridgeContext.isInteractive()) {
            return;
        }
        bridgeContext.bind(element, graphicsNode);
        if (bridgeContext.isDynamic()) {
            this.e = element;
            this.node = graphicsNode;
            this.ctx = bridgeContext;
            ((SVGOMElement)element).setSVGContext(this);
        }
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        try {
            String string = animatedLiveAttributeValue.getNamespaceURI();
            String string2 = animatedLiveAttributeValue.getLocalName();
            if (string == null) {
                if (string2.equals("x") || string2.equals("y")) {
                    this.updateImageBounds();
                    return;
                }
                if (string2.equals("width") || string2.equals("height")) {
                    SVGImageElement sVGImageElement = (SVGImageElement)this.e;
                    ImageNode imageNode = (ImageNode)this.node;
                    AbstractSVGAnimatedLength abstractSVGAnimatedLength = string2.charAt(0) == 'w' ? (AbstractSVGAnimatedLength)sVGImageElement.getWidth() : (AbstractSVGAnimatedLength)sVGImageElement.getHeight();
                    float f2 = abstractSVGAnimatedLength.getCheckedValue();
                    if (f2 == 0.0f || imageNode.getImage() instanceof ShapeNode) {
                        this.rebuildImageNode();
                    } else {
                        this.updateImageBounds();
                    }
                    return;
                }
                if (string2.equals("preserveAspectRatio")) {
                    this.updateImageBounds();
                    return;
                }
            } else if (string.equals("http://www.w3.org/1999/xlink") && string2.equals("href")) {
                this.rebuildImageNode();
                return;
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(this.ctx, liveAttributeException);
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    protected void updateImageBounds() {
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(this.ctx, this.e);
        GraphicsNode graphicsNode = ((ImageNode)this.node).getImage();
        float[] fArray = null;
        if (graphicsNode instanceof RasterImageNode) {
            Rectangle2D rectangle2D2 = ((RasterImageNode)graphicsNode).getImageBounds();
            fArray = new float[]{0.0f, 0.0f, (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight()};
        } else if (this.imgDocument != null) {
            SVGSVGElement sVGSVGElement = this.imgDocument.getRootElement();
            String string = sVGSVGElement.getAttributeNS(null, "viewBox");
            fArray = ViewBox.parseViewBoxAttribute(this.e, string, this.ctx);
        }
        if (graphicsNode != null) {
            SVGImageElementBridge.initializeViewport(this.ctx, this.e, graphicsNode, fArray, rectangle2D);
        }
    }

    protected void rebuildImageNode() {
        Object object;
        if (this.imgDocument != null && this.listener != null) {
            object = (NodeEventTarget)((Object)this.imgDocument.getRootElement());
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            object.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            object = this.imgDocument.getRootElement();
            this.disposeTree((Node)object);
        }
        this.imgDocument = null;
        this.subCtx = null;
        object = this.buildImageGraphicsNode(this.ctx, this.e);
        ImageNode imageNode = (ImageNode)this.node;
        imageNode.setImage((GraphicsNode)object);
        if (object == null) {
            SVGImageElement sVGImageElement = (SVGImageElement)this.e;
            String string = sVGImageElement.getHref().getAnimVal();
            throw new BridgeException(this.ctx, this.e, "uri.image.invalid", new Object[]{string});
        }
    }

    protected void handleCSSPropertyChanged(int n2) {
        switch (n2) {
            case 6: 
            case 30: {
                RenderingHints renderingHints = CSSUtilities.convertImageRendering(this.e, null);
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n2);
            }
        }
    }

    protected GraphicsNode createRasterImageNode(BridgeContext bridgeContext, Element element, Filter filter, ParsedURL parsedURL) {
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            return shapeNode;
        }
        if (BrokenLinkProvider.hasBrokenLinkProperty(filter)) {
            Object object = filter.getProperty("org.apache.batik.BrokenLinkImage");
            String string = "unknown";
            if (object instanceof String) {
                string = (String)object;
            }
            SVGDocument sVGDocument = bridgeContext.getUserAgent().getBrokenLinkDocument(element, parsedURL.toString(), string);
            return this.createSVGImageNode(bridgeContext, element, sVGDocument);
        }
        RasterImageNode rasterImageNode = new RasterImageNode();
        rasterImageNode.setImage(filter);
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        float[] fArray = new float[]{0.0f, 0.0f, (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight()};
        SVGImageElementBridge.initializeViewport(bridgeContext, element, rasterImageNode, fArray, rectangle2D);
        return rasterImageNode;
    }

    protected GraphicsNode createSVGImageNode(BridgeContext bridgeContext, Element element, SVGDocument sVGDocument) {
        CSSEngine cSSEngine = ((SVGOMDocument)sVGDocument).getCSSEngine();
        this.subCtx = bridgeContext.createSubBridgeContext((SVGOMDocument)sVGDocument);
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        Rectangle2D rectangle2D = SVGImageElementBridge.getImageBounds(bridgeContext, element);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            ShapeNode shapeNode = new ShapeNode();
            shapeNode.setShape(rectangle2D);
            compositeGraphicsNode.getChildren().add(shapeNode);
            return compositeGraphicsNode;
        }
        Rectangle2D rectangle2D2 = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D2 != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D2);
        }
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        CanvasGraphicsNode canvasGraphicsNode = (CanvasGraphicsNode)this.subCtx.getGVTBuilder().build(this.subCtx, sVGSVGElement);
        if (cSSEngine == null && bridgeContext.isInteractive()) {
            this.subCtx.addUIEventListeners(sVGDocument);
        }
        canvasGraphicsNode.setClip(null);
        canvasGraphicsNode.setViewingTransform(new AffineTransform());
        compositeGraphicsNode.getChildren().add(canvasGraphicsNode);
        String string = sVGSVGElement.getAttributeNS(null, "viewBox");
        float[] fArray = ViewBox.parseViewBoxAttribute(element, string, bridgeContext);
        SVGImageElementBridge.initializeViewport(bridgeContext, element, compositeGraphicsNode, fArray, rectangle2D);
        if (bridgeContext.isInteractive()) {
            this.listener = new ForwardEventListener(sVGSVGElement, element);
            NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)sVGSVGElement);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "click", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false, null);
            this.subCtx.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
        }
        return compositeGraphicsNode;
    }

    public void dispose() {
        EventTarget eventTarget;
        if (this.imgDocument != null && this.listener != null) {
            eventTarget = (NodeEventTarget)((Object)this.imgDocument.getRootElement());
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keydown", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keypress", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "keyup", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousedown", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mousemove", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.listener, false);
            eventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseup", this.listener, false);
            this.listener = null;
        }
        if (this.imgDocument != null) {
            eventTarget = this.imgDocument.getRootElement();
            this.disposeTree((Node)((Object)eventTarget));
            this.imgDocument = null;
            this.subCtx = null;
        }
        super.dispose();
    }

    protected static void initializeViewport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode, float[] fArray, Rectangle2D rectangle2D) {
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        try {
            Object object;
            SVGImageElement sVGImageElement = (SVGImageElement)element;
            SVGOMAnimatedPreserveAspectRatio sVGOMAnimatedPreserveAspectRatio = (SVGOMAnimatedPreserveAspectRatio)sVGImageElement.getPreserveAspectRatio();
            sVGOMAnimatedPreserveAspectRatio.check();
            AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform(element, fArray, f4, f5, sVGOMAnimatedPreserveAspectRatio, bridgeContext);
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f2, f3));
            graphicsNode.setTransform(affineTransform);
            Shape shape = null;
            if (CSSUtilities.convertOverflow(element)) {
                object = CSSUtilities.convertClip(element);
                shape = object == null ? new Rectangle2D.Float(f2, f3, f4, f5) : new Rectangle2D.Float(f2 + object[3], f3 + object[0], f4 - object[1] - object[3], f5 - object[2] - object[0]);
            }
            if (shape != null) {
                try {
                    affineTransform = affineTransform.createInverse();
                    object = graphicsNode.getGraphicsNodeRable(true);
                    shape = affineTransform.createTransformedShape(shape);
                    graphicsNode.setClip(new ClipRable8Bit((Filter)object, shape));
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    protected static ICCColorSpaceExt extractColorSpace(Element element, BridgeContext bridgeContext) {
        SVGColorProfileElementBridge sVGColorProfileElementBridge;
        String string = CSSUtilities.getComputedStyle(element, 8).getStringValue();
        ICCColorSpaceExt iCCColorSpaceExt = null;
        if ("srgb".equalsIgnoreCase(string)) {
            iCCColorSpaceExt = new ICCColorSpaceExt(ICC_Profile.getInstance(1000), 4);
        } else if (!"auto".equalsIgnoreCase(string) && !"".equalsIgnoreCase(string) && (sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        }
        return iCCColorSpaceExt;
    }

    protected static Rectangle2D getImageBounds(BridgeContext bridgeContext, Element element) {
        try {
            SVGImageElement sVGImageElement = (SVGImageElement)element;
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGImageElement.getX();
            float f2 = abstractSVGAnimatedLength.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGImageElement.getY();
            float f3 = abstractSVGAnimatedLength2.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGImageElement.getWidth();
            float f4 = abstractSVGAnimatedLength3.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength4 = (AbstractSVGAnimatedLength)sVGImageElement.getHeight();
            float f5 = abstractSVGAnimatedLength4.getCheckedValue();
            return new Rectangle2D.Float(f2, f3, f4, f5);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    GraphicsNode createBrokenImageNode(BridgeContext bridgeContext, Element element, String string, String string2) {
        SVGDocument sVGDocument = bridgeContext.getUserAgent().getBrokenLinkDocument(element, string, Messages.formatMessage("uri.image.error", new Object[]{string2}));
        return this.createSVGImageNode(bridgeContext, element, sVGDocument);
    }

    static {
        ImageTagRegistry.setBrokenLinkProvider(brokenLinkProvider);
    }

    protected static class ForwardEventListener
    implements EventListener {
        protected Element svgElement;
        protected Element imgElement;

        public ForwardEventListener(Element element, Element element2) {
            this.svgElement = element;
            this.imgElement = element2;
        }

        public void handleEvent(Event event) {
            DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
            DOMMouseEvent dOMMouseEvent2 = (DOMMouseEvent)((DocumentEvent)((Object)this.imgElement.getOwnerDocument())).createEvent("MouseEvents");
            dOMMouseEvent2.initMouseEventNS("http://www.w3.org/2001/xml-events", dOMMouseEvent.getType(), dOMMouseEvent.getBubbles(), dOMMouseEvent.getCancelable(), dOMMouseEvent.getView(), dOMMouseEvent.getDetail(), dOMMouseEvent.getScreenX(), dOMMouseEvent.getScreenY(), dOMMouseEvent.getClientX(), dOMMouseEvent.getClientY(), dOMMouseEvent.getButton(), (EventTarget)((Object)this.imgElement), dOMMouseEvent.getModifiersString());
            ((EventTarget)((Object)this.imgElement)).dispatchEvent(dOMMouseEvent2);
        }
    }

    public static class ProtectedStream
    extends BufferedInputStream {
        static final int BUFFER_SIZE = 8192;

        ProtectedStream(InputStream inputStream) {
            super(inputStream, 8192);
            super.mark(8192);
        }

        ProtectedStream(InputStream inputStream, int n2) {
            super(inputStream, n2);
            super.mark(n2);
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n2) {
        }

        public void reset() throws IOException {
            throw new IOException("Reset unsupported");
        }

        public void retry() throws IOException {
            super.reset();
        }

        public void close() throws IOException {
        }

        public void release() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

