/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.ClockHandler;
import org.apache.batik.parser.ClockParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGNumberList;

public abstract class SVGUtilities
implements SVGConstants,
ErrorConstants {
    public static final short USER_SPACE_ON_USE = 1;
    public static final short OBJECT_BOUNDING_BOX = 2;
    public static final short STROKE_WIDTH = 3;

    protected SVGUtilities() {
    }

    public static Element getParentElement(Element element) {
        Node node = CSSEngine.getCSSParentNode(element);
        while (node != null && node.getNodeType() != 1) {
            node = CSSEngine.getCSSParentNode(node);
        }
        return (Element)node;
    }

    public static float[] convertSVGNumberList(SVGNumberList sVGNumberList) {
        int n2 = sVGNumberList.getNumberOfItems();
        if (n2 == 0) {
            return null;
        }
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = sVGNumberList.getItem(i2).getValue();
        }
        return fArray;
    }

    public static float convertSVGNumber(String string) {
        return Float.parseFloat(string);
    }

    public static int convertSVGInteger(String string) {
        return Integer.parseInt(string);
    }

    public static float convertRatio(String string) {
        float f2;
        float f3 = 1.0f;
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
            f3 = 100.0f;
        }
        if ((f2 = Float.parseFloat(string) / f3) < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    public static String getDescription(SVGElement sVGElement) {
        String string = "";
        boolean bl = false;
        Node node = sVGElement.getFirstChild();
        if (node != null && node.getNodeType() == 1) {
            String string2;
            String string3 = string2 = node.getPrefix() == null ? node.getNodeName() : node.getLocalName();
            if (string2.equals("desc")) {
                bl = ((SVGLangSpace)((Object)node)).getXMLspace().equals("preserve");
                for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 3) continue;
                    string = string + node.getNodeValue();
                }
            }
        }
        return bl ? XMLSupport.preserveXMLSpace(string) : XMLSupport.defaultXMLSpace(string);
    }

    public static boolean matchUserAgent(Element element, UserAgent userAgent) {
        String string;
        StringTokenizer stringTokenizer;
        String string2;
        block9: {
            if (element.hasAttributeNS(null, "systemLanguage")) {
                string2 = element.getAttributeNS(null, "systemLanguage");
                if (string2.length() == 0) {
                    return false;
                }
                stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (!SVGUtilities.matchUserLanguage(string, userAgent.getLanguages())) continue;
                    break block9;
                }
                return false;
            }
        }
        if (element.hasAttributeNS(null, "requiredFeatures")) {
            string2 = element.getAttributeNS(null, "requiredFeatures");
            if (string2.length() == 0) {
                return false;
            }
            stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (userAgent.hasFeature(string)) continue;
                return false;
            }
        }
        if (element.hasAttributeNS(null, "requiredExtensions")) {
            string2 = element.getAttributeNS(null, "requiredExtensions");
            if (string2.length() == 0) {
                return false;
            }
            stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (userAgent.supportExtension(string)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean matchUserLanguage(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string.startsWith(string3)) continue;
            if (string.length() > string3.length()) {
                return string.charAt(string3.length()) == '-';
            }
            return true;
        }
        return false;
    }

    public static String getChainableAttributeNS(Element element, String string, String string2, BridgeContext bridgeContext) {
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        Element element2 = element;
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        String string3;
        while ((string3 = element2.getAttributeNS(string, string2)).length() <= 0) {
            String string4 = XLinkSupport.getXLinkHref(element2);
            if (string4.length() == 0) {
                return "";
            }
            String string5 = ((AbstractNode)((Object)element2)).getBaseURI();
            ParsedURL parsedURL = new ParsedURL(string5, string4);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (!parsedURL.equals(iterator.next())) continue;
                throw new BridgeException(bridgeContext, element2, "xlink.href.circularDependencies", new Object[]{string4});
            }
            try {
                SVGDocument sVGDocument = (SVGDocument)element2.getOwnerDocument();
                URIResolver uRIResolver = bridgeContext.createURIResolver(sVGDocument, documentLoader);
                element2 = uRIResolver.getElement(parsedURL.toString(), element2);
                linkedList.add(parsedURL);
            }
            catch (IOException iOException) {
                throw new BridgeException(bridgeContext, element2, iOException, "uri.io", new Object[]{string4});
            }
            catch (SecurityException securityException) {
                throw new BridgeException(bridgeContext, element2, securityException, "uri.unsecure", new Object[]{string4});
            }
        }
        return string3;
    }

    public static Point2D convertPoint(String string, String string2, String string3, String string4, short s2, UnitProcessor.Context context) {
        float f2;
        float f3;
        switch (s2) {
            case 2: {
                f3 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, string2, context);
                f2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string3, string4, context);
                break;
            }
            case 1: {
                f3 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, string2, context);
                f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string3, string4, context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit type");
            }
        }
        return new Point2D.Float(f3, f2);
    }

    public static float convertLength(String string, String string2, short s2, UnitProcessor.Context context) {
        switch (s2) {
            case 2: {
                return UnitProcessor.svgOtherLengthToObjectBoundingBox(string, string2, context);
            }
            case 1: {
                return UnitProcessor.svgOtherLengthToUserSpace(string, string2, context);
            }
        }
        throw new IllegalArgumentException("Invalid unit type");
    }

    public static Rectangle2D convertMaskRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = element.getAttributeNS(null, "x");
        if (string5.length() == 0) {
            string5 = "-10%";
        }
        if ((string4 = element.getAttributeNS(null, "y")).length() == 0) {
            string4 = "-10%";
        }
        if ((string3 = element.getAttributeNS(null, "width")).length() == 0) {
            string3 = "120%";
        }
        if ((string2 = element.getAttributeNS(null, "height")).length() == 0) {
            string2 = "120%";
        }
        short s2 = (string = element.getAttributeNS(null, "maskUnits")).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "maskUnits", string, bridgeContext);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        return SVGUtilities.convertRegion(string5, string4, string3, string2, s2, graphicsNode, context);
    }

    public static Rectangle2D convertPatternRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3 = SVGUtilities.getChainableAttributeNS(element, null, "x", bridgeContext);
        if (string3.length() == 0) {
            string3 = "0";
        }
        if ((string2 = SVGUtilities.getChainableAttributeNS(element, null, "y", bridgeContext)).length() == 0) {
            string2 = "0";
        }
        if ((string = SVGUtilities.getChainableAttributeNS(element, null, "width", bridgeContext)).length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"width"});
        }
        String string4 = SVGUtilities.getChainableAttributeNS(element, null, "height", bridgeContext);
        if (string4.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"height"});
        }
        String string5 = SVGUtilities.getChainableAttributeNS(element, null, "patternUnits", bridgeContext);
        short s2 = string5.length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "patternUnits", string5, bridgeContext);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        return SVGUtilities.convertRegion(string3, string2, string, string4, s2, graphicsNode, context);
    }

    public static float[] convertFilterRes(Element element, BridgeContext bridgeContext) {
        float[] fArray = new float[2];
        String string = SVGUtilities.getChainableAttributeNS(element, null, "filterRes", bridgeContext);
        Float[] floatArray = SVGUtilities.convertSVGNumberOptionalNumber(element, "filterRes", string, bridgeContext);
        if (fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"filterRes", string});
        }
        if (floatArray[0] == null) {
            fArray[0] = -1.0f;
        } else {
            fArray[0] = floatArray[0].floatValue();
            if (fArray[0] < 0.0f) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"filterRes", string});
            }
        }
        if (floatArray[1] == null) {
            fArray[1] = fArray[0];
        } else {
            fArray[1] = floatArray[1].floatValue();
            if (fArray[1] < 0.0f) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"filterRes", string});
            }
        }
        return fArray;
    }

    public static Float[] convertSVGNumberOptionalNumber(Element element, String string, String string2, BridgeContext bridgeContext) {
        Float[] floatArray = new Float[2];
        if (string2.length() == 0) {
            return floatArray;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            floatArray[0] = new Float(Float.parseFloat(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                floatArray[1] = new Float(Float.parseFloat(stringTokenizer.nextToken()));
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2, numberFormatException});
        }
        return floatArray;
    }

    public static Rectangle2D convertFilterChainRegion(Element element, Element element2, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = SVGUtilities.getChainableAttributeNS(element, null, "x", bridgeContext);
        if (string8.length() == 0) {
            string8 = "-10%";
        }
        if ((string7 = SVGUtilities.getChainableAttributeNS(element, null, "y", bridgeContext)).length() == 0) {
            string7 = "-10%";
        }
        if ((string6 = SVGUtilities.getChainableAttributeNS(element, null, "width", bridgeContext)).length() == 0) {
            string6 = "120%";
        }
        if ((string5 = SVGUtilities.getChainableAttributeNS(element, null, "height", bridgeContext)).length() == 0) {
            string5 = "120%";
        }
        short s2 = (string4 = SVGUtilities.getChainableAttributeNS(element, null, "filterUnits", bridgeContext)).length() == 0 ? (short)2 : (short)SVGUtilities.parseCoordinateSystem(element, "filterUnits", string4, bridgeContext);
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        Rectangle2D rectangle2D = SVGUtilities.convertRegion(string8, string7, string6, string5, s2, graphicsNode, context);
        string4 = SVGUtilities.getChainableAttributeNS(element, null, "filterMarginsUnits", bridgeContext);
        s2 = string4.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "filterMarginsUnits", string4, bridgeContext);
        String string9 = element.getAttributeNS(null, "mx");
        if (string9.length() == 0) {
            string9 = "0";
        }
        if ((string3 = element.getAttributeNS(null, "my")).length() == 0) {
            string3 = "0";
        }
        if ((string2 = element.getAttributeNS(null, "mw")).length() == 0) {
            string2 = "0";
        }
        if ((string = element.getAttributeNS(null, "mh")).length() == 0) {
            string = "0";
        }
        return SVGUtilities.extendRegion(string9, string3, string2, string, s2, graphicsNode, rectangle2D, context);
    }

    protected static Rectangle2D extendRegion(String string, String string2, String string3, String string4, short s2, GraphicsNode graphicsNode, Rectangle2D rectangle2D, UnitProcessor.Context context) {
        float f2;
        float f3;
        float f4;
        float f5;
        switch (s2) {
            case 1: {
                f5 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "mx", context);
                f4 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "my", context);
                f3 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string3, "mw", context);
                f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string4, "mh", context);
                break;
            }
            case 2: {
                Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
                if (rectangle2D2 == null) {
                    f2 = 0.0f;
                    f3 = 0.0f;
                    f4 = 0.0f;
                    f5 = 0.0f;
                    break;
                }
                f5 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, "mx", context);
                f5 = (float)((double)f5 * rectangle2D2.getWidth());
                f4 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string2, "my", context);
                f4 = (float)((double)f4 * rectangle2D2.getHeight());
                f3 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string3, "mw", context);
                f3 = (float)((double)f3 * rectangle2D2.getWidth());
                f2 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string4, "mh", context);
                f2 = (float)((double)f2 * rectangle2D2.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit type");
            }
        }
        rectangle2D.setRect(rectangle2D.getX() + (double)f5, rectangle2D.getY() + (double)f4, rectangle2D.getWidth() + (double)f3, rectangle2D.getHeight() + (double)f2);
        return rectangle2D;
    }

    public static Rectangle2D getBaseFilterPrimitiveRegion(Element element, Element element2, GraphicsNode graphicsNode, Rectangle2D rectangle2D, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element2);
        double d2 = rectangle2D.getX();
        String string = element.getAttributeNS(null, "x");
        if (string.length() != 0) {
            d2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        double d3 = rectangle2D.getY();
        string = element.getAttributeNS(null, "y");
        if (string.length() != 0) {
            d3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        double d4 = rectangle2D.getWidth();
        string = element.getAttributeNS(null, "width");
        if (string.length() != 0) {
            d4 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        }
        double d5 = rectangle2D.getHeight();
        string = element.getAttributeNS(null, "height");
        if (string.length() != 0) {
            d5 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        }
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element element, Element element2, Element element3, GraphicsNode graphicsNode, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BridgeContext bridgeContext) {
        Rectangle2D rectangle2D3;
        String string = "";
        if (element2 != null) {
            string = SVGUtilities.getChainableAttributeNS(element2, null, "primitiveUnits", bridgeContext);
        }
        short s2 = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element2, "filterUnits", string, bridgeContext);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (element != null) {
            string2 = element.getAttributeNS(null, "x");
            string3 = element.getAttributeNS(null, "y");
            string4 = element.getAttributeNS(null, "width");
            string5 = element.getAttributeNS(null, "height");
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element3);
        switch (s2) {
            case 2: {
                rectangle2D3 = graphicsNode.getGeometryBounds();
                if (rectangle2D3 == null) break;
                if (string2.length() != 0) {
                    d2 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string2, "x", context);
                    d2 = rectangle2D3.getX() + d2 * rectangle2D3.getWidth();
                }
                if (string3.length() != 0) {
                    d3 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string3, "y", context);
                    d3 = rectangle2D3.getY() + d3 * rectangle2D3.getHeight();
                }
                if (string4.length() != 0) {
                    d4 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(string4, "width", context);
                    d4 *= rectangle2D3.getWidth();
                }
                if (string5.length() == 0) break;
                d5 = UnitProcessor.svgVerticalLengthToObjectBoundingBox(string5, "height", context);
                d5 *= rectangle2D3.getHeight();
                break;
            }
            case 1: {
                if (string2.length() != 0) {
                    d2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string2, "x", context);
                }
                if (string3.length() != 0) {
                    d3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string3, "y", context);
                }
                if (string4.length() != 0) {
                    d4 = UnitProcessor.svgHorizontalLengthToUserSpace(string4, "width", context);
                }
                if (string5.length() == 0) break;
                d5 = UnitProcessor.svgVerticalLengthToUserSpace(string5, "height", context);
                break;
            }
            default: {
                throw new Error("invalid unitsType:" + s2);
            }
        }
        rectangle2D3 = new Rectangle2D.Double(d2, d3, d4, d5);
        string = "";
        if (element2 != null) {
            string = SVGUtilities.getChainableAttributeNS(element2, null, "filterPrimitiveMarginsUnits", bridgeContext);
        }
        s2 = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element2, "filterPrimitiveMarginsUnits", string, bridgeContext);
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        if (element != null) {
            string6 = element.getAttributeNS(null, "mx");
            string7 = element.getAttributeNS(null, "my");
            string8 = element.getAttributeNS(null, "mw");
            string9 = element.getAttributeNS(null, "mh");
        }
        if (string6.length() == 0) {
            string6 = "0";
        }
        if (string7.length() == 0) {
            string7 = "0";
        }
        if (string8.length() == 0) {
            string8 = "0";
        }
        if (string9.length() == 0) {
            string9 = "0";
        }
        rectangle2D3 = SVGUtilities.extendRegion(string6, string7, string8, string9, s2, graphicsNode, rectangle2D3, context);
        Rectangle2D.intersect(rectangle2D3, rectangle2D2, rectangle2D3);
        return rectangle2D3;
    }

    public static Rectangle2D convertFilterPrimitiveRegion(Element element, Element element2, GraphicsNode graphicsNode, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BridgeContext bridgeContext) {
        Node node = element.getParentNode();
        Element element3 = null;
        if (node != null && node.getNodeType() == 1) {
            element3 = (Element)node;
        }
        return SVGUtilities.convertFilterPrimitiveRegion(element, element3, element2, graphicsNode, rectangle2D, rectangle2D2, bridgeContext);
    }

    public static short parseCoordinateSystem(Element element, String string, String string2, BridgeContext bridgeContext) {
        if ("userSpaceOnUse".equals(string2)) {
            return 1;
        }
        if ("objectBoundingBox".equals(string2)) {
            return 2;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
    }

    public static short parseMarkerCoordinateSystem(Element element, String string, String string2, BridgeContext bridgeContext) {
        if ("userSpaceOnUse".equals(string2)) {
            return 1;
        }
        if ("strokeWidth".equals(string2)) {
            return 3;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
    }

    protected static Rectangle2D convertRegion(String string, String string2, String string3, String string4, short s2, GraphicsNode graphicsNode, UnitProcessor.Context context) {
        double d2;
        double d3;
        double d4;
        double d5;
        switch (s2) {
            case 2: {
                d5 = UnitProcessor.svgHorizontalCoordinateToObjectBoundingBox(string, "x", context);
                d4 = UnitProcessor.svgVerticalCoordinateToObjectBoundingBox(string2, "y", context);
                d3 = UnitProcessor.svgHorizontalLengthToObjectBoundingBox(string3, "width", context);
                d2 = UnitProcessor.svgVerticalLengthToObjectBoundingBox(string4, "height", context);
                Rectangle2D rectangle2D = graphicsNode.getGeometryBounds();
                if (rectangle2D != null) {
                    d5 = rectangle2D.getX() + d5 * rectangle2D.getWidth();
                    d4 = rectangle2D.getY() + d4 * rectangle2D.getHeight();
                    d3 *= rectangle2D.getWidth();
                    d2 *= rectangle2D.getHeight();
                    break;
                }
                d2 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                d5 = 0.0;
                break;
            }
            case 1: {
                d5 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
                d4 = UnitProcessor.svgVerticalCoordinateToUserSpace(string2, "y", context);
                d3 = UnitProcessor.svgHorizontalLengthToUserSpace(string3, "width", context);
                d2 = UnitProcessor.svgVerticalLengthToUserSpace(string4, "height", context);
                break;
            }
            default: {
                throw new Error("invalid unitsType:" + s2);
            }
        }
        return new Rectangle2D.Double(d5, d4, d3, d2);
    }

    public static AffineTransform convertTransform(Element element, String string, String string2, BridgeContext bridgeContext) {
        try {
            return AWTTransformProducer.createAffineTransform(string2);
        }
        catch (ParseException parseException) {
            throw new BridgeException(bridgeContext, element, parseException, "attribute.malformed", new Object[]{string, string2, parseException});
        }
    }

    public static AffineTransform toObjectBBox(AffineTransform affineTransform, GraphicsNode graphicsNode) {
        AffineTransform affineTransform2 = new AffineTransform();
        Rectangle2D rectangle2D = graphicsNode.getGeometryBounds();
        if (rectangle2D != null) {
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform2.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        affineTransform2.concatenate(affineTransform);
        return affineTransform2;
    }

    public static Rectangle2D toObjectBBox(Rectangle2D rectangle2D, GraphicsNode graphicsNode) {
        Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
        if (rectangle2D2 != null) {
            return new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D.getX() * rectangle2D2.getWidth(), rectangle2D2.getY() + rectangle2D.getY() * rectangle2D2.getHeight(), rectangle2D.getWidth() * rectangle2D2.getWidth(), rectangle2D.getHeight() * rectangle2D2.getHeight());
        }
        return new Rectangle2D.Double();
    }

    public static float convertSnapshotTime(Element element, BridgeContext bridgeContext) {
        if (!element.hasAttributeNS(null, "snapshotTime")) {
            return 0.0f;
        }
        String string = element.getAttributeNS(null, "snapshotTime");
        if (string.equals("none")) {
            return 0.0f;
        }
        ClockParser clockParser = new ClockParser(false);
        class Handler
        implements ClockHandler {
            float time;

            Handler() {
            }

            public void clockValue(float f2) {
                this.time = f2;
            }
        }
        Handler handler = new Handler();
        clockParser.setClockHandler(handler);
        try {
            clockParser.parse(string);
        }
        catch (ParseException parseException) {
            throw new BridgeException(null, element, parseException, "attribute.malformed", new Object[]{"snapshotTime", string, parseException});
        }
        return handler.time;
    }
}

