/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class AbstractAttr
extends AbstractParentNode
implements Attr {
    protected String nodeName;
    protected boolean unspecified;
    protected boolean isIdAttr;
    protected AbstractElement ownerElement;
    protected TypeInfo typeInfo;

    protected AbstractAttr() {
    }

    protected AbstractAttr(String string, AbstractDocument abstractDocument) throws DOMException {
        this.ownerDocument = abstractDocument;
        if (abstractDocument.getStrictErrorChecking() && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{string});
        }
    }

    public void setNodeName(String string) {
        this.nodeName = string;
        this.isIdAttr = this.ownerDocument.isId(this);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        Node node = this.getFirstChild();
        if (node == null) {
            return "";
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            return node.getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer(node.getNodeValue());
        do {
            stringBuffer.append(node2.getNodeValue());
        } while ((node2 = node2.getNextSibling()) != null);
        return stringBuffer.toString();
    }

    public void setNodeValue(String string) throws DOMException {
        Node node;
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{new Integer(this.getNodeType()), this.getNodeName()});
        }
        String string2 = this.getNodeValue();
        while ((node = this.getFirstChild()) != null) {
            this.removeChild(node);
        }
        String string3 = string == null ? "" : string;
        node = this.getOwnerDocument().createTextNode(string3);
        this.appendChild(node);
        if (this.ownerElement != null) {
            this.ownerElement.fireDOMAttrModifiedEvent(this.nodeName, this, string2, string3, (short)1);
        }
    }

    public String getName() {
        return this.getNodeName();
    }

    public boolean getSpecified() {
        return !this.unspecified;
    }

    public void setSpecified(boolean bl) {
        this.unspecified = !bl;
    }

    public String getValue() {
        return this.getNodeValue();
    }

    public void setValue(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public void setOwnerElement(AbstractElement abstractElement) {
        this.ownerElement = abstractElement;
    }

    public Element getOwnerElement() {
        return this.ownerElement;
    }

    public TypeInfo getSchemaTypeInfo() {
        if (this.typeInfo == null) {
            this.typeInfo = new AttrTypeInfo();
        }
        return this.typeInfo;
    }

    public boolean isId() {
        return this.isIdAttr;
    }

    public void setIsId(boolean bl) {
        this.isIdAttr = bl;
    }

    protected void nodeAdded(Node node) {
        this.setSpecified(true);
    }

    protected void nodeToBeRemoved(Node node) {
        this.setSpecified(true);
    }

    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractAttr abstractAttr = (AbstractAttr)node;
        abstractAttr.nodeName = this.nodeName;
        abstractAttr.unspecified = false;
        abstractAttr.isIdAttr = abstractDocument.isId(abstractAttr);
        return node;
    }

    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractAttr abstractAttr = (AbstractAttr)node;
        abstractAttr.nodeName = this.nodeName;
        abstractAttr.unspecified = false;
        abstractAttr.isIdAttr = abstractDocument.isId(abstractAttr);
        return node;
    }

    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractAttr abstractAttr = (AbstractAttr)node;
        abstractAttr.nodeName = this.nodeName;
        abstractAttr.unspecified = this.unspecified;
        abstractAttr.isIdAttr = this.isIdAttr;
        return node;
    }

    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractAttr abstractAttr = (AbstractAttr)node;
        abstractAttr.nodeName = this.nodeName;
        abstractAttr.unspecified = this.unspecified;
        abstractAttr.isIdAttr = this.isIdAttr;
        return node;
    }

    protected void checkChildType(Node node, boolean bl) {
        switch (node.getNodeType()) {
            case 3: 
            case 5: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(node.getNodeType()), node.getNodeName()});
            }
        }
    }

    protected void fireDOMSubtreeModifiedEvent() {
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled()) {
            super.fireDOMSubtreeModifiedEvent();
            if (this.getOwnerElement() != null) {
                ((AbstractElement)this.getOwnerElement()).fireDOMSubtreeModifiedEvent();
            }
        }
    }

    public class AttrTypeInfo
    implements TypeInfo {
        public String getTypeNamespace() {
            return null;
        }

        public String getTypeName() {
            return null;
        }

        public boolean isDerivedFrom(String string, String string2, int n2) {
            return false;
        }
    }
}

