/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.ext.awt.geom.ExtendedShape;

public class ExtendedGeneralPath
implements ExtendedShape,
Cloneable {
    protected GeneralPath path;
    int numVals = 0;
    int numSeg = 0;
    float[] values = null;
    int[] types = null;
    float mx;
    float my;
    float cx;
    float cy;

    public ExtendedGeneralPath() {
        this.path = new GeneralPath();
    }

    public ExtendedGeneralPath(int n2) {
        this.path = new GeneralPath(n2);
    }

    public ExtendedGeneralPath(int n2, int n3) {
        this.path = new GeneralPath(n2, n3);
    }

    public ExtendedGeneralPath(Shape shape) {
        this();
        this.append(shape, false);
    }

    public synchronized void arcTo(float f2, float f3, float f4, boolean bl, boolean bl2, float f5, float f6) {
        if (f2 == 0.0f || f3 == 0.0f) {
            this.lineTo(f5, f6);
            return;
        }
        this.checkMoveTo();
        double d2 = this.cx;
        double d3 = this.cy;
        if (d2 == (double)f5 && d3 == (double)f6) {
            return;
        }
        Arc2D arc2D = ExtendedGeneralPath.computeArc(d2, d3, f2, f3, f4, bl, bl2, f5, f6);
        if (arc2D == null) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f4), arc2D.getCenterX(), arc2D.getCenterY());
        Shape shape = affineTransform.createTransformedShape(arc2D);
        this.path.append(shape, true);
        this.makeRoom(7);
        this.types[this.numSeg++] = 4321;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = f4;
        this.values[this.numVals++] = bl ? 1.0f : 0.0f;
        this.values[this.numVals++] = bl2 ? 1.0f : 0.0f;
        float f7 = f5;
        this.values[this.numVals++] = f7;
        this.cx = f7;
        float f8 = f6;
        this.values[this.numVals++] = f8;
        this.cy = f8;
    }

    public static Arc2D computeArc(double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, double d7, double d8) {
        double d9;
        double d10;
        double d11 = (d2 - d7) / 2.0;
        double d12 = (d3 - d8) / 2.0;
        d6 = Math.toRadians(d6 % 360.0);
        double d13 = Math.cos(d6);
        double d14 = Math.sin(d6);
        double d15 = d13 * d11 + d14 * d12;
        double d16 = -d14 * d11 + d13 * d12;
        double d17 = d15 * d15;
        double d18 = (d4 = Math.abs(d4)) * d4;
        double d19 = d17 / d18 + (d10 = d16 * d16) / (d9 = (d5 = Math.abs(d5)) * d5);
        if (d19 > 1.0) {
            d4 = Math.sqrt(d19) * d4;
            d5 = Math.sqrt(d19) * d5;
            d18 = d4 * d4;
            d9 = d5 * d5;
        }
        double d20 = bl == bl2 ? -1.0 : 1.0;
        double d21 = (d18 * d9 - d18 * d10 - d9 * d17) / (d18 * d10 + d9 * d17);
        d21 = d21 < 0.0 ? 0.0 : d21;
        double d22 = d20 * Math.sqrt(d21);
        double d23 = d22 * (d4 * d16 / d5);
        double d24 = d22 * -(d5 * d15 / d4);
        double d25 = (d2 + d7) / 2.0;
        double d26 = (d3 + d8) / 2.0;
        double d27 = d25 + (d13 * d23 - d14 * d24);
        double d28 = d26 + (d14 * d23 + d13 * d24);
        double d29 = (d15 - d23) / d4;
        double d30 = (d16 - d24) / d5;
        double d31 = (-d15 - d23) / d4;
        double d32 = (-d16 - d24) / d5;
        double d33 = Math.sqrt(d29 * d29 + d30 * d30);
        double d34 = d29;
        d20 = d30 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d20 * Math.acos(d34 / d33));
        d33 = Math.sqrt((d29 * d29 + d30 * d30) * (d31 * d31 + d32 * d32));
        d34 = d29 * d31 + d30 * d32;
        d20 = d29 * d32 - d30 * d31 < 0.0 ? -1.0 : 1.0;
        double d36 = Math.toDegrees(d20 * Math.acos(d34 / d33));
        if (!bl2 && d36 > 0.0) {
            d36 -= 360.0;
        } else if (bl2 && d36 < 0.0) {
            d36 += 360.0;
        }
        d36 %= 360.0;
        d35 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d27 - d4;
        double_.y = d28 - d5;
        double_.width = d4 * 2.0;
        double_.height = d5 * 2.0;
        double_.start = -d35;
        double_.extent = -d36;
        return double_;
    }

    public synchronized void moveTo(float f2, float f3) {
        this.makeRoom(2);
        this.types[this.numSeg++] = 0;
        float f4 = f2;
        this.values[this.numVals++] = f4;
        this.mx = f4;
        this.cx = f4;
        float f5 = f3;
        this.values[this.numVals++] = f5;
        this.my = f5;
        this.cy = f5;
    }

    public synchronized void lineTo(float f2, float f3) {
        this.checkMoveTo();
        this.path.lineTo(f2, f3);
        this.makeRoom(2);
        this.types[this.numSeg++] = 1;
        float f4 = f2;
        this.values[this.numVals++] = f4;
        this.cx = f4;
        float f5 = f3;
        this.values[this.numVals++] = f5;
        this.cy = f5;
    }

    public synchronized void quadTo(float f2, float f3, float f4, float f5) {
        this.checkMoveTo();
        this.path.quadTo(f2, f3, f4, f5);
        this.makeRoom(4);
        this.types[this.numSeg++] = 2;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        float f6 = f4;
        this.values[this.numVals++] = f6;
        this.cx = f6;
        float f7 = f5;
        this.values[this.numVals++] = f7;
        this.cy = f7;
    }

    public synchronized void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.checkMoveTo();
        this.path.curveTo(f2, f3, f4, f5, f6, f7);
        this.makeRoom(6);
        this.types[this.numSeg++] = 3;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = f4;
        this.values[this.numVals++] = f5;
        float f8 = f6;
        this.values[this.numVals++] = f8;
        this.cx = f8;
        float f9 = f7;
        this.values[this.numVals++] = f9;
        this.cy = f9;
    }

    public synchronized void closePath() {
        if (this.numSeg != 0 && this.types[this.numSeg - 1] == 4) {
            return;
        }
        if (this.numSeg != 0 && this.types[this.numSeg - 1] != 0) {
            this.path.closePath();
        }
        this.makeRoom(0);
        this.types[this.numSeg++] = 4;
        this.cx = this.mx;
        this.cy = this.my;
    }

    protected void checkMoveTo() {
        if (this.numSeg == 0) {
            return;
        }
        switch (this.types[this.numSeg - 1]) {
            case 0: {
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
            case 4: {
                if (this.numSeg == 1) {
                    return;
                }
                if (this.types[this.numSeg - 2] != 0) break;
                this.path.moveTo(this.values[this.numVals - 2], this.values[this.numVals - 1]);
                break;
            }
        }
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(new AffineTransform()), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            Arrays.fill(dArray, 0.0);
            int n2 = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (bl && this.numVals != 0) {
                if (n2 == 0) {
                    double d2 = dArray[0];
                    double d3 = dArray[1];
                    if (d2 != (double)this.cx || d3 != (double)this.cy) {
                        n2 = 1;
                    } else {
                        if (pathIterator.isDone()) break;
                        n2 = pathIterator.currentSegment(dArray);
                        pathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n2) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
                }
            }
        }
    }

    public void append(ExtendedPathIterator extendedPathIterator, boolean bl) {
        float[] fArray = new float[7];
        while (!extendedPathIterator.isDone()) {
            Arrays.fill(fArray, 0.0f);
            int n2 = extendedPathIterator.currentSegment(fArray);
            extendedPathIterator.next();
            if (bl && this.numVals != 0) {
                if (n2 == 0) {
                    float f2 = fArray[0];
                    float f3 = fArray[1];
                    if (f2 != this.cx || f3 != this.cy) {
                        n2 = 1;
                    } else {
                        if (extendedPathIterator.isDone()) break;
                        n2 = extendedPathIterator.currentSegment(fArray);
                        extendedPathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n2) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4321: {
                    this.arcTo(fArray[0], fArray[1], fArray[2], fArray[3] != 0.0f, fArray[4] != 0.0f, fArray[5], fArray[6]);
                }
            }
        }
    }

    public synchronized int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void setWindingRule(int n2) {
        this.path.setWindingRule(n2);
    }

    public synchronized Point2D getCurrentPoint() {
        if (this.numVals == 0) {
            return null;
        }
        return new Point2D.Double(this.cx, this.cy);
    }

    public synchronized void reset() {
        this.path.reset();
        this.numSeg = 0;
        this.numVals = 0;
        this.values = null;
        this.types = null;
    }

    public void transform(AffineTransform affineTransform) {
        if (affineTransform.getType() != 0) {
            throw new IllegalArgumentException("ExtendedGeneralPaths can not be transformed");
        }
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        return this.path.createTransformedShape(affineTransform);
    }

    public synchronized Rectangle getBounds() {
        return this.path.getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public boolean contains(double d2, double d3) {
        return this.path.contains(d2, d3);
    }

    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.path.contains(d2, d3, d4, d5);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.path.intersects(d2, d3, d4, d5);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.path.getPathIterator(affineTransform, d2);
    }

    public ExtendedPathIterator getExtendedPathIterator() {
        return new EPI();
    }

    public Object clone() {
        try {
            ExtendedGeneralPath extendedGeneralPath = (ExtendedGeneralPath)super.clone();
            extendedGeneralPath.path = (GeneralPath)this.path.clone();
            if (this.values != null) {
                extendedGeneralPath.values = new float[this.values.length];
                System.arraycopy(this.values, 0, extendedGeneralPath.values, 0, this.values.length);
            }
            extendedGeneralPath.numVals = this.numVals;
            if (this.types != null) {
                extendedGeneralPath.types = new int[this.types.length];
                System.arraycopy(this.types, 0, extendedGeneralPath.types, 0, this.types.length);
            }
            extendedGeneralPath.numSeg = this.numSeg;
            return extendedGeneralPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void makeRoom(int n2) {
        if (this.values == null) {
            this.values = new float[2 * n2];
            this.types = new int[2];
            this.numVals = 0;
            this.numSeg = 0;
            return;
        }
        int n3 = this.numVals + n2;
        if (n3 > this.values.length) {
            int n4 = this.values.length * 2;
            if (n4 < n3) {
                n4 = n3;
            }
            float[] fArray = new float[n4];
            System.arraycopy(this.values, 0, fArray, 0, this.numVals);
            this.values = fArray;
        }
        if (this.numSeg == this.types.length) {
            int[] nArray = new int[this.types.length * 2];
            System.arraycopy(this.types, 0, nArray, 0, this.types.length);
            this.types = nArray;
        }
    }

    class EPI
    implements ExtendedPathIterator {
        int segNum = 0;
        int valsIdx = 0;

        EPI() {
        }

        public int currentSegment() {
            return ExtendedGeneralPath.this.types[this.segNum];
        }

        public int currentSegment(double[] dArray) {
            int n2 = ExtendedGeneralPath.this.types[this.segNum];
            switch (n2) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    dArray[6] = ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n2;
        }

        public int currentSegment(float[] fArray) {
            int n2 = ExtendedGeneralPath.this.types[this.segNum];
            switch (n2) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    fArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    System.arraycopy(ExtendedGeneralPath.this.values, this.valsIdx, fArray, 0, 4);
                    break;
                }
                case 3: {
                    System.arraycopy(ExtendedGeneralPath.this.values, this.valsIdx, fArray, 0, 6);
                    break;
                }
                case 4321: {
                    System.arraycopy(ExtendedGeneralPath.this.values, this.valsIdx, fArray, 0, 7);
                }
            }
            return n2;
        }

        public int getWindingRule() {
            return ExtendedGeneralPath.this.path.getWindingRule();
        }

        public boolean isDone() {
            return this.segNum == ExtendedGeneralPath.this.numSeg;
        }

        public void next() {
            int n2 = ExtendedGeneralPath.this.types[this.segNum++];
            switch (n2) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    this.valsIdx += 2;
                    break;
                }
                case 2: {
                    this.valsIdx += 4;
                    break;
                }
                case 3: {
                    this.valsIdx += 6;
                    break;
                }
                case 4321: {
                    this.valsIdx += 7;
                }
            }
        }
    }
}

