/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.png.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.png.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class PNGTranscoderInternalCodecWriteAdapter
implements PNGTranscoder.WriteAdapter {
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        float f2;
        PNGEncodeParam pNGEncodeParam;
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n2 = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n2 = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n2 == 2 || n2 == 4 || n2 == 8)) {
            bufferedImage = IndexImage.getIndexedImage(bufferedImage, 1 << n2);
        }
        if ((pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam(bufferedImage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pNGEncodeParam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (transcodingHints.containsKey(PNGTranscoder.KEY_GAMMA)) {
            f2 = ((Float)transcodingHints.get(PNGTranscoder.KEY_GAMMA)).floatValue();
            if (f2 > 0.0f) {
                pNGEncodeParam.setGamma(f2);
            }
            pNGEncodeParam.setChromaticity(PNGTranscoder.DEFAULT_CHROMA);
        } else {
            pNGEncodeParam.setSRGBIntent(0);
        }
        f2 = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n3 = (int)((double)(1000.0f / f2) + 0.5);
        pNGEncodeParam.setPhysicalDimension(n3, n3, 1);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, pNGEncodeParam);
            pNGImageEncoder.encode(bufferedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

