/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.ConvolveMatrixRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class ConvolveMatrixRable8Bit
extends AbstractColorInterpolationRable
implements ConvolveMatrixRable {
    Kernel kernel;
    Point target;
    float bias;
    boolean kernelHasNegValues;
    PadMode edgeMode;
    float[] kernelUnitLength = new float[2];
    boolean preserveAlpha = false;

    public ConvolveMatrixRable8Bit(Filter filter) {
        super(filter);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setSource(Filter filter) {
        this.init(filter);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.touch();
        this.kernel = kernel;
        this.kernelHasNegValues = false;
        float[] fArray = kernel.getKernelData(null);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] < 0.0f)) continue;
            this.kernelHasNegValues = true;
            break;
        }
    }

    public Point getTarget() {
        return (Point)this.target.clone();
    }

    public void setTarget(Point point) {
        this.touch();
        this.target = (Point)point.clone();
    }

    public double getBias() {
        return this.bias;
    }

    public void setBias(double d2) {
        this.touch();
        this.bias = (float)d2;
    }

    public PadMode getEdgeMode() {
        return this.edgeMode;
    }

    public void setEdgeMode(PadMode padMode) {
        this.touch();
        this.edgeMode = padMode;
    }

    public double[] getKernelUnitLength() {
        if (this.kernelUnitLength == null) {
            return null;
        }
        double[] dArray = new double[]{this.kernelUnitLength[0], this.kernelUnitLength[1]};
        return dArray;
    }

    public void setKernelUnitLength(double[] dArray) {
        this.touch();
        if (dArray == null) {
            this.kernelUnitLength = null;
            return;
        }
        if (this.kernelUnitLength == null) {
            this.kernelUnitLength = new float[2];
        }
        this.kernelUnitLength[0] = (float)dArray[0];
        this.kernelUnitLength[1] = (float)dArray[1];
    }

    public boolean getPreserveAlpha() {
        return this.preserveAlpha;
    }

    public void setPreserveAlpha(boolean bl) {
        this.touch();
        this.preserveAlpha = bl;
    }

    public void fixAlpha(BufferedImage bufferedImage) {
        if (!bufferedImage.getColorModel().hasAlpha() || !bufferedImage.isAlphaPremultiplied()) {
            return;
        }
        if (GraphicsUtil.is_INT_PACK_Data(bufferedImage.getSampleModel(), true)) {
            this.fixAlpha_INT_PACK(bufferedImage.getRaster());
        } else {
            this.fixAlpha_FALLBACK(bufferedImage.getRaster());
        }
    }

    public void fixAlpha_INT_PACK(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n2 = writableRaster.getWidth();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        for (int i2 = 0; i2 < writableRaster.getHeight(); ++i2) {
            int n5;
            int n6 = n5 + n2;
            for (n5 = n4 + i2 * n3; n5 < n6; ++n5) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                int n9 = n7 >> 16 & 0xFF;
                if (n8 < n9) {
                    n8 = n9;
                }
                if (n8 < (n9 = n7 >> 8 & 0xFF)) {
                    n8 = n9;
                }
                if (n8 < (n9 = n7 & 0xFF)) {
                    n8 = n9;
                }
                nArray[n5] = n7 & 0xFFFFFF | n8 << 24;
            }
        }
    }

    public void fixAlpha_FALLBACK(WritableRaster writableRaster) {
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getMinY();
        int n5 = n4 + writableRaster.getHeight() - 1;
        int n6 = writableRaster.getNumBands();
        int[] nArray = null;
        for (int i2 = n4; i2 <= n5; ++i2) {
            nArray = writableRaster.getPixels(n2, i2, n3, 1, nArray);
            int n7 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n8 = nArray[n7];
                for (int i4 = 1; i4 < n6; ++i4) {
                    if (nArray[n7 + i4] <= n8) continue;
                    n8 = nArray[n7 + i4];
                }
                nArray[n7 + n6 - 1] = n8;
                n7 += n6;
            }
            writableRaster.setPixels(n2, i2, n3, 1, nArray);
        }
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        BufferedImage bufferedImage;
        Rectangle2D rectangle2D;
        Shape shape;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getScaleY();
        double d4 = affineTransform.getShearX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getTranslateX();
        double d7 = affineTransform.getTranslateY();
        double d8 = Math.sqrt(d2 * d2 + d5 * d5);
        double d9 = Math.sqrt(d3 * d3 + d4 * d4);
        if (this.kernelUnitLength != null) {
            if ((double)this.kernelUnitLength[0] > 0.0) {
                d8 = 1.0f / this.kernelUnitLength[0];
            }
            if ((double)this.kernelUnitLength[1] > 0.0) {
                d9 = 1.0f / this.kernelUnitLength[1];
            }
        }
        if ((shape = renderContext.getAreaOfInterest()) == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        int n2 = this.kernel.getWidth();
        int n3 = this.kernel.getHeight();
        int n4 = this.target.x;
        int n5 = this.target.y;
        double d10 = rectangle2D2.getX() - (double)n4 / d8;
        double d11 = rectangle2D2.getY() - (double)n5 / d9;
        double d12 = d10 + rectangle2D2.getWidth() + (double)(n2 - 1) / d8;
        double d13 = d11 + rectangle2D2.getHeight() + (double)(n3 - 1) / d9;
        rectangle2D2 = new Rectangle2D.Double(Math.floor(d10), Math.floor(d11), Math.ceil(d12 - Math.floor(d10)), Math.ceil(d13 - Math.floor(d11)));
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d8, d9);
        AffineTransform affineTransform3 = new AffineTransform(d2 / d8, d5 / d8, d4 / d9, d3 / d9, d6, d7);
        RenderedImage renderedImage = this.getSource().createRendering(new RenderContext(affineTransform2, rectangle2D2, renderingHints));
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = this.convertSourceCS(renderedImage);
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        rectangle2D2 = rectangle2D = shape2.getBounds2D();
        if (!(rectangle2D2 = new Rectangle2D.Double(Math.floor(rectangle2D2.getX() - (double)n4), Math.floor(rectangle2D2.getY() - (double)n5), Math.ceil(rectangle2D2.getX() + rectangle2D2.getWidth()) - Math.floor(rectangle2D2.getX()) + (double)(n2 - 1), Math.ceil(rectangle2D2.getY() + rectangle2D2.getHeight()) - Math.floor(rectangle2D2.getY()) + (double)(n3 - 1))).getBounds().equals(cachableRed.getBounds())) {
            if (this.edgeMode == PadMode.WRAP) {
                throw new IllegalArgumentException("edgeMode=\"wrap\" is not supported by ConvolveMatrix.");
            }
            cachableRed = new PadRed(cachableRed, rectangle2D2.getBounds(), this.edgeMode, renderingHints);
        }
        if ((double)this.bias != 0.0) {
            throw new IllegalArgumentException("Only bias equal to zero is supported in ConvolveMatrix.");
        }
        ConvolveOp convolveOp = new ConvolveOp(this.kernel, 1, renderingHints);
        ColorModel colorModel = cachableRed.getColorModel();
        Raster raster = cachableRed.getData();
        WritableRaster writableRaster = GraphicsUtil.makeRasterWritable(raster, 0, 0);
        int n6 = this.target.x - this.kernel.getXOrigin();
        int n7 = this.target.y - this.kernel.getYOrigin();
        int n8 = (int)(rectangle2D2.getX() + (double)n6);
        int n9 = (int)(rectangle2D2.getY() + (double)n7);
        if (!this.preserveAlpha) {
            colorModel = GraphicsUtil.coerceData(writableRaster, colorModel, true);
            BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            bufferedImage = convolveOp.filter(bufferedImage2, null);
            if (this.kernelHasNegValues) {
                this.fixAlpha(bufferedImage);
            }
        } else {
            BufferedImage bufferedImage3 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            colorModel = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
            BufferedImage bufferedImage4 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(writableRaster.getWidth(), writableRaster.getHeight()), colorModel.isAlphaPremultiplied(), null);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage4);
            ColorModel colorModel2 = GraphicsUtil.Linear_sRGB_Unpre;
            bufferedImage = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(writableRaster.getWidth(), writableRaster.getHeight()), colorModel2.isAlphaPremultiplied(), null);
            WritableRaster writableRaster2 = Raster.createWritableRaster(colorModel.createCompatibleSampleModel(writableRaster.getWidth(), writableRaster.getHeight()), bufferedImage.getRaster().getDataBuffer(), new Point(0, 0));
            BufferedImage bufferedImage5 = new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
            bufferedImage5 = convolveOp.filter(bufferedImage4, bufferedImage5);
            Rectangle rectangle = writableRaster.getBounds();
            Rectangle rectangle2 = new Rectangle(rectangle.x - n6, rectangle.y - n7, rectangle.width, rectangle.height);
            GraphicsUtil.copyBand(writableRaster, rectangle, writableRaster.getNumBands() - 1, bufferedImage.getRaster(), rectangle2, bufferedImage.getRaster().getNumBands() - 1);
        }
        cachableRed = new BufferedImageCachableRed(bufferedImage, n8, n9);
        cachableRed = new PadRed(cachableRed, rectangle2D.getBounds(), PadMode.ZERO_PAD, renderingHints);
        if (!affineTransform3.isIdentity()) {
            cachableRed = new AffineRed(cachableRed, affineTransform3, null);
        }
        return cachableRed;
    }
}

