/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FloodRed
extends AbstractRed {
    private WritableRaster raster;

    public FloodRed(Rectangle rectangle) {
        this(rectangle, new Color(0, 0, 0, 0));
    }

    public FloodRed(Rectangle rectangle, Paint paint) {
        int n2;
        ColorModel colorModel = GraphicsUtil.sRGB_Unpre;
        int n3 = AbstractTiledRed.getDefaultTileSize();
        int n4 = rectangle.width;
        if (n4 > n3) {
            n4 = n3;
        }
        if ((n2 = rectangle.height) > n3) {
            n2 = n3;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n4, n2);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, 0, 0, null);
        this.raster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(colorModel, this.raster, colorModel.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics2D.dispose();
    }

    public Raster getTile(int n2, int n3) {
        int n4 = this.tileGridXOff + n2 * this.tileWidth;
        int n5 = this.tileGridYOff + n3 * this.tileHeight;
        return this.raster.createTranslatedChild(n4, n5);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n2 = this.getXTile(writableRaster.getMinX());
        int n3 = this.getYTile(writableRaster.getMinY());
        int n4 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n5 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        for (int i2 = n3; i2 <= n5; ++i2) {
            for (int i3 = n2; i3 <= n4; ++i3) {
                Raster raster = this.getTile(i3, i2);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    continue;
                }
                GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
            }
        }
        return writableRaster;
    }
}

