/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class MorphologyOp
implements BufferedImageOp,
RasterOp {
    private int radiusX;
    private int radiusY;
    private boolean doDilation;
    private final int rangeX;
    private final int rangeY;
    private final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private final ColorSpace lRGB = ColorSpace.getInstance(1004);

    public MorphologyOp(int n2, int n3, boolean bl) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("The radius of X-axis or Y-axis should not be Zero or Negatives.");
        }
        this.radiusX = n2;
        this.radiusY = n3;
        this.doDilation = bl;
        this.rangeX = 2 * n2 + 1;
        this.rangeY = 2 * n3 + 1;
    }

    public Rectangle2D getBounds2D(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    private void checkCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (!colorSpace.equals(this.sRGB) && !colorSpace.equals(this.lRGB)) {
            throw new IllegalArgumentException("Expected CS_sRGB or CS_LINEAR_RGB color model");
        }
        if (!(colorModel instanceof DirectColorModel)) {
            throw new IllegalArgumentException("colorModel should be an instance of DirectColorModel");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("colorModel's transferType should be DataBuffer.TYPE_INT");
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            throw new IllegalArgumentException("red mask in source should be 0x00ff0000");
        }
        if (directColorModel.getGreenMask() != 65280) {
            throw new IllegalArgumentException("green mask in source should be 0x0000ff00");
        }
        if (directColorModel.getBlueMask() != 255) {
            throw new IllegalArgumentException("blue mask in source should be 0x000000ff");
        }
        if (directColorModel.getAlphaMask() != -16777216) {
            throw new IllegalArgumentException("alpha mask in source should be 0xff000000");
        }
    }

    private boolean isCompatible(ColorModel colorModel, SampleModel sampleModel) {
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace != ColorSpace.getInstance(1000) && colorSpace != ColorSpace.getInstance(1004)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000) {
            return false;
        }
        if (directColorModel.getGreenMask() != 65280) {
            return false;
        }
        if (directColorModel.getBlueMask() != 255) {
            return false;
        }
        return directColorModel.getAlphaMask() == -16777216;
    }

    private void checkCompatible(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using SinglePixelPackedSampleModels");
        }
        int n2 = sampleModel.getNumBands();
        if (n2 != 4) {
            throw new IllegalArgumentException("MorphologyOp only words with Rasters having 4 bands");
        }
        if (sampleModel.getDataType() != 3) {
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using DataBufferInt");
        }
        int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] % 8 == 0) continue;
            throw new IllegalArgumentException("MorphologyOp only works with Rasters using 8 bits per band : " + i2 + " : " + nArray[i2]);
        }
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        this.checkCompatible(raster.getSampleModel());
        return raster.createCompatibleWritableRaster();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2 = null;
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.checkCompatible(colorModel, writableRaster.getSampleModel());
        bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        return bufferedImage2;
    }

    static final boolean isBetter(int n2, int n3, boolean bl) {
        if (n2 > n3) {
            return bl;
        }
        if (n2 < n3) {
            return !bl;
        }
        return true;
    }

    private void specialProcessRow(Raster raster, WritableRaster writableRaster) {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n4 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n6 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n7 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        if (n2 <= this.radiusX) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n8;
                int n9 = n4 + i2 * n6;
                int n10 = n5 + i2 * n7;
                int n11 = nArray[n9++];
                int n12 = n11 >>> 24;
                int n13 = n11 & 0xFF0000;
                int n14 = n11 & 0xFF00;
                int n15 = n11 & 0xFF;
                for (n8 = 1; n8 < n2; ++n8) {
                    int n16 = nArray[n9++];
                    int n17 = n16 >>> 24;
                    int n18 = n16 & 0xFF0000;
                    int n19 = n16 & 0xFF00;
                    int n20 = n16 & 0xFF;
                    if (MorphologyOp.isBetter(n17, n12, this.doDilation)) {
                        n12 = n17;
                    }
                    if (MorphologyOp.isBetter(n18, n13, this.doDilation)) {
                        n13 = n18;
                    }
                    if (MorphologyOp.isBetter(n19, n14, this.doDilation)) {
                        n14 = n19;
                    }
                    if (!MorphologyOp.isBetter(n20, n15, this.doDilation)) continue;
                    n15 = n20;
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    nArray2[n10++] = n12 << 24 | n13 | n14 | n15;
                }
            }
        } else {
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            int[] nArray5 = new int[n2];
            int[] nArray6 = new int[n2];
            for (int i3 = 0; i3 < n3; ++i3) {
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                int n26 = n4 + i3 * n6;
                int n27 = n5 + i3 * n7;
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                int n31 = 0;
                int n32 = 0;
                int n33 = nArray[n26++];
                int n34 = n33 >>> 24;
                int n35 = n33 & 0xFF0000;
                int n36 = n33 & 0xFF00;
                int n37 = n33 & 0xFF;
                nArray3[0] = n34;
                nArray4[0] = n35;
                nArray5[0] = n36;
                nArray6[0] = n37;
                for (n25 = 1; n25 <= this.radiusX; ++n25) {
                    int n38 = nArray[n26++];
                    n24 = n38 >>> 24;
                    n23 = n38 & 0xFF0000;
                    n22 = n38 & 0xFF00;
                    n21 = n38 & 0xFF;
                    nArray3[n25] = n24;
                    nArray4[n25] = n23;
                    nArray5[n25] = n22;
                    nArray6[n25] = n21;
                    if (MorphologyOp.isBetter(n24, n34, this.doDilation)) {
                        n34 = n24;
                        n29 = n25;
                    }
                    if (MorphologyOp.isBetter(n23, n35, this.doDilation)) {
                        n35 = n23;
                        n30 = n25;
                    }
                    if (MorphologyOp.isBetter(n22, n36, this.doDilation)) {
                        n36 = n22;
                        n31 = n25;
                    }
                    if (!MorphologyOp.isBetter(n21, n37, this.doDilation)) continue;
                    n37 = n21;
                    n32 = n25;
                }
                nArray2[n27++] = n34 << 24 | n35 | n36 | n37;
                for (n25 = 1; n25 <= n2 - this.radiusX - 1; ++n25) {
                    int n39 = nArray[n26++];
                    n34 = nArray3[n29];
                    nArray3[n25 + this.radiusX] = n24 = n39 >>> 24;
                    if (MorphologyOp.isBetter(n24, n34, this.doDilation)) {
                        n34 = n24;
                        n29 = n25 + this.radiusX;
                    }
                    n35 = nArray4[n30];
                    nArray4[n25 + this.radiusX] = n23 = n39 & 0xFF0000;
                    if (MorphologyOp.isBetter(n23, n35, this.doDilation)) {
                        n35 = n23;
                        n30 = n25 + this.radiusX;
                    }
                    n36 = nArray5[n31];
                    nArray5[n25 + this.radiusX] = n22 = n39 & 0xFF00;
                    if (MorphologyOp.isBetter(n22, n36, this.doDilation)) {
                        n36 = n22;
                        n31 = n25 + this.radiusX;
                    }
                    n37 = nArray6[n32];
                    nArray6[n25 + this.radiusX] = n21 = n39 & 0xFF;
                    if (MorphologyOp.isBetter(n21, n37, this.doDilation)) {
                        n37 = n21;
                        n32 = n25 + this.radiusX;
                    }
                    nArray2[n27++] = n34 << 24 | n35 | n36 | n37;
                }
                for (n25 = n2 - this.radiusX; n25 <= this.radiusX; ++n25) {
                    nArray2[n27] = nArray2[n27 - 1];
                    ++n27;
                }
                for (n25 = this.radiusX + 1; n25 < n2; ++n25) {
                    int n40;
                    if (n29 == n28) {
                        n34 = nArray3[n28 + 1];
                        n29 = n28 + 1;
                        for (n40 = n28 + 2; n40 < n2; ++n40) {
                            n24 = nArray3[n40];
                            if (!MorphologyOp.isBetter(n24, n34, this.doDilation)) continue;
                            n34 = n24;
                            n29 = n40;
                        }
                    } else {
                        n34 = nArray3[n29];
                    }
                    if (n30 == n28) {
                        n35 = nArray4[n28 + 1];
                        n30 = n28 + 1;
                        for (n40 = n28 + 2; n40 < n2; ++n40) {
                            n23 = nArray4[n40];
                            if (!MorphologyOp.isBetter(n23, n35, this.doDilation)) continue;
                            n35 = n23;
                            n30 = n40;
                        }
                    } else {
                        n35 = nArray4[n30];
                    }
                    if (n31 == n28) {
                        n36 = nArray5[n28 + 1];
                        n31 = n28 + 1;
                        for (n40 = n28 + 2; n40 < n2; ++n40) {
                            n22 = nArray5[n40];
                            if (!MorphologyOp.isBetter(n22, n36, this.doDilation)) continue;
                            n36 = n22;
                            n31 = n40;
                        }
                    } else {
                        n36 = nArray5[n31];
                    }
                    if (n32 == n28) {
                        n37 = nArray6[n28 + 1];
                        n32 = n28 + 1;
                        for (n40 = n28 + 2; n40 < n2; ++n40) {
                            n21 = nArray6[n40];
                            if (!MorphologyOp.isBetter(n21, n37, this.doDilation)) continue;
                            n37 = n21;
                            n32 = n40;
                        }
                    } else {
                        n37 = nArray6[n32];
                    }
                    ++n28;
                    nArray2[n27++] = n34 << 24 | n35 | n36 | n37;
                }
            }
        }
    }

    private void specialProcessColumn(Raster raster, WritableRaster writableRaster) {
        int n2 = raster.getWidth();
        int n3 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = dataBufferInt.getOffset();
        int n5 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        if (n3 <= this.radiusY) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n6;
                int n7 = n4 + i2;
                int n8 = n4 + i2;
                int n9 = nArray[n8];
                n8 += n5;
                int n10 = n9 >>> 24;
                int n11 = n9 & 0xFF0000;
                int n12 = n9 & 0xFF00;
                int n13 = n9 & 0xFF;
                for (n6 = 1; n6 < n3; ++n6) {
                    int n14 = nArray[n8];
                    n8 += n5;
                    int n15 = n14 >>> 24;
                    int n16 = n14 & 0xFF0000;
                    int n17 = n14 & 0xFF00;
                    int n18 = n14 & 0xFF;
                    if (MorphologyOp.isBetter(n15, n10, this.doDilation)) {
                        n10 = n15;
                    }
                    if (MorphologyOp.isBetter(n16, n11, this.doDilation)) {
                        n11 = n16;
                    }
                    if (MorphologyOp.isBetter(n17, n12, this.doDilation)) {
                        n12 = n17;
                    }
                    if (!MorphologyOp.isBetter(n18, n13, this.doDilation)) continue;
                    n13 = n18;
                }
                for (n6 = 0; n6 < n3; ++n6) {
                    nArray[n7] = n10 << 24 | n11 | n12 | n13;
                    n7 += n5;
                }
            }
        } else {
            int[] nArray2 = new int[n3];
            int[] nArray3 = new int[n3];
            int[] nArray4 = new int[n3];
            int[] nArray5 = new int[n3];
            for (int i3 = 0; i3 < n2; ++i3) {
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24 = n4 + i3;
                int n25 = n4 + i3;
                int n26 = 0;
                int n27 = 0;
                int n28 = 0;
                int n29 = 0;
                int n30 = 0;
                int n31 = nArray[n25];
                n25 += n5;
                int n32 = n31 >>> 24;
                int n33 = n31 & 0xFF0000;
                int n34 = n31 & 0xFF00;
                int n35 = n31 & 0xFF;
                nArray2[0] = n32;
                nArray3[0] = n33;
                nArray4[0] = n34;
                nArray5[0] = n35;
                for (n23 = 1; n23 <= this.radiusY; ++n23) {
                    int n36 = nArray[n25];
                    n25 += n5;
                    n22 = n36 >>> 24;
                    n21 = n36 & 0xFF0000;
                    n20 = n36 & 0xFF00;
                    n19 = n36 & 0xFF;
                    nArray2[n23] = n22;
                    nArray3[n23] = n21;
                    nArray4[n23] = n20;
                    nArray5[n23] = n19;
                    if (MorphologyOp.isBetter(n22, n32, this.doDilation)) {
                        n32 = n22;
                        n27 = n23;
                    }
                    if (MorphologyOp.isBetter(n21, n33, this.doDilation)) {
                        n33 = n21;
                        n28 = n23;
                    }
                    if (MorphologyOp.isBetter(n20, n34, this.doDilation)) {
                        n34 = n20;
                        n29 = n23;
                    }
                    if (!MorphologyOp.isBetter(n19, n35, this.doDilation)) continue;
                    n35 = n19;
                    n30 = n23;
                }
                nArray[n24] = n32 << 24 | n33 | n34 | n35;
                n24 += n5;
                for (n23 = 1; n23 <= n3 - this.radiusY - 1; ++n23) {
                    int n37 = nArray[n25];
                    n25 += n5;
                    n32 = nArray2[n27];
                    nArray2[n23 + this.radiusY] = n22 = n37 >>> 24;
                    if (MorphologyOp.isBetter(n22, n32, this.doDilation)) {
                        n32 = n22;
                        n27 = n23 + this.radiusY;
                    }
                    n33 = nArray3[n28];
                    nArray3[n23 + this.radiusY] = n21 = n37 & 0xFF0000;
                    if (MorphologyOp.isBetter(n21, n33, this.doDilation)) {
                        n33 = n21;
                        n28 = n23 + this.radiusY;
                    }
                    n34 = nArray4[n29];
                    nArray4[n23 + this.radiusY] = n20 = n37 & 0xFF00;
                    if (MorphologyOp.isBetter(n20, n34, this.doDilation)) {
                        n34 = n20;
                        n29 = n23 + this.radiusY;
                    }
                    n35 = nArray5[n30];
                    nArray5[n23 + this.radiusY] = n19 = n37 & 0xFF;
                    if (MorphologyOp.isBetter(n19, n35, this.doDilation)) {
                        n35 = n19;
                        n30 = n23 + this.radiusY;
                    }
                    nArray[n24] = n32 << 24 | n33 | n34 | n35;
                    n24 += n5;
                }
                for (n23 = n3 - this.radiusY; n23 <= this.radiusY; ++n23) {
                    nArray[n24] = nArray[n24 - n5];
                    n24 += n5;
                }
                for (n23 = this.radiusY + 1; n23 < n3; ++n23) {
                    int n38;
                    if (n27 == n26) {
                        n32 = nArray2[n26 + 1];
                        n27 = n26 + 1;
                        for (n38 = n26 + 2; n38 < n3; ++n38) {
                            n22 = nArray2[n38];
                            if (!MorphologyOp.isBetter(n22, n32, this.doDilation)) continue;
                            n32 = n22;
                            n27 = n38;
                        }
                    } else {
                        n32 = nArray2[n27];
                    }
                    if (n28 == n26) {
                        n33 = nArray3[n26 + 1];
                        n28 = n26 + 1;
                        for (n38 = n26 + 2; n38 < n3; ++n38) {
                            n21 = nArray3[n38];
                            if (!MorphologyOp.isBetter(n21, n33, this.doDilation)) continue;
                            n33 = n21;
                            n28 = n38;
                        }
                    } else {
                        n33 = nArray3[n28];
                    }
                    if (n29 == n26) {
                        n34 = nArray4[n26 + 1];
                        n29 = n26 + 1;
                        for (n38 = n26 + 2; n38 < n3; ++n38) {
                            n20 = nArray4[n38];
                            if (!MorphologyOp.isBetter(n20, n34, this.doDilation)) continue;
                            n34 = n20;
                            n29 = n38;
                        }
                    } else {
                        n34 = nArray4[n29];
                    }
                    if (n30 == n26) {
                        n35 = nArray5[n26 + 1];
                        n30 = n26 + 1;
                        for (n38 = n26 + 2; n38 < n3; ++n38) {
                            n19 = nArray5[n38];
                            if (!MorphologyOp.isBetter(n19, n35, this.doDilation)) continue;
                            n35 = n19;
                            n30 = n38;
                        }
                    } else {
                        n35 = nArray5[n30];
                    }
                    ++n26;
                    nArray[n24] = n32 << 24 | n33 | n34 | n35;
                    n24 += n5;
                }
            }
        }
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (writableRaster != null) {
            this.checkCompatible(writableRaster.getSampleModel());
        } else {
            if (raster == null) {
                throw new IllegalArgumentException("src should not be null when dest is null");
            }
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        int n26 = raster.getWidth();
        int n27 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n28 = dataBufferInt.getOffset();
        int n29 = dataBufferInt2.getOffset();
        int n30 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n31 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int[] nArray5 = dataBufferInt.getBankData()[0];
        int[] nArray6 = dataBufferInt2.getBankData()[0];
        if (n26 <= 2 * this.radiusX) {
            this.specialProcessRow(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeX];
            nArray3 = new int[this.rangeX];
            nArray2 = new int[this.rangeX];
            nArray = new int[this.rangeX];
            for (n25 = 0; n25 < n27; ++n25) {
                int n32 = n28 + n25 * n30;
                n24 = n29 + n25 * n31;
                n23 = 0;
                n22 = 0;
                n21 = 0;
                n20 = 0;
                n19 = 0;
                n18 = nArray5[n32++];
                n17 = n18 >>> 24;
                n16 = n18 & 0xFF0000;
                n15 = n18 & 0xFF00;
                n14 = n18 & 0xFF;
                nArray4[0] = n17;
                nArray3[0] = n16;
                nArray2[0] = n15;
                nArray[0] = n14;
                for (n13 = 1; n13 <= this.radiusX; ++n13) {
                    n12 = nArray5[n32++];
                    n11 = n12 >>> 24;
                    n10 = n12 & 0xFF0000;
                    n9 = n12 & 0xFF00;
                    n8 = n12 & 0xFF;
                    nArray4[n13] = n11;
                    nArray3[n13] = n10;
                    nArray2[n13] = n9;
                    nArray[n13] = n8;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n13;
                    }
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n13;
                    }
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n13;
                    }
                    if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                    n14 = n8;
                    n19 = n13;
                }
                nArray6[n24++] = n17 << 24 | n16 | n15 | n14;
                for (n13 = 1; n13 <= this.radiusX; ++n13) {
                    n7 = nArray5[n32++];
                    n17 = nArray4[n22];
                    nArray4[n13 + this.radiusX] = n11 = n7 >>> 24;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n13 + this.radiusX;
                    }
                    n16 = nArray3[n21];
                    nArray3[n13 + this.radiusX] = n10 = n7 & 0xFF0000;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n13 + this.radiusX;
                    }
                    n15 = nArray2[n20];
                    nArray2[n13 + this.radiusX] = n9 = n7 & 0xFF00;
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n13 + this.radiusX;
                    }
                    n14 = nArray[n19];
                    nArray[n13 + this.radiusX] = n8 = n7 & 0xFF;
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n13 + this.radiusX;
                    }
                    nArray6[n24++] = n17 << 24 | n16 | n15 | n14;
                }
                for (n13 = this.radiusX + 1; n13 <= n26 - 1 - this.radiusX; ++n13) {
                    n7 = nArray5[n32++];
                    n11 = n7 >>> 24;
                    n10 = n7 & 0xFF0000;
                    n9 = n7 & 0xFF00;
                    n8 = n7 & 0xFF;
                    nArray4[n23] = n11;
                    nArray3[n23] = n10;
                    nArray2[n23] = n9;
                    nArray[n23] = n8;
                    if (n22 == n23) {
                        n17 = nArray4[0];
                        n22 = 0;
                        for (n6 = 1; n6 < this.rangeX; ++n6) {
                            n11 = nArray4[n6];
                            if (!MorphologyOp.isBetter(n11, n17, this.doDilation)) continue;
                            n17 = n11;
                            n22 = n6;
                        }
                    } else {
                        n17 = nArray4[n22];
                        if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                            n17 = n11;
                            n22 = n23;
                        }
                    }
                    if (n21 == n23) {
                        n16 = nArray3[0];
                        n21 = 0;
                        for (n6 = 1; n6 < this.rangeX; ++n6) {
                            n10 = nArray3[n6];
                            if (!MorphologyOp.isBetter(n10, n16, this.doDilation)) continue;
                            n16 = n10;
                            n21 = n6;
                        }
                    } else {
                        n16 = nArray3[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n23;
                        }
                    }
                    if (n20 == n23) {
                        n15 = nArray2[0];
                        n20 = 0;
                        for (n6 = 1; n6 < this.rangeX; ++n6) {
                            n9 = nArray2[n6];
                            if (!MorphologyOp.isBetter(n9, n15, this.doDilation)) continue;
                            n15 = n9;
                            n20 = n6;
                        }
                    } else {
                        n15 = nArray2[n20];
                        if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                            n15 = n9;
                            n20 = n23;
                        }
                    }
                    if (n19 == n23) {
                        n14 = nArray[0];
                        n19 = 0;
                        for (n6 = 1; n6 < this.rangeX; ++n6) {
                            n8 = nArray[n6];
                            if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                            n14 = n8;
                            n19 = n6;
                        }
                    } else {
                        n14 = nArray[n19];
                        if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                            n14 = n8;
                            n19 = n23;
                        }
                    }
                    nArray6[n24++] = n17 << 24 | n16 | n15 | n14;
                    n23 = (n23 + 1) % this.rangeX;
                }
                n6 = n23 == 0 ? this.rangeX - 1 : n23 - 1;
                n5 = this.rangeX - 1;
                for (n4 = n26 - this.radiusX; n4 < n26; ++n4) {
                    n13 = (n23 + 1) % this.rangeX;
                    if (n22 == n23) {
                        n17 = nArray4[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n11 = nArray4[n3];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeX;
                        }
                    }
                    if (n21 == n23) {
                        n16 = nArray3[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n10 = nArray3[n3];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeX;
                        }
                    }
                    if (n20 == n23) {
                        n15 = nArray2[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n9 = nArray2[n3];
                            if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                                n15 = n9;
                                n20 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeX;
                        }
                    }
                    if (n19 == n23) {
                        n14 = nArray[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n8 = nArray[n3];
                            if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                                n14 = n8;
                                n19 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeX;
                        }
                    }
                    nArray6[n24++] = n17 << 24 | n16 | n15 | n14;
                    n23 = (n23 + 1) % this.rangeX;
                    --n5;
                }
            }
        }
        if (n27 <= 2 * this.radiusY) {
            this.specialProcessColumn(raster, writableRaster);
        } else {
            nArray4 = new int[this.rangeY];
            nArray3 = new int[this.rangeY];
            nArray2 = new int[this.rangeY];
            nArray = new int[this.rangeY];
            for (n25 = 0; n25 < n26; ++n25) {
                n24 = n29 + n25;
                int n33 = n29 + n25;
                n23 = 0;
                n22 = 0;
                n21 = 0;
                n20 = 0;
                n19 = 0;
                n18 = nArray6[n33];
                n33 += n31;
                n17 = n18 >>> 24;
                n16 = n18 & 0xFF0000;
                n15 = n18 & 0xFF00;
                n14 = n18 & 0xFF;
                nArray4[0] = n17;
                nArray3[0] = n16;
                nArray2[0] = n15;
                nArray[0] = n14;
                for (n13 = 1; n13 <= this.radiusY; ++n13) {
                    n12 = nArray6[n33];
                    n33 += n31;
                    n11 = n12 >>> 24;
                    n10 = n12 & 0xFF0000;
                    n9 = n12 & 0xFF00;
                    n8 = n12 & 0xFF;
                    nArray4[n13] = n11;
                    nArray3[n13] = n10;
                    nArray2[n13] = n9;
                    nArray[n13] = n8;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n13;
                    }
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n13;
                    }
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n13;
                    }
                    if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                    n14 = n8;
                    n19 = n13;
                }
                nArray6[n24] = n17 << 24 | n16 | n15 | n14;
                n24 += n31;
                for (n13 = 1; n13 <= this.radiusY; ++n13) {
                    n6 = n13 + this.radiusY;
                    n7 = nArray6[n33];
                    n33 += n31;
                    n17 = nArray4[n22];
                    nArray4[n6] = n11 = n7 >>> 24;
                    if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                        n17 = n11;
                        n22 = n6;
                    }
                    n16 = nArray3[n21];
                    nArray3[n6] = n10 = n7 & 0xFF0000;
                    if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                        n16 = n10;
                        n21 = n6;
                    }
                    n15 = nArray2[n20];
                    nArray2[n6] = n9 = n7 & 0xFF00;
                    if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                        n15 = n9;
                        n20 = n6;
                    }
                    n14 = nArray[n19];
                    nArray[n6] = n8 = n7 & 0xFF;
                    if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                        n14 = n8;
                        n19 = n6;
                    }
                    nArray6[n24] = n17 << 24 | n16 | n15 | n14;
                    n24 += n31;
                }
                for (n13 = this.radiusY + 1; n13 <= n27 - 1 - this.radiusY; ++n13) {
                    n7 = nArray6[n33];
                    n33 += n31;
                    n11 = n7 >>> 24;
                    n10 = n7 & 0xFF0000;
                    n9 = n7 & 0xFF00;
                    n8 = n7 & 0xFF;
                    nArray4[n23] = n11;
                    nArray3[n23] = n10;
                    nArray2[n23] = n9;
                    nArray[n23] = n8;
                    if (n22 == n23) {
                        n17 = nArray4[0];
                        n22 = 0;
                        for (n6 = 1; n6 <= 2 * this.radiusY; ++n6) {
                            n11 = nArray4[n6];
                            if (!MorphologyOp.isBetter(n11, n17, this.doDilation)) continue;
                            n17 = n11;
                            n22 = n6;
                        }
                    } else {
                        n17 = nArray4[n22];
                        if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                            n17 = n11;
                            n22 = n23;
                        }
                    }
                    if (n21 == n23) {
                        n16 = nArray3[0];
                        n21 = 0;
                        for (n6 = 1; n6 <= 2 * this.radiusY; ++n6) {
                            n10 = nArray3[n6];
                            if (!MorphologyOp.isBetter(n10, n16, this.doDilation)) continue;
                            n16 = n10;
                            n21 = n6;
                        }
                    } else {
                        n16 = nArray3[n21];
                        if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                            n16 = n10;
                            n21 = n23;
                        }
                    }
                    if (n20 == n23) {
                        n15 = nArray2[0];
                        n20 = 0;
                        for (n6 = 1; n6 <= 2 * this.radiusY; ++n6) {
                            n9 = nArray2[n6];
                            if (!MorphologyOp.isBetter(n9, n15, this.doDilation)) continue;
                            n15 = n9;
                            n20 = n6;
                        }
                    } else {
                        n15 = nArray2[n20];
                        if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                            n15 = n9;
                            n20 = n23;
                        }
                    }
                    if (n19 == n23) {
                        n14 = nArray[0];
                        n19 = 0;
                        for (n6 = 1; n6 <= 2 * this.radiusY; ++n6) {
                            n8 = nArray[n6];
                            if (!MorphologyOp.isBetter(n8, n14, this.doDilation)) continue;
                            n14 = n8;
                            n19 = n6;
                        }
                    } else {
                        n14 = nArray[n19];
                        if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                            n14 = n8;
                            n19 = n23;
                        }
                    }
                    nArray6[n24] = n17 << 24 | n16 | n15 | n14;
                    n24 += n31;
                    n23 = (n23 + 1) % this.rangeY;
                }
                n6 = n23 == 0 ? 2 * this.radiusY : n23 - 1;
                n5 = this.rangeY - 1;
                for (n4 = n27 - this.radiusY; n4 < n27 - 1; ++n4) {
                    n13 = (n23 + 1) % this.rangeY;
                    if (n22 == n23) {
                        n17 = nArray4[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n11 = nArray4[n3];
                            if (MorphologyOp.isBetter(n11, n17, this.doDilation)) {
                                n17 = n11;
                                n22 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeY;
                        }
                    }
                    if (n21 == n23) {
                        n16 = nArray3[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n10 = nArray3[n3];
                            if (MorphologyOp.isBetter(n10, n16, this.doDilation)) {
                                n16 = n10;
                                n21 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeY;
                        }
                    }
                    if (n20 == n23) {
                        n15 = nArray2[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n9 = nArray2[n3];
                            if (MorphologyOp.isBetter(n9, n15, this.doDilation)) {
                                n15 = n9;
                                n20 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeY;
                        }
                    }
                    if (n19 == n23) {
                        n14 = nArray[n6];
                        n3 = n13;
                        for (n2 = 1; n2 < n5; ++n2) {
                            n8 = nArray[n3];
                            if (MorphologyOp.isBetter(n8, n14, this.doDilation)) {
                                n14 = n8;
                                n19 = n3;
                            }
                            n3 = (n3 + 1) % this.rangeY;
                        }
                    }
                    nArray6[n24] = n17 << 24 | n16 | n15 | n14;
                    n24 += n31;
                    n23 = (n23 + 1) % this.rangeY;
                    --n5;
                }
            }
        }
        return writableRaster;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorModel colorModel;
        ColorModel colorModel2;
        if (bufferedImage == null) {
            throw new NullPointerException("Source image should not be null");
        }
        BufferedImage bufferedImage3 = bufferedImage;
        BufferedImage bufferedImage4 = bufferedImage2;
        if (!this.isCompatible(bufferedImage.getColorModel(), bufferedImage.getSampleModel())) {
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        } else if (!bufferedImage.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage = new BufferedImage(colorModel, bufferedImage.getRaster(), true, null);
            GraphicsUtil.copyData(bufferedImage3, bufferedImage);
        }
        if (bufferedImage2 == null) {
            bufferedImage4 = bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!this.isCompatible(bufferedImage2.getColorModel(), bufferedImage2.getSampleModel())) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        } else if (!bufferedImage2.isAlphaPremultiplied()) {
            colorModel2 = bufferedImage2.getColorModel();
            colorModel = GraphicsUtil.coerceColorModel(colorModel2, true);
            bufferedImage2 = new BufferedImage(colorModel, bufferedImage4.getRaster(), true, null);
        }
        this.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        if (bufferedImage.getRaster() == bufferedImage3.getRaster() && bufferedImage.isAlphaPremultiplied() != bufferedImage3.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage, bufferedImage3);
        }
        if (bufferedImage2.getRaster() != bufferedImage4.getRaster() || bufferedImage2.isAlphaPremultiplied() != bufferedImage4.isAlphaPremultiplied()) {
            GraphicsUtil.copyData(bufferedImage2, bufferedImage4);
        }
        return bufferedImage4;
    }
}

