/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.apache.batik.ext.swing.GridBagConstants;

public class JGridBagPanel
extends JPanel
implements GridBagConstants {
    public static final InsetsManager ZERO_INSETS = new ZeroInsetsManager();
    public static final InsetsManager DEFAULT_INSETS = new DefaultInsetsManager();
    public InsetsManager insetsManager;

    public JGridBagPanel() {
        this(new DefaultInsetsManager());
    }

    public JGridBagPanel(InsetsManager insetsManager) {
        super(new GridBagLayout());
        this.insetsManager = insetsManager != null ? insetsManager : new DefaultInsetsManager();
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof GridBagLayout) {
            super.setLayout(layoutManager);
        }
    }

    public void add(Component component, int n2, int n3, int n4, int n5, int n6, int n7, double d2, double d3) {
        Insets insets = this.insetsManager.getInsets(n2, n3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n7;
        gridBagConstraints.weightx = d2;
        gridBagConstraints.weighty = d3;
        gridBagConstraints.insets = insets;
        this.add(component, gridBagConstraints);
    }

    private static class DefaultInsetsManager
    implements InsetsManager {
        int leftInset = 5;
        int topInset = 5;
        public Insets positiveInsets = new Insets(this.topInset, this.leftInset, 0, 0);
        public Insets leftInsets = new Insets(this.topInset, 0, 0, 0);
        public Insets topInsets = new Insets(0, this.leftInset, 0, 0);
        public Insets topLeftInsets = new Insets(0, 0, 0, 0);

        private DefaultInsetsManager() {
        }

        public Insets getInsets(int n2, int n3) {
            if (n2 > 0) {
                if (n3 > 0) {
                    return this.positiveInsets;
                }
                return this.topInsets;
            }
            if (n3 > 0) {
                return this.leftInsets;
            }
            return this.topLeftInsets;
        }
    }

    private static class ZeroInsetsManager
    implements InsetsManager {
        private Insets insets = new Insets(0, 0, 0, 0);

        private ZeroInsetsManager() {
        }

        public Insets getInsets(int n2, int n3) {
            return this.insets;
        }
    }

    public static interface InsetsManager {
        public Insets getInsets(int var1, int var2);
    }
}

