/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class BatikStarElementBridge
extends SVGDecoratedShapeElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "star";
    }

    public Bridge getInstance() {
        return new BatikStarElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "cx");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "cx", context);
        }
        string = element.getAttributeNS(null, "cy");
        float f3 = 0.0f;
        if (string.length() != 0) {
            f3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "cy", context);
        }
        if ((string = element.getAttributeNS(null, "r")).length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"r", string});
        }
        float f4 = UnitProcessor.svgOtherLengthToUserSpace(string, "r", context);
        string = element.getAttributeNS(null, "ir");
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"ir", string});
        }
        float f5 = UnitProcessor.svgOtherLengthToUserSpace(string, "ir", context);
        int n2 = BatikStarElementBridge.convertSides(element, "sides", 3, bridgeContext);
        GeneralPath generalPath = new GeneralPath();
        double d2 = Math.PI * 2 / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = (double)i2 * d2 - 1.5707963267948966;
            double d4 = (double)f2 + (double)f5 * Math.cos(d3);
            double d5 = (double)f3 - (double)f5 * Math.sin(d3);
            if (i2 == 0) {
                generalPath.moveTo((float)d4, (float)d5);
            } else {
                generalPath.lineTo((float)d4, (float)d5);
            }
            d3 = ((double)i2 + 0.5) * d2 - 1.5707963267948966;
            d4 = (double)f2 + (double)f4 * Math.cos(d3);
            d5 = (double)f3 - (double)f4 * Math.sin(d3);
            generalPath.lineTo((float)d4, (float)d5);
        }
        generalPath.closePath();
        shapeNode.setShape(generalPath);
    }

    protected static int convertSides(Element element, String string, int n2, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n2;
        }
        int n3 = 0;
        try {
            n3 = SVGUtilities.convertSVGInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
        }
        if (n3 < 3) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{string, string2});
        }
        return n3;
    }
}

