/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class HistogramRed
extends AbstractRed {
    boolean[] computed;
    int tallied = 0;
    int[] bins = new int[256];

    public HistogramRed(CachableRed cachableRed) {
        super(cachableRed, null);
        int n2 = this.getNumXTiles() * this.getNumYTiles();
        this.computed = new boolean[n2];
    }

    public void tallyTile(Raster raster) {
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int[] nArray = null;
        for (int i2 = n3; i2 < n3 + n5; ++i2) {
            nArray = raster.getPixels(n2, i2, n4, 1, nArray);
            for (int i3 = 0; i3 < 3 * n4; ++i3) {
                int n6 = nArray[i3++] * 5;
                n6 += nArray[i3++] * 9;
                int n7 = (n6 += nArray[i3++] * 2) >> 4;
                this.bins[n7] = this.bins[n7] + 1;
            }
        }
        ++this.tallied;
    }

    public int[] getHistogram() {
        if (this.tallied == this.computed.length) {
            return this.bins;
        }
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        int n2 = cachableRed.getMinTileY();
        int n3 = cachableRed.getNumXTiles();
        int n4 = cachableRed.getMinTileX();
        for (int i2 = 0; i2 < cachableRed.getNumYTiles(); ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n5 = i3 + n4 + i2 * n3;
                if (this.computed[n5]) continue;
                Raster raster = cachableRed.getTile(i3 + n4, i2 + n2);
                this.tallyTile(raster);
                this.computed[n5] = true;
            }
        }
        return this.bins;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRaster(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n2, int n3) {
        int n4 = n3 - this.getMinTileY();
        int n5 = n2 - this.getMinTileX();
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Raster raster = cachableRed.getTile(n2, n3);
        int n6 = n5 + n4 * this.getNumXTiles();
        if (this.computed[n6]) {
            return raster;
        }
        this.tallyTile(raster);
        this.computed[n6] = true;
        return raster;
    }
}

