/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.ext.awt.geom.ExtendedShape;
import org.apache.batik.ext.awt.geom.ShapeExtender;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.ProxyGraphicsNode;
import org.apache.batik.gvt.ShapePainter;

public class MarkerShapePainter
implements ShapePainter {
    protected ExtendedShape extShape;
    protected Marker startMarker;
    protected Marker middleMarker;
    protected Marker endMarker;
    private ProxyGraphicsNode startMarkerProxy;
    private ProxyGraphicsNode[] middleMarkerProxies;
    private ProxyGraphicsNode endMarkerProxy;
    private CompositeGraphicsNode markerGroup;
    private Rectangle2D dPrimitiveBounds;
    private Rectangle2D dGeometryBounds;

    public MarkerShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.extShape = shape instanceof ExtendedShape ? (ExtendedShape)shape : new ShapeExtender(shape);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.markerGroup == null) {
            this.buildMarkerGroup();
        }
        if (this.markerGroup.getChildren().size() > 0) {
            this.markerGroup.paint(graphics2D);
        }
    }

    public Shape getPaintedArea() {
        if (this.markerGroup == null) {
            this.buildMarkerGroup();
        }
        return this.markerGroup.getOutline();
    }

    public Rectangle2D getPaintedBounds2D() {
        if (this.markerGroup == null) {
            this.buildMarkerGroup();
        }
        return this.markerGroup.getPrimitiveBounds();
    }

    public boolean inPaintedArea(Point2D point2D) {
        GraphicsNode graphicsNode;
        if (this.markerGroup == null) {
            this.buildMarkerGroup();
        }
        return (graphicsNode = this.markerGroup.nodeHitAt(point2D)) != null;
    }

    public Shape getSensitiveArea() {
        return null;
    }

    public Rectangle2D getSensitiveBounds2D() {
        return null;
    }

    public boolean inSensitiveArea(Point2D point2D) {
        return false;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.extShape = shape instanceof ExtendedShape ? (ExtendedShape)shape : new ShapeExtender(shape);
        this.startMarkerProxy = null;
        this.middleMarkerProxies = null;
        this.endMarkerProxy = null;
        this.markerGroup = null;
    }

    public ExtendedShape getExtShape() {
        return this.extShape;
    }

    public Shape getShape() {
        return this.extShape;
    }

    public Marker getStartMarker() {
        return this.startMarker;
    }

    public void setStartMarker(Marker marker) {
        this.startMarker = marker;
        this.startMarkerProxy = null;
        this.markerGroup = null;
    }

    public Marker getMiddleMarker() {
        return this.middleMarker;
    }

    public void setMiddleMarker(Marker marker) {
        this.middleMarker = marker;
        this.middleMarkerProxies = null;
        this.markerGroup = null;
    }

    public Marker getEndMarker() {
        return this.endMarker;
    }

    public void setEndMarker(Marker marker) {
        this.endMarker = marker;
        this.endMarkerProxy = null;
        this.markerGroup = null;
    }

    protected void buildMarkerGroup() {
        if (this.startMarker != null && this.startMarkerProxy == null) {
            this.startMarkerProxy = this.buildStartMarkerProxy();
        }
        if (this.middleMarker != null && this.middleMarkerProxies == null) {
            this.middleMarkerProxies = this.buildMiddleMarkerProxies();
        }
        if (this.endMarker != null && this.endMarkerProxy == null) {
            this.endMarkerProxy = this.buildEndMarkerProxy();
        }
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        List list = compositeGraphicsNode.getChildren();
        if (this.startMarkerProxy != null) {
            list.add(this.startMarkerProxy);
        }
        if (this.middleMarkerProxies != null) {
            for (int i2 = 0; i2 < this.middleMarkerProxies.length; ++i2) {
                list.add(this.middleMarkerProxies[i2]);
            }
        }
        if (this.endMarkerProxy != null) {
            list.add(this.endMarkerProxy);
        }
        this.markerGroup = compositeGraphicsNode;
    }

    protected ProxyGraphicsNode buildStartMarkerProxy() {
        Object object;
        ExtendedPathIterator extendedPathIterator = this.getExtShape().getExtendedPathIterator();
        double[] dArray = new double[7];
        int n2 = 0;
        if (extendedPathIterator.isDone()) {
            return null;
        }
        n2 = extendedPathIterator.currentSegment(dArray);
        if (n2 != 0) {
            return null;
        }
        extendedPathIterator.next();
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        double d2 = this.startMarker.getOrient();
        if (Double.isNaN(d2) && !extendedPathIterator.isDone()) {
            object = new double[7];
            int n3 = 0;
            n3 = extendedPathIterator.currentSegment((double[])object);
            if (n3 == 4) {
                n3 = 1;
                object[0] = dArray[0];
                object[1] = dArray[1];
            }
            d2 = this.computeRotation(null, 0, dArray, n2, (double[])object, n3);
        }
        object = this.computeMarkerTransform(this.startMarker, double_, d2);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.startMarker.getMarkerNode());
        proxyGraphicsNode.setTransform((AffineTransform)object);
        return proxyGraphicsNode;
    }

    protected ProxyGraphicsNode buildEndMarkerProxy() {
        ExtendedPathIterator extendedPathIterator = this.getExtShape().getExtendedPathIterator();
        int n2 = 0;
        if (extendedPathIterator.isDone()) {
            return null;
        }
        double[] dArray = new double[7];
        double[] dArray2 = new double[2];
        int n3 = 0;
        n3 = extendedPathIterator.currentSegment(dArray);
        if (n3 != 0) {
            return null;
        }
        ++n2;
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1];
        extendedPathIterator.next();
        double[] dArray3 = new double[7];
        double[] dArray4 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6]};
        double[] dArray5 = null;
        int n4 = n3;
        int n5 = 0;
        while (!extendedPathIterator.isDone()) {
            dArray5 = dArray3;
            dArray3 = dArray4;
            dArray4 = dArray5;
            n5 = n4;
            n4 = extendedPathIterator.currentSegment(dArray4);
            if (n4 == 0) {
                dArray2[0] = dArray4[0];
                dArray2[1] = dArray4[1];
            } else if (n4 == 4) {
                n4 = 1;
                dArray4[0] = dArray2[0];
                dArray4[1] = dArray2[1];
            }
            extendedPathIterator.next();
            ++n2;
        }
        if (n2 < 2) {
            return null;
        }
        Point2D point2D = this.getSegmentTerminatingPoint(dArray4, n4);
        double d2 = this.endMarker.getOrient();
        if (Double.isNaN(d2)) {
            d2 = this.computeRotation(dArray3, n5, dArray4, n4, null, 0);
        }
        AffineTransform affineTransform = this.computeMarkerTransform(this.endMarker, point2D, d2);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.endMarker.getMarkerNode());
        proxyGraphicsNode.setTransform(affineTransform);
        return proxyGraphicsNode;
    }

    protected ProxyGraphicsNode[] buildMiddleMarkerProxies() {
        ExtendedPathIterator extendedPathIterator = this.getExtShape().getExtendedPathIterator();
        double[] dArray = new double[7];
        double[] dArray2 = new double[7];
        double[] dArray3 = new double[7];
        double[] dArray4 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (extendedPathIterator.isDone()) {
            return null;
        }
        n2 = extendedPathIterator.currentSegment(dArray);
        double[] dArray5 = new double[2];
        if (n2 != 0) {
            return null;
        }
        dArray5[0] = dArray[0];
        dArray5[1] = dArray[1];
        extendedPathIterator.next();
        if (extendedPathIterator.isDone()) {
            return null;
        }
        n3 = extendedPathIterator.currentSegment(dArray2);
        if (n3 == 0) {
            dArray5[0] = dArray2[0];
            dArray5[1] = dArray2[1];
        } else if (n3 == 4) {
            n3 = 1;
            dArray2[0] = dArray5[0];
            dArray2[1] = dArray5[1];
        }
        extendedPathIterator.next();
        ArrayList<ProxyGraphicsNode> arrayList = new ArrayList<ProxyGraphicsNode>();
        while (!extendedPathIterator.isDone()) {
            n4 = extendedPathIterator.currentSegment(dArray3);
            if (n4 == 0) {
                dArray5[0] = dArray3[0];
                dArray5[1] = dArray3[1];
            } else if (n4 == 4) {
                n4 = 1;
                dArray3[0] = dArray5[0];
                dArray3[1] = dArray5[1];
            }
            arrayList.add(this.createMiddleMarker(dArray, n2, dArray2, n3, dArray3, n4));
            dArray4 = dArray;
            dArray = dArray2;
            n2 = n3;
            dArray2 = dArray3;
            n3 = n4;
            dArray3 = dArray4;
            extendedPathIterator.next();
        }
        ProxyGraphicsNode[] proxyGraphicsNodeArray = new ProxyGraphicsNode[arrayList.size()];
        arrayList.toArray(proxyGraphicsNodeArray);
        return proxyGraphicsNodeArray;
    }

    private ProxyGraphicsNode createMiddleMarker(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray2, n3);
        double d2 = this.middleMarker.getOrient();
        if (Double.isNaN(d2)) {
            d2 = this.computeRotation(dArray, n2, dArray2, n3, dArray3, n4);
        }
        AffineTransform affineTransform = this.computeMarkerTransform(this.middleMarker, point2D, d2);
        ProxyGraphicsNode proxyGraphicsNode = new ProxyGraphicsNode();
        proxyGraphicsNode.setSource(this.middleMarker.getMarkerNode());
        proxyGraphicsNode.setTransform(affineTransform);
        return proxyGraphicsNode;
    }

    private double computeRotation(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4) {
        double[] dArray4 = this.computeInSlope(dArray, n2, dArray2, n3);
        double[] dArray5 = this.computeOutSlope(dArray2, n3, dArray3, n4);
        if (dArray4 == null) {
            dArray4 = dArray5;
        }
        if (dArray5 == null) {
            dArray5 = dArray4;
        }
        if (dArray4 == null) {
            return 0.0;
        }
        double d2 = dArray4[0] + dArray5[0];
        double d3 = dArray4[1] + dArray5[1];
        if (d2 == 0.0 && d3 == 0.0) {
            return Math.toDegrees(Math.atan2(dArray4[1], dArray4[0])) + 90.0;
        }
        return Math.toDegrees(Math.atan2(d3, d2));
    }

    private double[] computeInSlope(double[] dArray, int n2, double[] dArray2, int n3) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray2, n3);
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n3) {
            case 1: {
                Point2D point2D2 = this.getSegmentTerminatingPoint(dArray, n2);
                d2 = point2D.getX() - point2D2.getX();
                d3 = point2D.getY() - point2D2.getY();
                break;
            }
            case 2: {
                d2 = point2D.getX() - dArray2[0];
                d3 = point2D.getY() - dArray2[1];
                break;
            }
            case 3: {
                d2 = point2D.getX() - dArray2[2];
                d3 = point2D.getY() - dArray2[3];
                break;
            }
            case 4321: {
                Point2D point2D3 = this.getSegmentTerminatingPoint(dArray, n2);
                boolean bl = dArray2[3] != 0.0;
                boolean bl2 = dArray2[4] != 0.0;
                Arc2D arc2D = ExtendedGeneralPath.computeArc(point2D3.getX(), point2D3.getY(), dArray2[0], dArray2[1], dArray2[2], bl, bl2, dArray2[5], dArray2[6]);
                double d4 = arc2D.getAngleStart() + arc2D.getAngleExtent();
                d4 = Math.toRadians(d4);
                d2 = -arc2D.getWidth() / 2.0 * Math.sin(d4);
                d3 = arc2D.getHeight() / 2.0 * Math.cos(d4);
                if (dArray2[2] != 0.0) {
                    double d5 = Math.toRadians(-dArray2[2]);
                    double d6 = Math.sin(d5);
                    double d7 = Math.cos(d5);
                    double d8 = d2 * d7 - d3 * d6;
                    double d9 = d2 * d6 + d3 * d7;
                    d2 = d8;
                    d3 = d9;
                }
                if (bl2) {
                    d2 = -d2;
                    break;
                }
                d3 = -d3;
                break;
            }
            case 4: {
                throw new Error("should not have SEG_CLOSE here");
            }
            default: {
                return null;
            }
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return null;
        }
        return this.normalize(new double[]{d2, d3});
    }

    private double[] computeOutSlope(double[] dArray, int n2, double[] dArray2, int n3) {
        Point2D point2D = this.getSegmentTerminatingPoint(dArray, n2);
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n3) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                d2 = dArray2[0] - point2D.getX();
                d3 = dArray2[1] - point2D.getY();
                break;
            }
            case 4321: {
                boolean bl = dArray2[3] != 0.0;
                boolean bl2 = dArray2[4] != 0.0;
                Arc2D arc2D = ExtendedGeneralPath.computeArc(point2D.getX(), point2D.getY(), dArray2[0], dArray2[1], dArray2[2], bl, bl2, dArray2[5], dArray2[6]);
                double d4 = arc2D.getAngleStart();
                d4 = Math.toRadians(d4);
                d2 = -arc2D.getWidth() / 2.0 * Math.sin(d4);
                d3 = arc2D.getHeight() / 2.0 * Math.cos(d4);
                if (dArray2[2] != 0.0) {
                    double d5 = Math.toRadians(-dArray2[2]);
                    double d6 = Math.sin(d5);
                    double d7 = Math.cos(d5);
                    double d8 = d2 * d7 - d3 * d6;
                    double d9 = d2 * d6 + d3 * d7;
                    d2 = d8;
                    d3 = d9;
                }
                if (bl2) {
                    d2 = -d2;
                    break;
                }
                d3 = -d3;
                break;
            }
            default: {
                return null;
            }
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return null;
        }
        return this.normalize(new double[]{d2, d3});
    }

    public double[] normalize(double[] dArray) {
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[0] = dArray[0] / d2;
        dArray[1] = dArray[1] / d2;
        return dArray;
    }

    private AffineTransform computeMarkerTransform(Marker marker, Point2D point2D, double d2) {
        Point2D point2D2 = marker.getRef();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
        if (!Double.isNaN(d2)) {
            affineTransform.rotate(Math.toRadians(d2), point2D2.getX(), point2D2.getY());
        }
        return affineTransform;
    }

    protected Point2D getSegmentTerminatingPoint(double[] dArray, int n2) {
        switch (n2) {
            case 3: {
                return new Point2D.Double(dArray[4], dArray[5]);
            }
            case 1: {
                return new Point2D.Double(dArray[0], dArray[1]);
            }
            case 0: {
                return new Point2D.Double(dArray[0], dArray[1]);
            }
            case 2: {
                return new Point2D.Double(dArray[2], dArray[3]);
            }
            case 4321: {
                return new Point2D.Double(dArray[5], dArray[6]);
            }
        }
        throw new Error("invalid segmentType:" + n2);
    }
}

