/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.gvt.font.AWTGVTGlyphVector;
import org.apache.batik.gvt.font.AWTGlyphGeometryCache;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;

public class AWTGVTFont
implements GVTFont {
    protected Font awtFont;
    protected float size;
    protected float scale;
    public static final float FONT_SIZE = 48.0f;
    static Map fontCache = new HashMap(11);

    public AWTGVTFont(Font font) {
        this.size = font.getSize2D();
        this.awtFont = font.deriveFont(48.0f);
        this.scale = this.size / this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(Font font, float f2) {
        this.size = font.getSize2D() * f2;
        this.awtFont = font.deriveFont(48.0f);
        this.scale = this.size / this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(Map map) {
        Float f2 = (Float)map.get(TextAttribute.SIZE);
        if (f2 != null) {
            this.size = f2.floatValue();
            map.put(TextAttribute.SIZE, new Float(48.0f));
            this.awtFont = new Font(map);
        } else {
            this.awtFont = new Font(map);
            this.size = this.awtFont.getSize2D();
        }
        this.scale = this.size / this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public AWTGVTFont(String string, int n2, int n3) {
        this.awtFont = new Font(string, n2, 48);
        this.size = n3;
        this.scale = (float)n3 / this.awtFont.getSize2D();
        AWTGVTFont.initializeFontCache(this.awtFont);
    }

    public boolean canDisplay(char c2) {
        return this.awtFont.canDisplay(c2);
    }

    public int canDisplayUpTo(char[] cArray, int n2, int n3) {
        return this.awtFont.canDisplayUpTo(cArray, n2, n3);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n2, int n3) {
        return this.awtFont.canDisplayUpTo(characterIterator, n2, n3);
    }

    public int canDisplayUpTo(String string) {
        return this.awtFont.canDisplayUpTo(string);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        GlyphVector glyphVector = this.awtFont.createGlyphVector(fontRenderContext, cArray);
        return new AWTGVTGlyphVector(glyphVector, this, this.scale, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        Cloneable cloneable;
        if (characterIterator instanceof AttributedCharacterIterator && ArabicTextHandler.containsArabic(cloneable = (AttributedCharacterIterator)characterIterator)) {
            String string = ArabicTextHandler.createSubstituteString(cloneable);
            return this.createGlyphVector(fontRenderContext, string);
        }
        cloneable = this.awtFont.createGlyphVector(fontRenderContext, characterIterator);
        return new AWTGVTGlyphVector((GlyphVector)cloneable, this, this.scale, characterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, nArray), this, this.scale, characterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, string), this, this.scale, stringCharacterIterator);
    }

    public GVTFont deriveFont(float f2) {
        return new AWTGVTFont(this.awtFont, f2 / this.size);
    }

    public String getFamilyName() {
        return this.awtFont.getFamily();
    }

    public GVTLineMetrics getLineMetrics(char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(cArray, n2, n3, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(characterIterator, n2, n3, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(String string, int n2, int n3, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, n2, n3, fontRenderContext), this.scale);
    }

    public float getSize() {
        return this.size;
    }

    public float getHKern(int n2, int n3) {
        return 0.0f;
    }

    public float getVKern(int n2, int n3) {
        return 0.0f;
    }

    public static AWTGlyphGeometryCache.Value getGlyphGeometry(AWTGVTFont aWTGVTFont, char c2, GlyphVector glyphVector, int n2, Point2D point2D) {
        AWTGlyphGeometryCache aWTGlyphGeometryCache = (AWTGlyphGeometryCache)fontCache.get(aWTGVTFont.awtFont);
        AWTGlyphGeometryCache.Value value = aWTGlyphGeometryCache.get(c2);
        if (value == null) {
            Shape shape = glyphVector.getGlyphOutline(n2);
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(n2);
            Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
            if (AWTGVTGlyphVector.outlinesPositioned()) {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-point2D.getX(), -point2D.getY());
                shape = affineTransform.createTransformedShape(shape);
            }
            value = new AWTGlyphGeometryCache.Value(shape, rectangle2D);
            aWTGlyphGeometryCache.put(c2, value);
        }
        return value;
    }

    static void initializeFontCache(Font font) {
        if (!fontCache.containsKey(font)) {
            fontCache.put(font, new AWTGlyphGeometryCache());
        }
    }

    static void putAWTGVTFont(AWTGVTFont aWTGVTFont) {
        fontCache.put(aWTGVTFont.awtFont, aWTGVTFont);
    }

    static AWTGVTFont getAWTGVTFont(Font font) {
        return (AWTGVTFont)fontCache.get(font);
    }
}

