/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class GVTACIImpl
implements GVTAttributedCharacterIterator {
    private String simpleString;
    private Set allAttributes;
    private ArrayList mapList;
    private static int START_RUN = 2;
    private static int END_RUN = 3;
    private static int MID_RUN = 1;
    private static int SINGLETON = 0;
    private int[] charInRun;
    private CharacterIterator iter = null;
    private int currentIndex = -1;

    public GVTACIImpl() {
        this.simpleString = "";
        this.buildAttributeTables();
    }

    public GVTACIImpl(AttributedCharacterIterator attributedCharacterIterator) {
        this.buildAttributeTables(attributedCharacterIterator);
    }

    public void setString(String string) {
        this.simpleString = string;
        this.iter = new StringCharacterIterator(this.simpleString);
        this.buildAttributeTables();
    }

    public void setString(AttributedString attributedString) {
        this.iter = attributedString.getIterator();
        this.buildAttributeTables((AttributedCharacterIterator)this.iter);
    }

    public void setAttributeArray(GVTAttributedCharacterIterator.TextAttribute textAttribute, Object[] objectArray, int n2, int n3) {
        n2 = Math.max(n2, 0);
        n3 = Math.min(n3, this.simpleString.length());
        if (this.charInRun[n2] == END_RUN) {
            this.charInRun[n2 - 1] = this.charInRun[n2 - 1] == MID_RUN ? END_RUN : SINGLETON;
        }
        if (this.charInRun[n3 + 1] == END_RUN) {
            this.charInRun[n3 + 1] = SINGLETON;
        } else if (this.charInRun[n3 + 1] == MID_RUN) {
            this.charInRun[n3 + 1] = START_RUN;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.charInRun[i2] = SINGLETON;
            int n4 = Math.min(i2, objectArray.length - 1);
            ((Map)this.mapList.get(i2)).put(textAttribute, objectArray[n4]);
        }
    }

    public Set getAllAttributeKeys() {
        return this.allAttributes;
    }

    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.getAttributes().get(attribute);
    }

    public Map getAttributes() {
        return (Map)this.mapList.get(this.currentIndex);
    }

    public int getRunLimit() {
        int n2 = this.currentIndex;
        while (this.charInRun[++n2] == MID_RUN) {
        }
        return n2;
    }

    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        int n2 = this.currentIndex;
        Object v2 = this.getAttributes().get(attribute);
        if (v2 == null) {
            while (((Map)this.mapList.get(++n2)).get(attribute) == null) {
            }
        } else {
            while (v2.equals(((Map)this.mapList.get(++n2)).get(attribute))) {
            }
        }
        return n2;
    }

    public int getRunLimit(Set set) {
        int n2 = this.currentIndex;
        while (((Object)set).equals(this.mapList.get(++n2))) {
        }
        return n2;
    }

    public int getRunStart() {
        int n2 = this.currentIndex;
        while (this.charInRun[n2] == MID_RUN) {
            --n2;
        }
        return n2;
    }

    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        int n2 = this.currentIndex - 1;
        Object v2 = this.getAttributes().get(attribute);
        try {
            if (v2 == null) {
                while (((Map)this.mapList.get(n2 - 1)).get(attribute) == null) {
                    --n2;
                }
            } else {
                while (v2.equals(((Map)this.mapList.get(n2 - 1)).get(attribute))) {
                    --n2;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n2;
    }

    public int getRunStart(Set set) {
        int n2 = this.currentIndex;
        try {
            while (((Object)set).equals(this.mapList.get(n2 - 1))) {
                --n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n2;
    }

    public Object clone() {
        GVTACIImpl gVTACIImpl = new GVTACIImpl(this);
        return gVTACIImpl;
    }

    public char current() {
        return this.iter.current();
    }

    public char first() {
        return this.iter.first();
    }

    public int getBeginIndex() {
        return this.iter.getBeginIndex();
    }

    public int getEndIndex() {
        return this.iter.getEndIndex();
    }

    public int getIndex() {
        return this.iter.getIndex();
    }

    public char last() {
        return this.iter.last();
    }

    public char next() {
        return this.iter.next();
    }

    public char previous() {
        return this.iter.previous();
    }

    public char setIndex(int n2) {
        return this.iter.setIndex(n2);
    }

    private void buildAttributeTables() {
        this.allAttributes = new HashSet();
        this.mapList = new ArrayList(this.simpleString.length());
        this.charInRun = new int[this.simpleString.length()];
        for (int i2 = 0; i2 < this.charInRun.length; ++i2) {
            this.charInRun[i2] = SINGLETON;
            this.mapList.set(i2, new HashMap());
        }
    }

    private void buildAttributeTables(AttributedCharacterIterator attributedCharacterIterator) {
        this.allAttributes = attributedCharacterIterator.getAllAttributeKeys();
        int n2 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        this.mapList = new ArrayList(n2);
        this.charInRun = new int[n2];
        char c2 = attributedCharacterIterator.first();
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = c2;
            this.charInRun[i2] = SINGLETON;
            this.mapList.set(i2, new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes()));
            c2 = attributedCharacterIterator.next();
        }
        this.simpleString = new String(cArray);
    }

    public class TransformAttributeFilter
    implements GVTAttributedCharacterIterator.AttributeFilter {
        public AttributedCharacterIterator mutateAttributes(AttributedCharacterIterator attributedCharacterIterator) {
            return attributedCharacterIterator;
        }
    }
}

