/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private Point2D advance;
    private Point2D offset;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private boolean adjSpacing = true;
    private float[] glyphAdvances;
    private boolean isAltGlyph;
    private boolean layoutApplied = false;
    private boolean spacingApplied = false;
    private boolean pathApplied = false;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE;
    public static final AttributedCharacterIterator.Attribute HORIZONTAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    private static final Integer ORIENTATION_AUTO = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    protected static Set runAtts = new HashSet();
    protected static Set szAtts;
    public static final double eps = 1.0E-5;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.offset = point2D;
        this.font = this.getFont();
        this.charMap = nArray;
        this.metrics = this.font.getLineMetrics(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        this.vertical = attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        this.textPath = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
            if (this.gv != null) {
                this.isAltGlyph = true;
            }
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
    }

    public GVTGlyphVector getGlyphVector() {
        return this.gv;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setScale(float f2, float f3, boolean bl) {
        if (this.vertical) {
            f2 = 1.0f;
        } else {
            f3 = 1.0f;
        }
        if (f2 != this.xScale || f3 != this.yScale || bl != this.adjSpacing) {
            this.xScale = f2;
            this.yScale = f3;
            this.adjSpacing = bl;
            this.spacingApplied = false;
            this.glyphAdvances = null;
            this.pathApplied = false;
        }
    }

    public void setOffset(Point2D point2D) {
        if (point2D.getX() != this.offset.getX() || point2D.getY() != this.offset.getY()) {
            if (this.layoutApplied || this.spacingApplied) {
                float f2 = (float)(point2D.getX() - this.offset.getX());
                float f3 = (float)(point2D.getY() - this.offset.getY());
                int n2 = this.gv.getNumGlyphs();
                float[] fArray = this.gv.getGlyphPositions(0, n2 + 1, null);
                Point2D.Float float_ = new Point2D.Float();
                for (int i2 = 0; i2 <= n2; ++i2) {
                    float_.x = fArray[2 * i2] + f2;
                    float_.y = fArray[2 * i2 + 1] + f3;
                    this.gv.setGlyphPosition(i2, float_);
                }
            }
            this.offset = point2D;
            this.pathApplied = false;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n2) {
        return this.gv.getGlyphMetrics(n2);
    }

    public GVTLineMetrics getLineMetrics() {
        return this.metrics;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int n2, int n3) {
        return this.gv.getCharacterCount(n2, n3);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int n2 = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return (n2 & 1) == 0;
    }

    private final void syncLayout() {
        if (!this.pathApplied) {
            this.doPathLayout();
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.syncLayout();
        this.gv.draw(graphics2D, this.aci);
    }

    public Point2D getAdvance2D() {
        this.adjustTextSpacing();
        return this.advance;
    }

    public Shape getOutline() {
        this.syncLayout();
        return this.gv.getOutline();
    }

    public float[] getGlyphAdvances() {
        if (this.glyphAdvances != null) {
            return this.glyphAdvances;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        int n2 = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n2 + 1, null);
        this.glyphAdvances = new float[n2 + 1];
        int n3 = 0;
        if (this.isVertical()) {
            n3 = 1;
        }
        float f2 = fArray[n3];
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            this.glyphAdvances[i2] = fArray[2 * i2 + n3] - f2;
        }
        return this.glyphAdvances;
    }

    public Shape getDecorationOutline(int n2) {
        this.syncLayout();
        GeneralPath generalPath = new GeneralPath();
        if ((n2 & 1) != 0) {
            generalPath.append(this.getUnderlineShape(), false);
        }
        if ((n2 & 2) != 0) {
            generalPath.append(this.getStrikethroughShape(), false);
        }
        if ((n2 & 4) != 0) {
            generalPath.append(this.getOverlineShape(), false);
        }
        return generalPath;
    }

    public Rectangle2D getBounds2D() {
        this.syncLayout();
        return this.gv.getBounds2D(this.aci);
    }

    public Rectangle2D getGeometricBounds() {
        this.syncLayout();
        Rectangle2D rectangle2D = this.gv.getGeometricBounds();
        Rectangle2D rectangle2D2 = this.getDecorationOutline(7).getBounds2D();
        return rectangle2D.createUnion(rectangle2D2);
    }

    public Point2D getTextPathAdvance() {
        this.syncLayout();
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n2) {
        int n3 = this.getGlyphCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = this.getCharacterCount(i2, i2);
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6;
                if (n2 == (n6 = this.charMap[n4++])) {
                    return i2;
                }
                if (n4 < this.charMap.length) continue;
                return -1;
            }
        }
        return -1;
    }

    public int getLastGlyphIndex(int n2) {
        int n3 = this.getGlyphCount();
        int n4 = this.charMap.length - 1;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n5 = this.getCharacterCount(i2, i2);
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6;
                if (n2 == (n6 = this.charMap[n4--])) {
                    return i2;
                }
                if (n4 >= 0) continue;
                return -1;
            }
        }
        return -1;
    }

    public double getComputedOrientationAngle(int n2) {
        if (this.isGlyphOrientationAuto()) {
            if (this.isVertical()) {
                char c2 = this.aci.setIndex(n2);
                if (this.isLatinChar(c2)) {
                    return 90.0;
                }
                return 0.0;
            }
            return 0.0;
        }
        return this.getGlyphOrientationAngle();
    }

    public Shape getHighlightShape(int n2, int n3) {
        this.syncLayout();
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        GeneralPath generalPath = null;
        int n5 = this.getGlyphCount();
        Point2D.Float[] floatArray = new Point2D.Float[2 * n5];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n5];
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            Shape shape;
            int n8 = this.charMap[n7];
            if (n8 >= n2 && n8 <= n3 && this.gv.isGlyphVisible(i2) && (shape = this.gv.getGlyphLogicalBounds(i2)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n9 = 0;
                int n10 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                while (!pathIterator.isDone()) {
                    n10 = pathIterator.currentSegment(fArray);
                    if (n10 == 0 || n10 == 1) {
                        if (n9 > 4) break;
                        if (n9 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n9 == 0) {
                                float_ = float_2;
                            }
                            switch (n9) {
                                case 0: {
                                    floatArray2[n6] = float_2;
                                    break;
                                }
                                case 1: {
                                    floatArray[n6] = float_2;
                                    break;
                                }
                                case 2: {
                                    floatArray[n6 + 1] = float_2;
                                    break;
                                }
                                case 3: {
                                    floatArray2[n6 + 1] = float_2;
                                }
                            }
                        }
                    } else if (n10 != 4 || n9 < 4 || n9 > 5) break;
                    ++n9;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n6] != null && (floatArray[n6].x != floatArray[n6 + 1].x || floatArray[n6].y != floatArray[n6 + 1].y)) {
                        n6 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n6);
                    n6 = 0;
                    generalPath.append(shape, false);
                }
            }
            if ((n7 += this.getCharacterCount(i2, i2)) < this.charMap.length) continue;
            n7 = this.charMap.length - 1;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n6);
        return generalPath;
    }

    public static boolean epsEQ(double d2, double d3) {
        return d2 + 1.0E-5 > d3 && d2 - 1.0E-5 < d3;
    }

    public static int makeConvexHull(Point2D.Float[] floatArray, int n2) {
        float f2;
        float f3;
        float f4;
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!(floatArray[i2].x < floatArray[i2 - 1].x) && (floatArray[i2].x != floatArray[i2 - 1].x || !(floatArray[i2].y < floatArray[i2 - 1].y))) continue;
            Point2D.Float float_ = floatArray[i2];
            floatArray[i2] = floatArray[i2 - 1];
            floatArray[i2 - 1] = float_;
            i2 = 0;
        }
        Point2D.Float float_ = floatArray[0];
        Point2D.Float float_2 = floatArray[n2 - 1];
        Point2D.Float float_3 = new Point2D.Float(float_2.x - float_.x, float_2.y - float_.y);
        float f5 = float_3.y * float_.x - float_3.x * float_.y;
        Point2D.Float[] floatArray2 = new Point2D.Float[n2];
        Point2D.Float[] floatArray3 = new Point2D.Float[n2];
        floatArray3[0] = floatArray2[0] = floatArray[0];
        int n3 = 1;
        int n4 = 1;
        for (int i3 = 1; i3 < n2 - 1; ++i3) {
            float f6;
            Point2D.Float float_4 = floatArray[i3];
            f4 = float_3.x * float_4.y - float_3.y * float_4.x + f5;
            if (f4 < 0.0f) {
                while (n4 >= 2) {
                    float_ = floatArray3[n4 - 2];
                    float_2 = floatArray3[n4 - 1];
                    f3 = float_2.x - float_.x;
                    f2 = float_2.y - float_.y;
                    f6 = f2 * float_.x - f3 * float_.y;
                    f4 = f3 * float_4.y - f2 * float_4.x + f6;
                    if ((double)f4 > 1.0E-5) break;
                    if ((double)f4 > -1.0E-5) {
                        if (float_2.y < float_4.y) {
                            float_4 = float_2;
                        }
                        break;
                    }
                    --n4;
                }
                int n5 = --n4;
                ++n4;
                floatArray3[n5] = float_4;
                continue;
            }
            while (n3 >= 2) {
                float_ = floatArray2[n3 - 2];
                float_2 = floatArray2[n3 - 1];
                f3 = float_2.x - float_.x;
                f2 = float_2.y - float_.y;
                f6 = f2 * float_.x - f3 * float_.y;
                f4 = f3 * float_4.y - f2 * float_4.x + f6;
                if ((double)f4 < -1.0E-5) break;
                if ((double)f4 < 1.0E-5) {
                    if (float_2.y > float_4.y) {
                        float_4 = float_2;
                    }
                    break;
                }
                --n3;
            }
            int n6 = --n3;
            ++n3;
            floatArray2[n6] = float_4;
        }
        Point2D.Float float_5 = floatArray[n2 - 1];
        while (n4 >= 2) {
            float_ = floatArray3[n4 - 2];
            float_2 = floatArray3[n4 - 1];
            float f7 = float_2.x - float_.x;
            f3 = float_2.y - float_.y;
            f2 = f3 * float_.x - f7 * float_.y;
            f4 = f7 * float_5.y - f3 * float_5.x + f2;
            if ((double)f4 > 1.0E-5) break;
            if ((double)f4 > -1.0E-5) {
                if (!(float_2.y >= float_5.y)) break;
                --n4;
                break;
            }
            --n4;
        }
        while (n3 >= 2) {
            float_ = floatArray2[n3 - 2];
            float_2 = floatArray2[n3 - 1];
            float f8 = float_2.x - float_.x;
            f3 = float_2.y - float_.y;
            f2 = f3 * float_.x - f8 * float_.y;
            f4 = f8 * float_5.y - f3 * float_5.x + f2;
            if ((double)f4 < -1.0E-5) break;
            if ((double)f4 < 1.0E-5) {
                if (!(float_2.y <= float_5.y)) break;
                --n3;
                break;
            }
            --n3;
        }
        System.arraycopy(floatArray2, 0, floatArray, 0, n3);
        int n7 = n3;
        floatArray[n7++] = floatArray[n2 - 1];
        int n8 = n4 - 1;
        while (n8 > 0) {
            floatArray[n7] = floatArray3[n8];
            --n8;
            ++n7;
        }
        return n7;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n2) {
        if (n2 < 2) {
            return;
        }
        if (n2 == 2) {
            generalPath.moveTo(floatArray[0].x, floatArray[0].y);
            generalPath.lineTo(floatArray[1].x, floatArray[1].y);
            generalPath.lineTo(floatArray2[1].x, floatArray2[1].y);
            generalPath.lineTo(floatArray2[0].x, floatArray2[0].y);
            generalPath.lineTo(floatArray[0].x, floatArray[0].y);
            return;
        }
        Point2D.Float[] floatArray3 = new Point2D.Float[8];
        Point2D.Float[] floatArray4 = new Point2D.Float[8];
        floatArray3[4] = floatArray[0];
        floatArray3[5] = floatArray[1];
        floatArray3[6] = floatArray2[1];
        floatArray3[7] = floatArray2[0];
        Area[] areaArray = new Area[n2 / 2];
        int n3 = 0;
        for (int i2 = 2; i2 < n2; i2 += 2) {
            floatArray3[0] = floatArray3[4];
            floatArray3[1] = floatArray3[5];
            floatArray3[2] = floatArray3[6];
            floatArray3[3] = floatArray3[7];
            floatArray3[4] = floatArray[i2];
            floatArray3[5] = floatArray[i2 + 1];
            floatArray3[6] = floatArray2[i2 + 1];
            floatArray3[7] = floatArray2[i2];
            float f2 = floatArray3[2].x - floatArray3[0].x;
            float f3 = f2 * f2;
            f2 = floatArray3[2].y - floatArray3[0].y;
            float f4 = (float)Math.sqrt(f3 += f2 * f2);
            f2 = floatArray3[6].x - floatArray3[4].x;
            f3 = f2 * f2;
            f2 = floatArray3[6].y - floatArray3[4].y;
            f4 += (float)Math.sqrt(f3 += f2 * f2);
            f2 = (floatArray3[0].x + floatArray3[1].x + floatArray3[2].x + floatArray3[3].x - (floatArray3[4].x + floatArray3[5].x + floatArray3[6].x + floatArray3[7].x)) / 4.0f;
            f3 = f2 * f2;
            f2 = (floatArray3[0].y + floatArray3[1].y + floatArray3[2].y + floatArray3[3].y - (floatArray3[4].y + floatArray3[5].y + floatArray3[6].y + floatArray3[7].y)) / 4.0f;
            f3 += f2 * f2;
            f3 = (float)Math.sqrt(f3);
            GeneralPath generalPath2 = new GeneralPath();
            if (f3 < f4) {
                System.arraycopy(floatArray3, 0, floatArray4, 0, 8);
                int n4 = GlyphLayout.makeConvexHull(floatArray4, 8);
                generalPath2.moveTo(floatArray4[0].x, floatArray4[0].y);
                for (int i3 = 1; i3 < n4; ++i3) {
                    generalPath2.lineTo(floatArray4[i3].x, floatArray4[i3].y);
                }
                generalPath2.closePath();
            } else {
                GlyphLayout.mergeAreas(generalPath, areaArray, n3);
                n3 = 0;
                if (i2 == 2) {
                    generalPath2.moveTo(floatArray3[0].x, floatArray3[0].y);
                    generalPath2.lineTo(floatArray3[1].x, floatArray3[1].y);
                    generalPath2.lineTo(floatArray3[2].x, floatArray3[2].y);
                    generalPath2.lineTo(floatArray3[3].x, floatArray3[3].y);
                    generalPath2.closePath();
                    generalPath.append(generalPath2, false);
                    generalPath2.reset();
                }
                generalPath2.moveTo(floatArray3[4].x, floatArray3[4].y);
                generalPath2.lineTo(floatArray3[5].x, floatArray3[5].y);
                generalPath2.lineTo(floatArray3[6].x, floatArray3[6].y);
                generalPath2.lineTo(floatArray3[7].x, floatArray3[7].y);
                generalPath2.closePath();
            }
            areaArray[n3++] = new Area(generalPath2);
        }
        GlyphLayout.mergeAreas(generalPath, areaArray, n3);
    }

    public static void mergeAreas(GeneralPath generalPath, Area[] areaArray, int n2) {
        while (n2 > 1) {
            int n3 = 0;
            for (int i2 = 1; i2 < n2; i2 += 2) {
                areaArray[i2 - 1].add(areaArray[i2]);
                areaArray[n3++] = areaArray[i2 - 1];
                areaArray[i2] = null;
            }
            if ((n2 & 1) == 1) {
                areaArray[n3 - 1].add(areaArray[n2 - 1]);
            }
            n2 /= 2;
        }
        if (n2 == 1) {
            generalPath.append(areaArray[0], false);
        }
    }

    public TextHit hitTestChar(float f2, float f3) {
        this.syncLayout();
        TextHit textHit = null;
        int n2 = 0;
        for (int i2 = 0; i2 < this.gv.getNumGlyphs(); ++i2) {
            Shape shape = this.gv.getGlyphLogicalBounds(i2);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f2, f3)) {
                    boolean bl = (double)f2 > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    int n3 = this.charMap[n2];
                    textHit = new TextHit(n3, bl2);
                    return textHit;
                }
            }
            if ((n2 += this.getCharacterCount(i2, i2)) < this.charMap.length) continue;
            n2 = this.charMap.length - 1;
        }
        return textHit;
    }

    protected GVTFont getFont() {
        this.aci.first();
        GVTFont gVTFont = (GVTFont)this.aci.getAttribute(GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(this.aci.getAttributes());
    }

    protected Shape getOverlineShape() {
        double d2 = this.metrics.getOverlineOffset();
        float f2 = this.metrics.getOverlineThickness();
        d2 += (double)f2;
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        BasicStroke basicStroke = new BasicStroke(f2);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected Shape getUnderlineShape() {
        double d2 = this.metrics.getUnderlineOffset();
        float f2 = this.metrics.getUnderlineThickness();
        d2 += (double)f2 * 1.5;
        BasicStroke basicStroke = new BasicStroke(f2);
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected Shape getStrikethroughShape() {
        double d2 = this.metrics.getStrikethroughOffset();
        float f2 = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f2);
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected void doExplicitGlyphLayout() {
        int n2;
        this.gv.performDefaultLayout();
        float f2 = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        int n3 = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n3 + 1, null);
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = this.isGlyphOrientationAuto();
        int n4 = 0;
        if (!bl) {
            n4 = this.getGlyphOrientationAngle();
        }
        int n5 = this.aci.getBeginIndex();
        int n6 = 0;
        char c2 = this.aci.first();
        int n7 = n6 + n5;
        Float f5 = null;
        Float f6 = null;
        Float f7 = null;
        Float f8 = null;
        Float f9 = null;
        Object object = null;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = (float)this.offset.getX();
        float f13 = (float)this.offset.getY();
        Point2D.Float float_ = new Point2D.Float();
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            Cloneable cloneable;
            float f14;
            float f15;
            float f16;
            float f17;
            if (n6 + n5 >= n7) {
                n7 = this.aci.getRunLimit(runAtts);
                f5 = (Float)this.aci.getAttribute(X);
                f6 = (Float)this.aci.getAttribute(Y);
                f7 = (Float)this.aci.getAttribute(DX);
                f8 = (Float)this.aci.getAttribute(DY);
                f9 = (Float)this.aci.getAttribute(ROTATION);
                object = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
            if (n2 == 0) {
                if (this.isVertical()) {
                    if (bl) {
                        if (this.isLatinChar(c2)) {
                            f3 = 0.0f;
                        } else {
                            f17 = gVTGlyphMetrics.getVerticalAdvance();
                            f16 = this.metrics.getAscent();
                            f15 = this.metrics.getDescent();
                            f3 = f16 + (f17 - (f16 + f15)) / 2.0f;
                        }
                    } else if (n4 == 0) {
                        f17 = gVTGlyphMetrics.getVerticalAdvance();
                        f16 = this.metrics.getAscent();
                        f15 = this.metrics.getDescent();
                        f3 = f16 + (f17 - (f16 + f15)) / 2.0f;
                    } else {
                        f3 = 0.0f;
                    }
                } else {
                    f4 = n4 == 270 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f;
                }
            } else if (bl && f3 == 0.0f && !this.isLatinChar(c2)) {
                f17 = gVTGlyphMetrics.getVerticalAdvance();
                f16 = this.metrics.getAscent();
                f15 = this.metrics.getDescent();
                f3 = f16 + (f17 - (f16 + f15)) / 2.0f;
            }
            f17 = 0.0f;
            f16 = 0.0f;
            f15 = 0.0f;
            float f18 = 0.0f;
            if (c2 != '\uffff') {
                if (this.vertical) {
                    f15 = bl ? (this.isLatinChar(c2) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n4);
                    if (this.textPath != null) {
                        f5 = null;
                    }
                } else {
                    f15 = (float)Math.toRadians(n4);
                    if (this.textPath != null) {
                        f6 = null;
                    }
                }
                f18 = f9 == null || f9.isNaN() ? f15 : f9.floatValue() + f15;
                if (f5 != null && !f5.isNaN()) {
                    if (n2 == 0) {
                        f10 = (float)((double)f5.floatValue() - this.offset.getX());
                    }
                    f12 = f5.floatValue() - f10;
                }
                if (f7 != null && !f7.isNaN()) {
                    f12 += f7.floatValue();
                }
                if (f6 != null && !f6.isNaN()) {
                    if (n2 == 0) {
                        f11 = (float)((double)f6.floatValue() - this.offset.getY());
                    }
                    f13 = f6.floatValue() - f11;
                }
                if (f8 != null && !f8.isNaN()) {
                    f13 += f8.floatValue();
                } else if (n2 > 0) {
                    f13 += fArray[n2 * 2 + 1] - fArray[n2 * 2 - 1];
                }
                f14 = 0.0f;
                if (object != null) {
                    if (object instanceof Integer) {
                        if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                            f14 = f2 * 0.5f;
                        } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                            f14 = -f2 * 0.5f;
                        }
                    } else if (object instanceof Float) {
                        f14 = ((Float)object).floatValue();
                    }
                    if (this.vertical) {
                        f17 = f14;
                    } else {
                        f16 = -f14;
                    }
                }
                if (this.vertical) {
                    f16 += f3;
                    if (bl) {
                        if (this.isLatinChar(c2)) {
                            f17 += this.metrics.getStrikethroughOffset();
                        } else {
                            cloneable = this.gv.getGlyphVisualBounds(n2).getBounds2D();
                            f17 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n2] - ((RectangularShape)cloneable).getWidth() / 2.0);
                        }
                    } else {
                        cloneable = this.gv.getGlyphVisualBounds(n2).getBounds2D();
                        f17 = n4 == 0 ? (f17 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n2] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n4 == 180 ? (f17 += (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n2] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n4 == 90 ? (f17 += this.metrics.getStrikethroughOffset()) : (f17 -= this.metrics.getStrikethroughOffset())));
                    }
                } else {
                    f17 += f4;
                    if (n4 == 90) {
                        f16 -= gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n4 == 180) {
                        f16 -= this.metrics.getAscent();
                    }
                }
            }
            float_.x = f12 + f17;
            float_.y = f13 + f16;
            this.gv.setGlyphPosition(n2, float_);
            if (ArabicTextHandler.arabicCharTransparent(c2)) {
                bl2 = true;
            } else if (this.vertical) {
                f14 = 0.0f;
                if (bl) {
                    f14 = this.isLatinChar(c2) ? gVTGlyphMetrics.getHorizontalAdvance() : gVTGlyphMetrics.getVerticalAdvance();
                } else if (n4 == 0 || n4 == 180) {
                    f14 = gVTGlyphMetrics.getVerticalAdvance();
                } else if (n4 == 90) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                } else {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n2, AffineTransform.getTranslateInstance(0.0, f14));
                }
                f13 += f14;
            } else {
                f14 = 0.0f;
                if (n4 == 0) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                } else if (n4 == 180) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n2, AffineTransform.getTranslateInstance(f14, 0.0));
                } else {
                    f14 = gVTGlyphMetrics.getVerticalAdvance();
                }
                f12 += f14;
            }
            if (!GlyphLayout.epsEQ(f18, 0.0)) {
                AffineTransform affineTransform = this.gv.getGlyphTransform(n2);
                if (affineTransform == null) {
                    affineTransform = new AffineTransform();
                }
                cloneable = GlyphLayout.epsEQ(f18, 1.5707963267948966) ? new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f18, Math.PI) ? new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f18, 4.71238898038469) ? new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f) : AffineTransform.getRotateInstance(f18)));
                affineTransform.concatenate((AffineTransform)cloneable);
                this.gv.setGlyphTransform(n2, affineTransform);
            }
            if ((n6 += this.gv.getCharacterCount(n2, n2)) >= this.charMap.length) {
                n6 = this.charMap.length - 1;
            }
            c2 = this.aci.setIndex(n6 + n5);
        }
        float_.x = f12;
        float_.y = f13;
        this.gv.setGlyphPosition(n2, float_);
        this.advance = new Point2D.Float((float)((double)f12 - this.offset.getX()), (float)((double)f13 - this.offset.getY()));
        if (bl2) {
            c2 = this.aci.first();
            n6 = 0;
            int n8 = -1;
            for (n2 = 0; n2 < n3; ++n2) {
                if (ArabicTextHandler.arabicCharTransparent(c2)) {
                    if (n8 == -1) {
                        n8 = n2;
                    }
                } else if (n8 != -1) {
                    Point2D point2D = this.gv.getGlyphPosition(n2);
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n2);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    float f19 = 0.0f;
                    float f20 = 0.0f;
                    if (this.vertical) {
                        if (bl || n4 == 90) {
                            f20 = gVTGlyphMetrics.getHorizontalAdvance();
                        } else if (n4 == 270) {
                            f20 = 0.0f;
                        } else {
                            f19 = n4 == 0 ? gVTGlyphMetrics.getHorizontalAdvance() : -gVTGlyphMetrics.getHorizontalAdvance();
                        }
                    } else if (n4 == 0) {
                        f19 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n4 == 90) {
                        f20 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n4 == 180) {
                        f19 = 0.0f;
                    } else {
                        f20 = -gVTGlyphMetrics.getHorizontalAdvance();
                    }
                    float f21 = (float)(point2D.getX() + (double)f19);
                    float f22 = (float)(point2D.getY() + (double)f20);
                    for (int i2 = n8; i2 < n2; ++i2) {
                        Point2D point2D2 = this.gv.getGlyphPosition(i2);
                        GVTGlyphMetrics gVTGlyphMetrics2 = this.gv.getGlyphMetrics(i2);
                        float f23 = (float)point2D2.getX();
                        float f24 = (float)point2D2.getY();
                        float f25 = 0.0f;
                        float f26 = 0.0f;
                        float f27 = gVTGlyphMetrics2.getHorizontalAdvance();
                        if (this.vertical) {
                            if (bl || n4 == 90) {
                                f24 = f22 - f27;
                            } else if (n4 == 270) {
                                f24 = f22 + f27;
                            } else {
                                f23 = n4 == 0 ? f21 - f27 : f21 + f27;
                            }
                        } else if (n4 == 0) {
                            f23 = f21 - f27;
                        } else if (n4 == 90) {
                            f24 = f22 - f27;
                        } else if (n4 == 180) {
                            f23 = f21 + f27;
                        } else {
                            f24 = f22 + f27;
                        }
                        point2D2 = new Point2D.Double(f23, f24);
                        this.gv.setGlyphPosition(i2, point2D2);
                        if (!bl4 && !bl3) continue;
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f25, f26);
                        affineTransform.concatenate(this.gv.getGlyphTransform(n2));
                        this.gv.setGlyphTransform(n2, affineTransform);
                    }
                    n8 = -1;
                }
                if ((n6 += this.gv.getCharacterCount(n2, n2)) >= this.charMap.length) {
                    n6 = this.charMap.length - 1;
                }
                c2 = this.aci.setIndex(n6 + n5);
            }
        }
        this.layoutApplied = true;
        this.spacingApplied = false;
        this.glyphAdvances = null;
        this.pathApplied = false;
    }

    protected void adjustTextSpacing() {
        if (this.spacingApplied) {
            return;
        }
        if (!this.layoutApplied) {
            this.doExplicitGlyphLayout();
        }
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        if (bl != null && bl.booleanValue()) {
            this.advance = this.doSpacing((Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
            this.layoutApplied = false;
        }
        this.applyStretchTransform(!this.adjSpacing);
        this.spacingApplied = true;
        this.pathApplied = false;
    }

    protected Point2D doSpacing(Float f2, Float f3, Float f4) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f2 != null && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl = false;
        }
        if (f3 != null && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl3 = true;
        }
        if (f4 != null && !f4.isNaN()) {
            bl2 = true;
        }
        int n2 = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n2 + 1];
        Point2D point2D = this.gv.getGlyphPosition(0);
        int n3 = this.gv.getGlyphCode(0);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n2 - 1).getX() - (double)f9), this.advance.getY() - (this.gv.getGlyphPosition(n2 - 1).getY() - (double)f10));
        try {
            int n4;
            Point2D point2D2;
            int n5;
            GVTFont gVTFont = this.gv.getFont();
            if (n2 > 1 && (bl3 || !bl)) {
                for (n5 = 1; n5 <= n2; ++n5) {
                    float f11;
                    point2D2 = this.gv.getGlyphPosition(n5);
                    n4 = n5 == n2 ? -1 : this.gv.getGlyphCode(n5);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.vertical) {
                            f8 += f6;
                        } else {
                            f7 += f6;
                        }
                    } else if (this.vertical) {
                        f11 = 0.0f;
                        if (n4 != -1) {
                            f11 = gVTFont.getVKern(n3, n4);
                        }
                        f8 += f5 - f11 + f6;
                    } else {
                        f11 = 0.0f;
                        if (n4 != -1) {
                            f11 = gVTFont.getHKern(n3, n4);
                        }
                        f7 += f5 - f11 + f6;
                    }
                    point2DArray[n5] = new Point2D.Float(f9 += f7, f10 += f8);
                    point2D = point2D2;
                    n3 = n4;
                }
                for (n5 = 1; n5 <= n2; ++n5) {
                    if (point2DArray[n5] == null) continue;
                    this.gv.setGlyphPosition(n5, point2DArray[n5]);
                }
            }
            if (this.vertical) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f5 + (double)f6);
            } else {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f5 + (double)f6, ((Point2D)double_).getY());
            }
            f7 = 0.0f;
            f8 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
            if (n2 > 1 && bl2) {
                for (n5 = 1; n5 < n2; ++n5) {
                    point2D2 = this.gv.getGlyphPosition(n5);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    n4 = 0;
                    int n6 = n5;
                    int n7 = n5;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n5);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (n4 == 0) {
                            n4 = 1;
                        }
                        if (n5 == n2 - 1) break;
                        ++n7;
                        point2D2 = this.gv.getGlyphPosition(++n5);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n5);
                    }
                    if (n4 != 0) {
                        int n8 = n7 - n6;
                        float f12 = (float)point2D.getX();
                        float f13 = (float)point2D.getY();
                        f7 = (float)(point2D2.getX() - (double)f12) / (float)(n8 + 1);
                        f8 = (float)(point2D2.getY() - (double)f13) / (float)(n8 + 1);
                        if (this.vertical) {
                            f8 += f4.floatValue() / (float)(n8 + 1);
                        } else {
                            f7 += f4.floatValue() / (float)(n8 + 1);
                        }
                        for (int i2 = n6; i2 <= n7; ++i2) {
                            point2DArray[i2] = new Point2D.Float(f9 += f7, f10 += f8);
                        }
                    } else {
                        f7 = (float)(point2D2.getX() - point2D.getX());
                        f8 = (float)(point2D2.getY() - point2D.getY());
                        point2DArray[n5] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D2;
                }
                Point2D point2D3 = this.gv.getGlyphPosition(n2);
                point2DArray[n2] = new Point2D.Float(f9 += (float)(point2D3.getX() - point2D.getX()), f10 += (float)(point2D3.getY() - point2D.getY()));
                for (int i3 = 1; i3 <= n2; ++i3) {
                    if (point2DArray[i3] == null) continue;
                    this.gv.setGlyphPosition(i3, point2DArray[i3]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d2 = this.gv.getGlyphPosition(n2 - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d3 = this.gv.getGlyphPosition(n2 - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d2 + ((Point2D)double_).getX(), d3 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void applyStretchTransform(boolean bl) {
        if (this.xScale == 1.0f && this.yScale == 1.0f) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.xScale, this.yScale);
        int n2 = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n2 + 1, null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 <= n2; ++i2) {
            float f4 = fArray[2 * i2] - f2;
            float f5 = fArray[2 * i2 + 1] - f3;
            float_.x = f2 + f4 * this.xScale;
            float_.y = f3 + f5 * this.yScale;
            this.gv.setGlyphPosition(i2, float_);
            if (!bl || i2 == n2) continue;
            AffineTransform affineTransform2 = this.gv.getGlyphTransform(i2);
            if (affineTransform2 != null) {
                affineTransform2.preConcatenate(affineTransform);
                this.gv.setGlyphTransform(i2, affineTransform2);
                continue;
            }
            this.gv.setGlyphTransform(i2, affineTransform);
        }
        this.advance = new Point2D.Float((float)(this.advance.getX() * (double)this.xScale), (float)(this.advance.getY() * (double)this.yScale));
        this.layoutApplied = false;
    }

    protected void doPathLayout() {
        float f2;
        if (this.pathApplied) {
            return;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        this.getGlyphAdvances();
        if (this.textPath == null) {
            this.pathApplied = true;
            return;
        }
        boolean bl = !this.isVertical();
        boolean bl2 = this.isGlyphOrientationAuto();
        int n2 = 0;
        if (!bl2) {
            n2 = this.getGlyphOrientationAngle();
        }
        float f3 = this.textPath.lengthOfPath();
        float f4 = this.textPath.getStartOffset();
        int n3 = this.gv.getNumGlyphs();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.gv.setGlyphVisible(i2, true);
        }
        float f5 = bl ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f3 == 0.0f || f5 == 0.0f) {
            this.pathApplied = true;
            this.textPathAdvance = this.advance;
            return;
        }
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f6 = 0.0f;
        if (bl) {
            f6 = (float)point2D.getY();
            f2 = (float)(point2D.getX() + (double)f4);
        } else {
            f6 = (float)point2D.getX();
            f2 = (float)(point2D.getY() + (double)f4);
        }
        char c2 = this.aci.first();
        int n4 = this.aci.getBeginIndex();
        int n5 = 0;
        int n6 = -1;
        float f7 = 0.0f;
        for (int i3 = 0; i3 < n3; ++i3) {
            float f8;
            Point2D point2D2;
            Point2D point2D3 = this.gv.getGlyphPosition(i3);
            float f9 = 0.0f;
            float f10 = 0.0f;
            Point2D point2D4 = this.gv.getGlyphPosition(i3 + 1);
            if (bl) {
                f9 = (float)(point2D4.getX() - point2D3.getX());
                f10 = (float)(point2D4.getY() - point2D3.getY());
            } else {
                f9 = (float)(point2D4.getY() - point2D3.getY());
                f10 = (float)(point2D4.getX() - point2D3.getX());
            }
            Rectangle2D rectangle2D = this.gv.getGlyphOutline(i3).getBounds2D();
            float f11 = (float)rectangle2D.getWidth();
            float f12 = (float)rectangle2D.getHeight();
            float f13 = 0.0f;
            if (f11 > 0.0f) {
                f13 = (float)(rectangle2D.getX() + (double)(f11 / 2.0f));
                f13 -= (float)point2D3.getX();
            }
            float f14 = 0.0f;
            if (f12 > 0.0f) {
                f14 = (float)(rectangle2D.getY() + (double)(f12 / 2.0f));
                f14 -= (float)point2D3.getY();
            }
            if ((point2D2 = this.textPath.pointAtLength(f8 = bl ? f2 + f13 : f2 + f14)) != null) {
                float f15 = this.textPath.angleAtLength(f8);
                AffineTransform affineTransform = new AffineTransform();
                if (bl) {
                    affineTransform.rotate(f15);
                } else {
                    affineTransform.rotate((double)f15 - 1.5707963267948966);
                }
                if (bl) {
                    affineTransform.translate(0.0, f6);
                } else {
                    affineTransform.translate(f6, 0.0);
                }
                if (bl) {
                    affineTransform.translate(-f13, 0.0);
                } else {
                    affineTransform.translate(0.0, -f14);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(i3);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(i3, affineTransform);
                this.gv.setGlyphPosition(i3, point2D2);
                n6 = i3;
                f7 = f9;
            } else {
                this.gv.setGlyphVisible(i3, false);
            }
            f2 += f9;
            f6 += f10;
            if ((n5 += this.gv.getCharacterCount(i3, i3)) >= this.charMap.length) {
                n5 = this.charMap.length - 1;
            }
            c2 = this.aci.setIndex(n5 + n4);
        }
        if (n6 > -1) {
            Point2D point2D5 = this.gv.getGlyphPosition(n6);
            this.textPathAdvance = bl ? new Point2D.Double(point2D5.getX() + (double)f7, point2D5.getY()) : new Point2D.Double(point2D5.getX(), point2D5.getY() + (double)f7);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
        this.layoutApplied = false;
        this.spacingApplied = false;
        this.pathApplied = true;
    }

    protected boolean isLatinChar(char c2) {
        if (c2 < '\u00ff' && Character.isLetterOrDigit(c2)) {
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.ARABIC || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B;
    }

    protected boolean isGlyphOrientationAuto() {
        if (!this.isVertical()) {
            return false;
        }
        this.aci.first();
        Integer n2 = (Integer)this.aci.getAttribute(VERTICAL_ORIENTATION);
        if (n2 != null) {
            return n2 == ORIENTATION_AUTO;
        }
        return true;
    }

    protected int getGlyphOrientationAngle() {
        int n2 = 0;
        this.aci.first();
        Float f2 = this.isVertical() ? (Float)this.aci.getAttribute(VERTICAL_ORIENTATION_ANGLE) : (Float)this.aci.getAttribute(HORIZONTAL_ORIENTATION_ANGLE);
        if (f2 != null) {
            n2 = (int)f2.floatValue();
        }
        if (n2 != 0 || n2 != 90 || n2 != 180 || n2 != 270) {
            while (n2 < 0) {
                n2 += 360;
            }
            while (n2 >= 360) {
                n2 -= 360;
            }
            n2 = n2 <= 45 || n2 > 315 ? 0 : (n2 > 45 && n2 <= 135 ? 90 : (n2 > 135 && n2 <= 225 ? 180 : 270));
        }
        return n2;
    }

    public boolean hasCharacterIndex(int n2) {
        for (int i2 = 0; i2 < this.charMap.length; ++i2) {
            if (n2 != this.charMap[i2]) continue;
            return true;
        }
        return false;
    }

    public boolean isAltGlyph() {
        return this.isAltGlyph;
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
        szAtts = new HashSet();
        szAtts.add(TextAttribute.SIZE);
        szAtts.add(GVT_FONT);
        szAtts.add(LINE_HEIGHT);
    }
}

