/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;

public class PathArrayProducer
implements PathHandler {
    protected LinkedList ps;
    protected float[] p;
    protected LinkedList cs;
    protected short[] c;
    protected int cindex;
    protected int pindex;
    protected int ccount;
    protected int pcount;

    public short[] getPathCommands() {
        return this.c;
    }

    public float[] getPathParameters() {
        return this.p;
    }

    public void startPath() throws ParseException {
        this.cs = new LinkedList();
        this.c = new short[11];
        this.ps = new LinkedList();
        this.p = new float[11];
        this.ccount = 0;
        this.pcount = 0;
        this.cindex = 0;
        this.pindex = 0;
    }

    public void movetoRel(float f2, float f3) throws ParseException {
        this.command((short)3);
        this.param(f2);
        this.param(f3);
    }

    public void movetoAbs(float f2, float f3) throws ParseException {
        this.command((short)2);
        this.param(f2);
        this.param(f3);
    }

    public void closePath() throws ParseException {
        this.command((short)1);
    }

    public void linetoRel(float f2, float f3) throws ParseException {
        this.command((short)5);
        this.param(f2);
        this.param(f3);
    }

    public void linetoAbs(float f2, float f3) throws ParseException {
        this.command((short)4);
        this.param(f2);
        this.param(f3);
    }

    public void linetoHorizontalRel(float f2) throws ParseException {
        this.command((short)13);
        this.param(f2);
    }

    public void linetoHorizontalAbs(float f2) throws ParseException {
        this.command((short)12);
        this.param(f2);
    }

    public void linetoVerticalRel(float f2) throws ParseException {
        this.command((short)15);
        this.param(f2);
    }

    public void linetoVerticalAbs(float f2) throws ParseException {
        this.command((short)14);
        this.param(f2);
    }

    public void curvetoCubicRel(float f2, float f3, float f4, float f5, float f6, float f7) throws ParseException {
        this.command((short)7);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
        this.param(f6);
        this.param(f7);
    }

    public void curvetoCubicAbs(float f2, float f3, float f4, float f5, float f6, float f7) throws ParseException {
        this.command((short)6);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
        this.param(f6);
        this.param(f7);
    }

    public void curvetoCubicSmoothRel(float f2, float f3, float f4, float f5) throws ParseException {
        this.command((short)17);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
    }

    public void curvetoCubicSmoothAbs(float f2, float f3, float f4, float f5) throws ParseException {
        this.command((short)16);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
    }

    public void curvetoQuadraticRel(float f2, float f3, float f4, float f5) throws ParseException {
        this.command((short)9);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
    }

    public void curvetoQuadraticAbs(float f2, float f3, float f4, float f5) throws ParseException {
        this.command((short)8);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(f5);
    }

    public void curvetoQuadraticSmoothRel(float f2, float f3) throws ParseException {
        this.command((short)19);
        this.param(f2);
        this.param(f3);
    }

    public void curvetoQuadraticSmoothAbs(float f2, float f3) throws ParseException {
        this.command((short)18);
        this.param(f2);
        this.param(f3);
    }

    public void arcRel(float f2, float f3, float f4, boolean bl, boolean bl2, float f5, float f6) throws ParseException {
        this.command((short)11);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(bl ? 1.0f : 0.0f);
        this.param(bl2 ? 1.0f : 0.0f);
        this.param(f5);
        this.param(f6);
    }

    public void arcAbs(float f2, float f3, float f4, boolean bl, boolean bl2, float f5, float f6) throws ParseException {
        this.command((short)10);
        this.param(f2);
        this.param(f3);
        this.param(f4);
        this.param(bl ? 1.0f : 0.0f);
        this.param(bl2 ? 1.0f : 0.0f);
        this.param(f5);
        this.param(f6);
    }

    protected void command(short s2) throws ParseException {
        if (this.cindex == this.c.length) {
            this.cs.add(this.c);
            this.c = new short[this.c.length * 2 + 1];
            this.cindex = 0;
        }
        this.c[this.cindex++] = s2;
        ++this.ccount;
    }

    protected void param(float f2) throws ParseException {
        if (this.pindex == this.p.length) {
            this.ps.add(this.p);
            this.p = new float[this.p.length * 2 + 1];
            this.pindex = 0;
        }
        this.p[this.pindex++] = f2;
        ++this.pcount;
    }

    public void endPath() throws ParseException {
        Object[] objectArray;
        short[] sArray = new short[this.ccount];
        int n2 = 0;
        Iterator iterator = this.cs.iterator();
        while (iterator.hasNext()) {
            objectArray = (short[])iterator.next();
            System.arraycopy(objectArray, 0, sArray, n2, objectArray.length);
            n2 += objectArray.length;
        }
        System.arraycopy(this.c, 0, sArray, n2, this.cindex);
        this.cs.clear();
        this.c = sArray;
        objectArray = new float[this.pcount];
        n2 = 0;
        iterator = this.ps.iterator();
        while (iterator.hasNext()) {
            float[] fArray = (float[])iterator.next();
            System.arraycopy(fArray, 0, objectArray, n2, fArray.length);
            n2 += fArray.length;
        }
        System.arraycopy(this.p, 0, objectArray, n2, this.pindex);
        this.ps.clear();
        this.p = objectArray;
    }
}

