/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import org.mozilla.javascript.GeneratedClassLoader;

public class RhinoClassLoader
extends URLClassLoader
implements GeneratedClassLoader {
    protected URL documentURL;
    protected CodeSource codeSource;
    protected AccessControlContext rhinoAccessControlContext;

    public RhinoClassLoader(URL uRL, ClassLoader classLoader) {
        URL[] uRLArray;
        if (uRL != null) {
            URL[] uRLArray2 = new URL[1];
            uRLArray = uRLArray2;
            uRLArray2[0] = uRL;
        } else {
            uRLArray = new URL[]{};
        }
        super(uRLArray, classLoader);
        this.documentURL = uRL;
        if (uRL != null) {
            this.codeSource = new CodeSource(uRL, (Certificate[])null);
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(this.codeSource, this.getPermissions(this.codeSource));
        this.rhinoAccessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    static URL[] getURL(ClassLoader classLoader) {
        if (classLoader instanceof RhinoClassLoader) {
            URL uRL = ((RhinoClassLoader)classLoader).documentURL;
            if (uRL != null) {
                return new URL[]{uRL};
            }
            return new URL[0];
        }
        return new URL[0];
    }

    public Class defineClass(String string, byte[] byArray) {
        return super.defineClass(string, byArray, 0, byArray.length, this.codeSource);
    }

    public void linkClass(Class clazz) {
        super.resolveClass(clazz);
    }

    public AccessControlContext getAccessControlContext() {
        return this.rhinoAccessControlContext;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = null;
        if (codeSource != null) {
            permissionCollection = super.getPermissions(codeSource);
        }
        if (this.documentURL != null && permissionCollection != null) {
            int n2;
            String string;
            Permission permission = null;
            FilePermission filePermission = null;
            try {
                permission = this.documentURL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                permission = null;
            }
            if (permission instanceof FilePermission && !(string = permission.getName()).endsWith(File.separator) && (n2 = string.lastIndexOf(File.separator)) != -1) {
                string = string.substring(0, n2 + 1);
                string = string + "-";
                filePermission = new FilePermission(string, "read");
                permissionCollection.add(filePermission);
            }
        }
        return permissionCollection;
    }
}

