/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.svggen.font.table.GlyfCompositeComp;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfTable;

public class GlyfCompositeDescript
extends GlyfDescript {
    private List components = new ArrayList();
    protected boolean beingResolved = false;
    protected boolean resolved = false;

    public GlyfCompositeDescript(GlyfTable glyfTable, ByteArrayInputStream byteArrayInputStream) {
        super(glyfTable, (short)-1, byteArrayInputStream);
        GlyfCompositeComp glyfCompositeComp;
        do {
            glyfCompositeComp = new GlyfCompositeComp(byteArrayInputStream);
            this.components.add(glyfCompositeComp);
        } while ((glyfCompositeComp.getFlags() & 0x20) != 0);
        if ((glyfCompositeComp.getFlags() & 0x100) != 0) {
            this.readInstructions(byteArrayInputStream, byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
        }
    }

    public void resolve() {
        if (this.resolved) {
            return;
        }
        if (this.beingResolved) {
            System.err.println("Circular reference in GlyfCompositeDesc");
            return;
        }
        this.beingResolved = true;
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)iterator.next();
            glyfCompositeComp.setFirstIndex(n2);
            glyfCompositeComp.setFirstContour(n3);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfDescript == null) continue;
            glyfDescript.resolve();
            n2 += glyfDescript.getPointCount();
            n3 += glyfDescript.getContourCount();
        }
        this.resolved = true;
        this.beingResolved = false;
    }

    public int getEndPtOfContours(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeCompEndPt(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getEndPtOfContours(n2 - glyfCompositeComp.getFirstContour()) + glyfCompositeComp.getFirstIndex();
        }
        return 0;
    }

    public byte getFlags(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            return glyfDescript.getFlags(n2 - glyfCompositeComp.getFirstIndex());
        }
        return 0;
    }

    public short getXCoordinate(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n3 = n2 - glyfCompositeComp.getFirstIndex();
            short s2 = glyfDescript.getXCoordinate(n3);
            short s3 = glyfDescript.getYCoordinate(n3);
            short s4 = (short)glyfCompositeComp.scaleX(s2, s3);
            s4 = (short)(s4 + glyfCompositeComp.getXTranslate());
            return s4;
        }
        return 0;
    }

    public short getYCoordinate(int n2) {
        GlyfCompositeComp glyfCompositeComp = this.getCompositeComp(n2);
        if (glyfCompositeComp != null) {
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            int n3 = n2 - glyfCompositeComp.getFirstIndex();
            short s2 = glyfDescript.getXCoordinate(n3);
            short s3 = glyfDescript.getYCoordinate(n3);
            short s4 = (short)glyfCompositeComp.scaleY(s2, s3);
            s4 = (short)(s4 + glyfCompositeComp.getYTranslate());
            return s4;
        }
        return 0;
    }

    public boolean isComposite() {
        return true;
    }

    public int getPointCount() {
        if (!this.resolved) {
            System.err.println("getPointCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return glyfCompositeComp.getFirstIndex() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getPointCount();
    }

    public int getContourCount() {
        if (!this.resolved) {
            System.err.println("getContourCount called on unresolved GlyfCompositeDescript");
        }
        GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(this.components.size() - 1);
        return glyfCompositeComp.getFirstContour() + this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex()).getContourCount();
    }

    public int getComponentIndex(int n2) {
        return ((GlyfCompositeComp)this.components.get(n2)).getFirstIndex();
    }

    public int getComponentCount() {
        return this.components.size();
    }

    protected GlyfCompositeComp getCompositeComp(int n2) {
        for (int i2 = 0; i2 < this.components.size(); ++i2) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(i2);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstIndex() > n2 || n2 >= glyfCompositeComp.getFirstIndex() + glyfDescript.getPointCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }

    protected GlyfCompositeComp getCompositeCompEndPt(int n2) {
        for (int i2 = 0; i2 < this.components.size(); ++i2) {
            GlyfCompositeComp glyfCompositeComp = (GlyfCompositeComp)this.components.get(i2);
            GlyfDescript glyfDescript = this.parentTable.getDescription(glyfCompositeComp.getGlyphIndex());
            if (glyfCompositeComp.getFirstContour() > n2 || n2 >= glyfCompositeComp.getFirstContour() + glyfDescript.getContourCount()) continue;
            return glyfCompositeComp;
        }
        return null;
    }
}

