/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class TextureFactory {
    private static TextureFactory fac = null;
    private Map textures = new HashMap(1);
    private static final int SIZE = 10;
    private float scale = 1.0f;

    private TextureFactory(float f2) {
    }

    public static TextureFactory getInstance() {
        if (fac == null) {
            fac = new TextureFactory(1.0f);
        }
        return fac;
    }

    public static TextureFactory getInstance(float f2) {
        if (fac == null) {
            fac = new TextureFactory(f2);
        }
        return fac;
    }

    public void reset() {
        this.textures.clear();
    }

    public Paint getTexture(int n2) {
        Integer n3 = new Integer(n2);
        if (this.textures.containsKey(n3)) {
            Paint paint = (Paint)this.textures.get(n3);
            return paint;
        }
        Paint paint = this.createTexture(n2, null, null);
        if (paint != null) {
            this.textures.put(n3, paint);
        }
        return paint;
    }

    public Paint getTexture(int n2, Color color) {
        ColoredTexture coloredTexture = new ColoredTexture(n2, color, null);
        if (this.textures.containsKey(coloredTexture)) {
            Paint paint = (Paint)this.textures.get(coloredTexture);
            return paint;
        }
        Paint paint = this.createTexture(n2, color, null);
        if (paint != null) {
            this.textures.put(coloredTexture, paint);
        }
        return paint;
    }

    public Paint getTexture(int n2, Color color, Color color2) {
        ColoredTexture coloredTexture = new ColoredTexture(n2, color, color2);
        if (this.textures.containsKey(coloredTexture)) {
            Paint paint = (Paint)this.textures.get(coloredTexture);
            return paint;
        }
        Paint paint = this.createTexture(n2, color, color2);
        if (paint != null) {
            this.textures.put(coloredTexture, paint);
        }
        return paint;
    }

    private Paint createTexture(int n2, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 10.0f, 10.0f);
        TexturePaint texturePaint = null;
        boolean bl = false;
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, 10, 10);
        }
        if (color == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(color);
        }
        if (n2 == 1) {
            for (int i2 = 0; i2 < 5; ++i2) {
                graphics2D.drawLine(i2 * 10, 0, i2 * 10, 10);
            }
            bl = true;
        } else if (n2 == 0) {
            for (int i3 = 0; i3 < 5; ++i3) {
                graphics2D.drawLine(0, i3 * 10, 10, i3 * 10);
            }
            bl = true;
        } else if (n2 == 3) {
            for (int i4 = 0; i4 < 5; ++i4) {
                graphics2D.drawLine(0, i4 * 10, i4 * 10, 0);
            }
            bl = true;
        } else if (n2 == 2) {
            for (int i5 = 0; i5 < 5; ++i5) {
                graphics2D.drawLine(0, i5 * 10, 10 - i5 * 10, 10);
            }
            bl = true;
        } else if (n2 == 5) {
            for (int i6 = 0; i6 < 5; ++i6) {
                graphics2D.drawLine(0, i6 * 10, i6 * 10, 0);
                graphics2D.drawLine(0, i6 * 10, 10 - i6 * 10, 10);
            }
            bl = true;
        } else if (n2 == 4) {
            for (int i7 = 0; i7 < 5; ++i7) {
                graphics2D.drawLine(i7 * 10, 0, i7 * 10, 10);
                graphics2D.drawLine(0, i7 * 10, 10, i7 * 10);
            }
            bl = true;
        }
        bufferedImage.flush();
        if (bl) {
            texturePaint = new TexturePaint(bufferedImage, float_);
        }
        return texturePaint;
    }

    private class ColoredTexture {
        final int textureId;
        final Color foreground;
        final Color background;

        ColoredTexture(int n2, Color color, Color color2) {
            this.textureId = n2;
            this.foreground = color;
            this.background = color2;
        }
    }
}

