/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.batik.ext.awt.geom.Polygon2D;
import org.apache.batik.ext.awt.geom.Polyline2D;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.WMFFont;
import org.apache.batik.transcoder.wmf.tosvg.WMFUtilities;

public class WMFHeaderProperties
extends AbstractWMFReader {
    private static final Integer INTEGER_0 = new Integer(0);
    protected DataInputStream stream;
    private int _bleft;
    private int _bright;
    private int _btop;
    private int _bbottom;
    private int _bwidth;
    private int _bheight;
    private int _ileft;
    private int _iright;
    private int _itop;
    private int _ibottom;
    private float scale = 1.0f;
    private int startX = 0;
    private int startY = 0;
    private int currentHorizAlign = 0;
    private int currentVertAlign = 0;
    private WMFFont wf = null;
    private static final FontRenderContext fontCtx = new FontRenderContext(new AffineTransform(), false, true);
    private transient boolean firstEffectivePaint = true;
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    public static final int OBJ_BITMAP = 7;
    public static final int OBJ_REGION = 8;

    public WMFHeaderProperties(File file) throws IOException {
        this.reset();
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    public WMFHeaderProperties() {
    }

    public void closeResource() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFile(File file) throws IOException {
        this.stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.read(this.stream);
        this.stream.close();
    }

    public void reset() {
        this.left = 0;
        this.right = 0;
        this.top = 1000;
        this.bottom = 1000;
        this.inch = 84;
        this._bleft = -1;
        this._bright = -1;
        this._btop = -1;
        this._bbottom = -1;
        this._ileft = -1;
        this._iright = -1;
        this._itop = -1;
        this._ibottom = -1;
        this._bwidth = -1;
        this._bheight = -1;
        this.vpW = -1;
        this.vpH = -1;
        this.vpX = 0;
        this.vpY = 0;
        this.startX = 0;
        this.startY = 0;
        this.scaleXY = 1.0f;
        this.firstEffectivePaint = true;
    }

    public DataInputStream getStream() {
        return this.stream;
    }

    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        block34: while (n2 > 0) {
            n3 = this.readInt(dataInputStream);
            n3 -= 3;
            n2 = this.readShort(dataInputStream);
            if (n2 <= 0) break;
            switch (n2) {
                case 259: {
                    int n7 = this.readShort(dataInputStream);
                    if (n7 != 8) continue block34;
                    this.isotropic = false;
                    continue block34;
                }
                case 523: {
                    this.vpY = this.readShort(dataInputStream);
                    this.vpX = this.readShort(dataInputStream);
                    continue block34;
                }
                case 524: {
                    this.vpH = this.readShort(dataInputStream);
                    this.vpW = this.readShort(dataInputStream);
                    if (!this.isotropic) {
                        this.scaleXY = (float)this.vpW / (float)this.vpH;
                    }
                    this.vpW = (int)((float)this.vpW * this.scaleXY);
                    continue block34;
                }
                case 762: {
                    int n7 = 0;
                    short s2 = this.readShort(dataInputStream);
                    this.readInt(dataInputStream);
                    int n8 = this.readInt(dataInputStream);
                    int n9 = n8 & 0xFF;
                    int n10 = (n8 & 0xFF00) >> 8;
                    int n11 = (n8 & 0xFF0000) >> 16;
                    Color color = new Color(n9, n10, n11);
                    if (n3 == 6) {
                        this.readShort(dataInputStream);
                    }
                    if (s2 == 5) {
                        n7 = this.addObjectAt(4, color, n7);
                        continue block34;
                    }
                    n7 = this.addObjectAt(1, color, n7);
                    continue block34;
                }
                case 764: {
                    int n7 = 0;
                    short s3 = this.readShort(dataInputStream);
                    int n12 = this.readInt(dataInputStream);
                    int n13 = n12 & 0xFF;
                    int n14 = (n12 & 0xFF00) >> 8;
                    int n15 = (n12 & 0xFF0000) >> 16;
                    Color color = new Color(n13, n14, n15);
                    this.readShort(dataInputStream);
                    if (s3 == 5) {
                        n7 = this.addObjectAt(5, color, n7);
                        continue block34;
                    }
                    n7 = this.addObjectAt(2, color, n7);
                    continue block34;
                }
                case 302: {
                    int n7 = this.readShort(dataInputStream);
                    if (n3 > 1) {
                        for (int i2 = 1; i2 < n3; ++i2) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.currentHorizAlign = WMFUtilities.getHorizontalAlignment(n7);
                    this.currentVertAlign = WMFUtilities.getVerticalAlignment(n7);
                    continue block34;
                }
                case 2610: {
                    int n16;
                    short s4 = this.readShort(dataInputStream);
                    int n17 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    int n18 = this.readShort(dataInputStream);
                    short s5 = this.readShort(dataInputStream);
                    int n19 = 4;
                    boolean bl = false;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    if ((s5 & 4) != 0) {
                        n20 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                        n21 = this.readShort(dataInputStream);
                        n22 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                        n23 = this.readShort(dataInputStream);
                        n19 += 4;
                        bl = true;
                    }
                    byte[] byArray = new byte[n18];
                    for (n16 = 0; n16 < n18; ++n16) {
                        byArray[n16] = dataInputStream.readByte();
                    }
                    String string = WMFUtilities.decodeString(this.wf, byArray);
                    n19 += (n18 + 1) / 2;
                    if (n18 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n19 < n3) {
                        for (int i3 = n19; i3 < n3; ++i3) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout(string, this.wf.font, fontCtx);
                    int n24 = (int)textLayout.getBounds().getWidth();
                    n17 = (int)textLayout.getBounds().getX();
                    int n25 = (int)this.getVerticalAlignmentValue(textLayout, this.currentVertAlign);
                    this.resizeBounds(n17, s4);
                    this.resizeBounds(n17 + n24, s4 + n25);
                    this.firstEffectivePaint = false;
                    continue block34;
                }
                case 1313: 
                case 1583: {
                    int n26 = this.readShort(dataInputStream);
                    int n27 = 1;
                    byte[] byArray = new byte[n26];
                    for (int i4 = 0; i4 < n26; ++i4) {
                        byArray[i4] = dataInputStream.readByte();
                    }
                    String string = WMFUtilities.decodeString(this.wf, byArray);
                    if (n26 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n27 += (n26 + 1) / 2;
                    short s6 = this.readShort(dataInputStream);
                    int n28 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    if ((n27 += 2) < n3) {
                        for (int i5 = n27; i5 < n3; ++i5) {
                            this.readShort(dataInputStream);
                        }
                    }
                    TextLayout textLayout = new TextLayout(string, this.wf.font, fontCtx);
                    int n21 = (int)textLayout.getBounds().getWidth();
                    n28 = (int)textLayout.getBounds().getX();
                    int n22 = (int)this.getVerticalAlignmentValue(textLayout, this.currentVertAlign);
                    this.resizeBounds(n28, s6);
                    this.resizeBounds(n28 + n21, s6 + n22);
                    continue block34;
                }
                case 763: {
                    int n29;
                    short s7 = this.readShort(dataInputStream);
                    float f2 = (int)(this.scaleY * (float)s7);
                    short s8 = this.readShort(dataInputStream);
                    short s9 = this.readShort(dataInputStream);
                    short s10 = this.readShort(dataInputStream);
                    short s11 = this.readShort(dataInputStream);
                    byte by = dataInputStream.readByte();
                    int n21 = dataInputStream.readByte();
                    int n22 = dataInputStream.readByte();
                    int n23 = dataInputStream.readByte() & 0xFF;
                    byte by2 = dataInputStream.readByte();
                    byte by3 = dataInputStream.readByte();
                    int n16 = dataInputStream.readByte();
                    byte by4 = dataInputStream.readByte();
                    int n30 = by > 0 ? 2 : 0;
                    n30 |= s11 > 400 ? 1 : 0;
                    int n24 = 2 * (n3 - 9);
                    byte[] byArray = new byte[n24];
                    for (int i6 = 0; i6 < n24; ++i6) {
                        byArray[i6] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    for (n29 = 0; n29 < string.length() && (Character.isLetterOrDigit(string.charAt(n29)) || Character.isWhitespace(string.charAt(n29))); ++n29) {
                    }
                    string = n29 > 0 ? string.substring(0, n29) : "System";
                    if (f2 < 0.0f) {
                        f2 = -f2;
                    }
                    int n31 = 0;
                    Font font = new Font(string, n30, (int)f2);
                    font = font.deriveFont(f2);
                    WMFFont wMFFont = new WMFFont(font, n23, n21, n22, by, s11, s10, s9);
                    n31 = this.addObjectAt(3, wMFFont, n31);
                    continue block34;
                }
                case 1791: {
                    int n32 = 0;
                    for (int i7 = 0; i7 < n3; ++i7) {
                        this.readShort(dataInputStream);
                    }
                    n32 = this.addObjectAt(6, INTEGER_0, 0);
                    continue block34;
                }
                case 247: {
                    int n33 = 0;
                    for (int i8 = 0; i8 < n3; ++i8) {
                        this.readShort(dataInputStream);
                    }
                    n33 = this.addObjectAt(8, INTEGER_0, 0);
                    continue block34;
                }
                case 301: {
                    int n34 = this.readShort(dataInputStream);
                    if ((n34 & Integer.MIN_VALUE) != 0) continue block34;
                    GdiObject gdiObject = this.getObject(n34);
                    if (!gdiObject.used) continue block34;
                    switch (gdiObject.type) {
                        case 1: {
                            n5 = n34;
                            break;
                        }
                        case 2: {
                            n4 = n34;
                            break;
                        }
                        case 3: {
                            this.wf = (WMFFont)gdiObject.obj;
                            n6 = n34;
                            break;
                        }
                        case 4: {
                            n5 = -1;
                            break;
                        }
                        case 5: {
                            n4 = -1;
                        }
                    }
                    continue block34;
                }
                case 496: {
                    int n34 = this.readShort(dataInputStream);
                    GdiObject gdiObject = this.getObject(n34);
                    if (n34 == n4) {
                        n4 = -1;
                    } else if (n34 == n5) {
                        n5 = -1;
                    } else if (n34 == n6) {
                        n6 = -1;
                    }
                    gdiObject.clear();
                    continue block34;
                }
                case 531: {
                    short s12 = this.readShort(dataInputStream);
                    int n35 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    if (n5 >= 0) {
                        this.resizeBounds(this.startX, this.startY);
                        this.resizeBounds(n35, s12);
                        this.firstEffectivePaint = false;
                    }
                    this.startX = n35;
                    this.startY = s12;
                    continue block34;
                }
                case 532: {
                    this.startY = this.readShort(dataInputStream);
                    this.startX = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    continue block34;
                }
                case 1336: {
                    int n36;
                    int n21;
                    int n37 = this.readShort(dataInputStream);
                    int[] nArray = new int[n37];
                    int n38 = 0;
                    for (n36 = 0; n36 < n37; ++n36) {
                        nArray[n36] = this.readShort(dataInputStream);
                        n38 += nArray[n36];
                    }
                    n36 = n37 + 1;
                    for (int i9 = 0; i9 < n37; ++i9) {
                        for (int i10 = 0; i10 < nArray[i9]; ++i10) {
                            int n39 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                            n21 = this.readShort(dataInputStream);
                            if (n4 < 0 && n5 < 0) continue;
                            this.resizeBounds(n39, n21);
                        }
                    }
                    this.firstEffectivePaint = false;
                    continue block34;
                }
                case 804: {
                    int n40 = this.readShort(dataInputStream);
                    float[] fArray = new float[n40 + 1];
                    float[] fArray2 = new float[n40 + 1];
                    for (int i11 = 0; i11 < n40; ++i11) {
                        fArray[i11] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray2[i11] = this.readShort(dataInputStream);
                    }
                    fArray[n40] = fArray[0];
                    fArray2[n40] = fArray2[0];
                    Polygon2D polygon2D = new Polygon2D(fArray, fArray2, n40);
                    this.paint(n4, n5, polygon2D);
                    continue block34;
                }
                case 805: {
                    int n41 = this.readShort(dataInputStream);
                    float[] fArray = new float[n41];
                    float[] fArray3 = new float[n41];
                    for (int i12 = 0; i12 < n41; ++i12) {
                        fArray[i12] = (float)this.readShort(dataInputStream) * this.scaleXY;
                        fArray3[i12] = this.readShort(dataInputStream);
                    }
                    Polyline2D polyline2D = new Polyline2D(fArray, fArray3, n41);
                    this.paintWithPen(n5, polyline2D);
                    continue block34;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    short s13 = this.readShort(dataInputStream);
                    int n42 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s14 = this.readShort(dataInputStream);
                    int n43 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n43, s14, n42 - n43, s13 - s14);
                    this.paint(n4, n5, float_);
                    continue block34;
                }
                case 1564: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s15 = this.readShort(dataInputStream);
                    int n44 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s16 = this.readShort(dataInputStream);
                    int n45 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n45, s16, n44 - n45, s15 - s16);
                    this.paint(n4, n5, float_);
                    continue block34;
                }
                case 2071: 
                case 2074: 
                case 2096: {
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    short s17 = this.readShort(dataInputStream);
                    int n46 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s18 = this.readShort(dataInputStream);
                    int n47 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n47, s18, n46 - n47, s17 - s18);
                    this.paint(n4, n5, float_);
                    continue block34;
                }
                case 1565: {
                    this.readInt(dataInputStream);
                    short s19 = this.readShort(dataInputStream);
                    int n48 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    int n49 = (int)((float)this.readShort(dataInputStream) * this.scaleXY);
                    short s20 = this.readShort(dataInputStream);
                    if (n5 >= 0) {
                        this.resizeBounds(n49, s20);
                    }
                    if (n5 < 0) continue block34;
                    this.resizeBounds(n49 + n48, s20 + s19);
                    continue block34;
                }
                case 2881: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f3 = this.readShort(dataInputStream);
                    float f4 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f5 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    float f6 = (float)this.readShort(dataInputStream) * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH * this.scaleXY;
                    f4 = f4 * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    f3 = f3 * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    this.resizeImageBounds((int)f6, (int)f5);
                    this.resizeImageBounds((int)(f6 + f4), (int)(f5 + f3));
                    int n50 = 2 * n3 - 20;
                    for (int i13 = 0; i13 < n50; ++i13) {
                        dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 3907: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f7 = this.readShort(dataInputStream);
                    float f8 = (float)this.readShort(dataInputStream) * this.scaleXY;
                    float f9 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    float f10 = (float)this.readShort(dataInputStream) * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH * this.scaleXY;
                    f8 = f8 * this.getVpWFactor() * (float)this.inch / PIXEL_PER_INCH;
                    f7 = f7 * this.getVpHFactor() * (float)this.inch / PIXEL_PER_INCH;
                    this.resizeImageBounds((int)f10, (int)f9);
                    this.resizeImageBounds((int)(f10 + f8), (int)(f9 + f7));
                    int n51 = 2 * n3 - 22;
                    byte[] byArray = new byte[n51];
                    for (int i14 = 0; i14 < n51; ++i14) {
                        byArray[i14] = dataInputStream.readByte();
                    }
                    continue block34;
                }
                case 2368: {
                    dataInputStream.readInt();
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    this.readShort(dataInputStream);
                    float f11 = (float)this.readShort(dataInputStream) * (float)this.inch / PIXEL_PER_INCH * this.getVpHFactor();
                    float f12 = (float)this.readShort(dataInputStream) * (float)this.inch / PIXEL_PER_INCH * this.getVpWFactor() * this.scaleXY;
                    float f13 = (float)this.inch / PIXEL_PER_INCH * this.getVpHFactor() * (float)this.readShort(dataInputStream);
                    float f14 = (float)this.inch / PIXEL_PER_INCH * this.getVpWFactor() * (float)this.readShort(dataInputStream) * this.scaleXY;
                    this.resizeImageBounds((int)f14, (int)f13);
                    this.resizeImageBounds((int)(f14 + f12), (int)(f13 + f11));
                    continue block34;
                }
            }
            for (int i15 = 0; i15 < n3; ++i15) {
                this.readShort(dataInputStream);
            }
        }
        if (!this.isAldus) {
            this.width = this.vpW;
            this.height = this.vpH;
            this.right = this.vpX;
            this.left = this.vpX + this.vpW;
            this.top = this.vpY;
            this.bottom = this.vpY + this.vpH;
        }
        this.resetBounds();
        return true;
    }

    public int getWidthBoundsPixels() {
        return this._bwidth;
    }

    public int getHeightBoundsPixels() {
        return this._bheight;
    }

    public int getWidthBoundsUnits() {
        return (int)((float)this.inch * (float)this._bwidth / PIXEL_PER_INCH);
    }

    public int getHeightBoundsUnits() {
        return (int)((float)this.inch * (float)this._bheight / PIXEL_PER_INCH);
    }

    public int getXOffset() {
        return this._bleft;
    }

    public int getYOffset() {
        return this._btop;
    }

    private void resetBounds() {
        this.scale = (float)this.getWidthPixels() / (float)this.vpW;
        if (this._bright != -1) {
            this._bright = (int)(this.scale * (float)(this.vpX + this._bright));
            this._bleft = (int)(this.scale * (float)(this.vpX + this._bleft));
            this._bbottom = (int)(this.scale * (float)(this.vpY + this._bbottom));
            this._btop = (int)(this.scale * (float)(this.vpY + this._btop));
        }
        if (this._iright != -1) {
            this._iright = (int)((float)this._iright * (float)this.getWidthPixels() / (float)this.width);
            this._ileft = (int)((float)this._ileft * (float)this.getWidthPixels() / (float)this.width);
            this._ibottom = (int)((float)this._ibottom * (float)this.getWidthPixels() / (float)this.width);
            this._itop = (int)((float)this._itop * (float)this.getWidthPixels() / (float)this.width);
            if (this._bright == -1 || this._iright > this._bright) {
                this._bright = this._iright;
            }
            if (this._bleft == -1 || this._ileft < this._bleft) {
                this._bleft = this._ileft;
            }
            if (this._btop == -1 || this._itop < this._btop) {
                this._btop = this._itop;
            }
            if (this._bbottom == -1 || this._ibottom > this._bbottom) {
                this._bbottom = this._ibottom;
            }
        }
        if (this._bleft != -1 && this._bright != -1) {
            this._bwidth = this._bright - this._bleft;
        }
        if (this._btop != -1 && this._bbottom != -1) {
            this._bheight = this._bbottom - this._btop;
        }
    }

    private void resizeBounds(int n2, int n3) {
        if (this._bleft == -1) {
            this._bleft = n2;
        } else if (n2 < this._bleft) {
            this._bleft = n2;
        }
        if (this._bright == -1) {
            this._bright = n2;
        } else if (n2 > this._bright) {
            this._bright = n2;
        }
        if (this._btop == -1) {
            this._btop = n3;
        } else if (n3 < this._btop) {
            this._btop = n3;
        }
        if (this._bbottom == -1) {
            this._bbottom = n3;
        } else if (n3 > this._bbottom) {
            this._bbottom = n3;
        }
    }

    private void resizeImageBounds(int n2, int n3) {
        if (this._ileft == -1) {
            this._ileft = n2;
        } else if (n2 < this._ileft) {
            this._ileft = n2;
        }
        if (this._iright == -1) {
            this._iright = n2;
        } else if (n2 > this._iright) {
            this._iright = n2;
        }
        if (this._itop == -1) {
            this._itop = n3;
        } else if (n3 < this._itop) {
            this._itop = n3;
        }
        if (this._ibottom == -1) {
            this._ibottom = n3;
        } else if (n3 > this._ibottom) {
            this._ibottom = n3;
        }
    }

    private Color getColorFromObject(int n2) {
        Object var2_2 = null;
        if (n2 >= 0) {
            GdiObject gdiObject = this.getObject(n2);
            return (Color)gdiObject.obj;
        }
        return null;
    }

    private void paint(int n2, int n3, Shape shape) {
        if (n2 >= 0 || n3 >= 0) {
            Color color = n2 >= 0 ? this.getColorFromObject(n2) : this.getColorFromObject(n3);
            if (!this.firstEffectivePaint || !color.equals(Color.white)) {
                Rectangle rectangle = shape.getBounds();
                this.resizeBounds((int)rectangle.getMinX(), (int)rectangle.getMinY());
                this.resizeBounds((int)rectangle.getMaxX(), (int)rectangle.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }

    private void paintWithPen(int n2, Shape shape) {
        if (n2 >= 0) {
            Color color = this.getColorFromObject(n2);
            if (!this.firstEffectivePaint || !color.equals(Color.white)) {
                Rectangle rectangle = shape.getBounds();
                this.resizeBounds((int)rectangle.getMinX(), (int)rectangle.getMinY());
                this.resizeBounds((int)rectangle.getMaxX(), (int)rectangle.getMaxY());
                this.firstEffectivePaint = false;
            }
        }
    }

    private float getVerticalAlignmentValue(TextLayout textLayout, int n2) {
        if (n2 == 24) {
            return -textLayout.getAscent();
        }
        if (n2 == 0) {
            return textLayout.getAscent() + textLayout.getDescent();
        }
        return 0.0f;
    }
}

