/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 1 && stringArray[0].equals("-f")) {
            bl = true;
        } else if (stringArray.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File file = new File(".");
        File file2 = null;
        String[] stringArray2 = file.list();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (!stringArray2[i2].startsWith("batik-")) continue;
            file2 = new File(stringArray2[i2]);
            if (file2.isDirectory()) break;
            file2 = null;
        }
        if (file2 == null || !file2.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            Object object;
            Iterator iterator;
            Object object2;
            Iterator<Object> iterator2;
            Object object3;
            Object object4;
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            ClassFileUtilities.collectJars(file2, hashMap2, hashMap);
            HashSet<JarFile> hashSet = new HashSet<JarFile>();
            Iterator<Object> iterator3 = hashMap2.values().iterator();
            while (iterator3.hasNext()) {
                hashSet.add(((Jar)iterator3.next()).jarFile);
            }
            iterator3 = hashMap.values().iterator();
            while (iterator3.hasNext()) {
                object4 = (ClassFile)iterator3.next();
                object3 = ClassFileUtilities.getClassDependencies(((ClassFile)object4).getInputStream(), hashSet, false);
                iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    object2 = (ClassFile)hashMap.get(iterator2.next());
                    if (object4 == object2 || object2 == null) continue;
                    ((ClassFile)object4).deps.add(object2);
                }
            }
            iterator3 = hashMap.values().iterator();
            while (iterator3.hasNext()) {
                object4 = (ClassFile)iterator3.next();
                object3 = ((ClassFile)object4).deps.iterator();
                while (object3.hasNext()) {
                    iterator2 = (ClassFile)object3.next();
                    object2 = ((ClassFile)object4).jar;
                    iterator = ((ClassFile)((Object)iterator2)).jar;
                    if (((ClassFile)object4).name.equals(((ClassFile)((Object)iterator2)).name) || iterator == object2 || ((Jar)object2).files.contains(((ClassFile)((Object)iterator2)).name)) continue;
                    object = (Integer)((Jar)object2).deps.get(iterator);
                    if (object == null) {
                        ((Jar)object2).deps.put(iterator, new Integer(1));
                        continue;
                    }
                    ((Jar)object2).deps.put(iterator, new Integer((Integer)object + 1));
                }
            }
            object4 = new ArrayList(10);
            iterator3 = hashMap2.values().iterator();
            while (iterator3.hasNext()) {
                object3 = (Jar)iterator3.next();
                iterator2 = ((Jar)object3).deps.keySet().iterator();
                while (iterator2.hasNext()) {
                    object2 = (Jar)iterator2.next();
                    iterator = new Triple();
                    ((Triple)((Object)iterator)).from = object3;
                    ((Triple)((Object)iterator)).to = object2;
                    ((Triple)((Object)iterator)).count = (Integer)((Jar)object3).deps.get(object2);
                    object4.add(iterator);
                }
            }
            Collections.sort(object4);
            iterator3 = object4.iterator();
            while (iterator3.hasNext()) {
                object3 = (Triple)iterator3.next();
                System.out.println(((Triple)object3).count + "," + ((Triple)object3).from.name + "," + ((Triple)object3).to.name);
                if (!bl) continue;
                iterator2 = ((Triple)object3).from.files.iterator();
                while (iterator2.hasNext()) {
                    object2 = (ClassFile)iterator2.next();
                    iterator = ((ClassFile)object2).deps.iterator();
                    while (iterator.hasNext()) {
                        object = (ClassFile)iterator.next();
                        if (((ClassFile)object).jar != ((Triple)object3).to || ((Triple)object3).from.files.contains(((ClassFile)object).name)) continue;
                        System.out.println("\t" + ((ClassFile)object2).name + " --> " + ((ClassFile)object).name);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void collectJars(File file, Map map, Map map2) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string = fileArray[i2].getName();
            if (string.endsWith(".jar") && fileArray[i2].isFile()) {
                Jar jar = new Jar();
                jar.name = fileArray[i2].getPath();
                jar.file = fileArray[i2];
                jar.jarFile = new JarFile(fileArray[i2]);
                map.put(jar.name, jar);
                Enumeration<JarEntry> enumeration = jar.jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    if (!string2.endsWith(".class")) continue;
                    ClassFile classFile = new ClassFile();
                    classFile.name = string2;
                    classFile.jar = jar;
                    map2.put(jar.name + '!' + classFile.name, classFile);
                    jar.files.add(classFile);
                }
                continue;
            }
            if (!fileArray[i2].isDirectory()) continue;
            ClassFileUtilities.collectJars(fileArray[i2], map, map2);
        }
    }

    public static Set getClassDependencies(String string, Set set, boolean bl) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(string), set, bl);
    }

    public static Set getClassDependencies(InputStream inputStream, Set set, boolean bl) throws IOException {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ClassFileUtilities.computeClassDependencies(inputStream, set, hashSet2, hashSet, bl);
        return hashSet;
    }

    private static void computeClassDependencies(InputStream inputStream, Set set, Set set2, Set set3, boolean bl) throws IOException {
        Iterator iterator = ClassFileUtilities.getClassDependencies(inputStream).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (set2.contains(string)) continue;
            set2.add(string);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Object object;
                InputStream inputStream2 = null;
                String string2 = null;
                Object e2 = iterator2.next();
                if (e2 instanceof JarFile) {
                    object = (JarFile)e2;
                    String string3 = string + ".class";
                    ZipEntry zipEntry = ((JarFile)object).getEntry(string3);
                    if (zipEntry != null) {
                        string2 = ((ZipFile)object).getName() + '!' + string3;
                        inputStream2 = ((JarFile)object).getInputStream(zipEntry);
                    }
                } else {
                    string2 = (String)e2 + '/' + string + ".class";
                    object = new File(string2);
                    if (((File)object).isFile()) {
                        inputStream2 = new FileInputStream((File)object);
                    }
                }
                if (inputStream2 == null) continue;
                set3.add(string2);
                if (!bl) continue;
                ClassFileUtilities.computeClassDependencies(inputStream2, set, set2, set3, bl);
            }
        }
    }

    public static Set getClassDependencies(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dataInputStream.readInt();
        int n2 = dataInputStream.readShort();
        String[] stringArray = new String[n2];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        block8: for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = dataInputStream.readByte() & 0xFF;
            switch (n3) {
                case 5: 
                case 6: {
                    dataInputStream.readLong();
                    ++i2;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.readInt();
                    continue block8;
                }
                case 7: {
                    hashSet.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    continue block8;
                }
                case 8: {
                    dataInputStream.readShort();
                    continue block8;
                }
                case 12: {
                    dataInputStream.readShort();
                    hashSet2.add(new Integer(dataInputStream.readShort() & 0xFFFF));
                    continue block8;
                }
                case 1: {
                    stringArray[i2] = dataInputStream.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + n3);
                }
            }
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(stringArray[(Integer)iterator.next()]);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet3.addAll(ClassFileUtilities.getDescriptorClasses(stringArray[(Integer)iterator.next()]));
        }
        return hashSet3;
    }

    protected static Set getDescriptorClasses(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        char c2 = string.charAt(n2);
        switch (c2) {
            case '(': {
                StringBuffer stringBuffer;
                block14: while (true) {
                    c2 = string.charAt(++n2);
                    switch (c2) {
                        case '[': {
                            while ((c2 = string.charAt(++n2)) == '[') {
                            }
                            if (c2 != 'L') continue block14;
                        }
                        case 'L': {
                            c2 = string.charAt(++n2);
                            stringBuffer = new StringBuffer();
                            while (c2 != ';') {
                                stringBuffer.append(c2);
                                c2 = string.charAt(++n2);
                            }
                            hashSet.add(stringBuffer.toString());
                            continue block14;
                        }
                        default: {
                            continue block14;
                        }
                        case ')': 
                    }
                    break;
                }
                c2 = string.charAt(++n2);
                switch (c2) {
                    case '[': {
                        while ((c2 = string.charAt(++n2)) == '[') {
                        }
                        if (c2 != 'L') break;
                    }
                    case 'L': {
                        c2 = string.charAt(++n2);
                        stringBuffer = new StringBuffer();
                        while (c2 != ';') {
                            stringBuffer.append(c2);
                            c2 = string.charAt(++n2);
                        }
                        hashSet.add(stringBuffer.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c2 = string.charAt(++n2)) == '[') {
                }
                if (c2 != 'L') break;
            }
            case 'L': {
                c2 = string.charAt(++n2);
                StringBuffer stringBuffer = new StringBuffer();
                while (c2 != ';') {
                    stringBuffer.append(c2);
                    c2 = string.charAt(++n2);
                }
                hashSet.add(stringBuffer.toString());
                break;
            }
        }
        return hashSet;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object object) {
            return ((Triple)object).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

