/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class CSSMediaPanel
extends JPanel
implements ActionMap {
    protected static final String RESOURCES = "org.apache.batik.util.gui.resources.CSSMediaPanel";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.CSSMediaPanel", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected JButton removeButton;
    protected JButton addButton;
    protected JButton clearButton;
    protected DefaultListModel listModel = new DefaultListModel();
    protected JList mediaList;
    protected Map listeners = new HashMap();

    public CSSMediaPanel() {
        super(new GridBagLayout());
        this.listeners.put("AddButtonAction", new AddButtonAction());
        this.listeners.put("RemoveButtonAction", new RemoveButtonAction());
        this.listeners.put("ClearButtonAction", new ClearButtonAction());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mediaList = new JList();
        this.mediaList.setSelectionMode(0);
        this.mediaList.setModel(this.listModel);
        this.mediaList.addListSelectionListener(new MediaListSelectionListener());
        this.listModel.addListDataListener(new MediaListDataListener());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        extendedGridBagConstraints.weightx = 1.0;
        extendedGridBagConstraints.weighty = 1.0;
        extendedGridBagConstraints.fill = 1;
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 3);
        jScrollPane.getViewport().add(this.mediaList);
        this.add((Component)jScrollPane, extendedGridBagConstraints);
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        extendedGridBagConstraints.weightx = 0.0;
        extendedGridBagConstraints.weighty = 0.0;
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.anchor = 11;
        this.addButton = buttonFactory.createJButton("AddButton");
        extendedGridBagConstraints.setGridBounds(1, 0, 1, 1);
        this.add((Component)this.addButton, extendedGridBagConstraints);
        this.removeButton = buttonFactory.createJButton("RemoveButton");
        extendedGridBagConstraints.setGridBounds(1, 1, 1, 1);
        this.add((Component)this.removeButton, extendedGridBagConstraints);
        this.clearButton = buttonFactory.createJButton("ClearButton");
        extendedGridBagConstraints.setGridBounds(1, 2, 1, 1);
        this.add((Component)this.clearButton, extendedGridBagConstraints);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.removeButton.setEnabled(!this.mediaList.isSelectionEmpty());
        this.clearButton.setEnabled(!this.listModel.isEmpty());
    }

    public void setMedia(List list) {
        this.listModel.removeAllElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.listModel.addElement(iterator.next());
        }
    }

    public void setMedia(String string) {
        this.listModel.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            this.listModel.addElement(stringTokenizer.nextToken());
        }
    }

    public List getMedia() {
        ArrayList arrayList = new ArrayList(this.listModel.size());
        Enumeration enumeration = this.listModel.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public String getMediaAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.listModel.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static int showDialog(Component component, String string) {
        return CSSMediaPanel.showDialog(component, string, "");
    }

    public static int showDialog(Component component, String string, List list) {
        Dialog dialog = new Dialog(component, string, list);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.getReturnCode();
    }

    public static int showDialog(Component component, String string, String string2) {
        Dialog dialog = new Dialog(component, string, string2);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.getReturnCode();
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public static void main(String[] stringArray) {
        String string = "all aural braille embossed handheld print projection screen tty tv";
        int n2 = CSSMediaPanel.showDialog(null, "Test", string);
        System.out.println(n2);
        System.exit(0);
    }

    public static class Dialog
    extends JDialog
    implements ActionMap {
        public static final int OK_OPTION = 0;
        public static final int CANCEL_OPTION = 1;
        protected int returnCode;
        protected Map listeners = new HashMap();

        public Dialog() {
            this(null, "", "");
        }

        public Dialog(Component component, String string, List list) {
            super(JOptionPane.getFrameForComponent(component), string);
            this.listeners.put("OKButtonAction", new OKButtonAction());
            this.listeners.put("CancelButtonAction", new CancelButtonAction());
            CSSMediaPanel cSSMediaPanel = new CSSMediaPanel();
            cSSMediaPanel.setMedia(list);
            this.getContentPane().add((Component)cSSMediaPanel, "Center");
            this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        }

        public Dialog(Component component, String string, String string2) {
            super(JOptionPane.getFrameForComponent(component), string);
            this.listeners.put("OKButtonAction", new OKButtonAction());
            this.listeners.put("CancelButtonAction", new CancelButtonAction());
            CSSMediaPanel cSSMediaPanel = new CSSMediaPanel();
            cSSMediaPanel.setMedia(string2);
            this.getContentPane().add((Component)cSSMediaPanel, "Center");
            this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        protected JPanel createButtonsPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(2));
            ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
            jPanel.add(buttonFactory.createJButton("OKButton"));
            jPanel.add(buttonFactory.createJButton("CancelButton"));
            return jPanel;
        }

        public Action getAction(String string) throws MissingListenerException {
            return (Action)this.listeners.get(string);
        }

        protected class CancelButtonAction
        extends AbstractAction {
            protected CancelButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.returnCode = 1;
                Dialog.this.dispose();
            }
        }

        protected class OKButtonAction
        extends AbstractAction {
            protected OKButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.returnCode = 0;
                Dialog.this.dispose();
            }
        }
    }

    public static class AddMediumDialog
    extends JDialog
    implements ActionMap {
        public static final int OK_OPTION = 0;
        public static final int CANCEL_OPTION = 1;
        protected JComboBox medium;
        protected int returnCode;
        protected Map listeners = new HashMap();

        public AddMediumDialog(Component component) {
            super(JOptionPane.getFrameForComponent(component), resources.getString("AddMediumDialog.title"));
            this.setModal(true);
            this.listeners.put("OKButtonAction", new OKButtonAction());
            this.listeners.put("CancelButtonAction", new CancelButtonAction());
            this.getContentPane().add(this.createContentPanel(), "Center");
            this.getContentPane().add(this.createButtonsPanel(), "South");
        }

        public String getMedium() {
            return (String)this.medium.getSelectedItem();
        }

        protected Component createContentPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel.add((Component)new JLabel(resources.getString("AddMediumDialog.label")), "West");
            this.medium = new JComboBox();
            this.medium.setEditable(true);
            String string = resources.getString("Media.list");
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.medium.addItem(stringTokenizer.nextToken());
            }
            jPanel.add((Component)this.medium, "Center");
            return jPanel;
        }

        protected Component createButtonsPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(2));
            ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
            jPanel.add(buttonFactory.createJButton("OKButton"));
            jPanel.add(buttonFactory.createJButton("CancelButton"));
            return jPanel;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public Action getAction(String string) throws MissingListenerException {
            return (Action)this.listeners.get(string);
        }

        protected class CancelButtonAction
        extends AbstractAction {
            protected CancelButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AddMediumDialog.this.returnCode = 1;
                AddMediumDialog.this.dispose();
            }
        }

        protected class OKButtonAction
        extends AbstractAction {
            protected OKButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AddMediumDialog.this.returnCode = 0;
                AddMediumDialog.this.dispose();
            }
        }
    }

    protected class MediaListDataListener
    implements ListDataListener {
        protected MediaListDataListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            CSSMediaPanel.this.updateButtons();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            CSSMediaPanel.this.updateButtons();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CSSMediaPanel.this.updateButtons();
        }
    }

    protected class MediaListSelectionListener
    implements ListSelectionListener {
        protected MediaListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CSSMediaPanel.this.updateButtons();
        }
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CSSMediaPanel.this.mediaList.clearSelection();
            CSSMediaPanel.this.listModel.removeAllElements();
        }
    }

    protected class RemoveButtonAction
    extends AbstractAction {
        protected RemoveButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = CSSMediaPanel.this.mediaList.getSelectedIndex();
            CSSMediaPanel.this.mediaList.clearSelection();
            if (n2 >= 0) {
                CSSMediaPanel.this.listModel.removeElementAt(n2);
            }
        }
    }

    protected class AddButtonAction
    extends AbstractAction {
        protected AddButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddMediumDialog addMediumDialog = new AddMediumDialog(CSSMediaPanel.this);
            addMediumDialog.pack();
            addMediumDialog.setVisible(true);
            if (addMediumDialog.getReturnCode() == 1 || addMediumDialog.getMedium() == null) {
                return;
            }
            String string = addMediumDialog.getMedium().trim();
            if (string.length() == 0 || CSSMediaPanel.this.listModel.contains(string)) {
                return;
            }
            for (int i2 = 0; i2 < CSSMediaPanel.this.listModel.size() && string != null; ++i2) {
                String string2 = (String)CSSMediaPanel.this.listModel.getElementAt(i2);
                int n2 = string.compareTo(string2);
                if (n2 == 0) {
                    string = null;
                    continue;
                }
                if (n2 >= 0) continue;
                CSSMediaPanel.this.listModel.insertElementAt(string, i2);
                string = null;
            }
            if (string != null) {
                CSSMediaPanel.this.listModel.addElement(string);
            }
        }
    }
}

