/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};
    static /* synthetic */ Class class$java$lang$Boolean;

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Class getDefaultType() {
        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    }

    protected Object convertToType(Class type, Object value) throws Throwable {
        int i2;
        String stringValue = value.toString().toLowerCase();
        for (i2 = 0; i2 < this.trueStrings.length; ++i2) {
            if (!this.trueStrings[i2].equals(stringValue)) continue;
            return Boolean.TRUE;
        }
        for (i2 = 0; i2 < this.falseStrings.length; ++i2) {
            if (!this.falseStrings[i2].equals(stringValue)) continue;
            return Boolean.FALSE;
        }
        throw new ConversionException("Can't convert value '" + value + "' to a Boolean");
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i2 = 0; i2 < src.length; ++i2) {
            dst[i2] = src[i2].toLowerCase();
        }
        return dst;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

