/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section {
    protected Map<Long, String> dictionary;
    protected ClassID formatID;
    protected long offset;
    protected int size;
    protected Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.properties.length;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    protected Section() {
    }

    public Section(byte[] src, int offset) throws UnsupportedEncodingException {
        PropertyListEntry ple2;
        int i2;
        int o1 = offset;
        this.formatID = new ClassID(src, o1);
        this.offset = LittleEndian.getUInt(src, o1 += 16);
        o1 = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, o1);
        int propertyCount = (int)LittleEndian.getUInt(src, o1 += 4);
        this.properties = new Property[propertyCount];
        int pass1Offset = o1 += 4;
        ArrayList<PropertyListEntry> propertyList = new ArrayList<PropertyListEntry>(propertyCount);
        for (i2 = 0; i2 < this.properties.length; ++i2) {
            ple2 = new PropertyListEntry();
            ple2.id = (int)LittleEndian.getUInt(src, pass1Offset);
            ple2.offset = (int)LittleEndian.getUInt(src, pass1Offset += 4);
            pass1Offset += 4;
            propertyList.add(ple2);
        }
        Collections.sort(propertyList);
        for (i2 = 0; i2 < propertyCount - 1; ++i2) {
            PropertyListEntry ple1 = (PropertyListEntry)propertyList.get(i2);
            PropertyListEntry ple2 = (PropertyListEntry)propertyList.get(i2 + 1);
            ple1.length = ple2.offset - ple1.offset;
        }
        if (propertyCount > 0) {
            ple2 = (PropertyListEntry)propertyList.get(propertyCount - 1);
            ple2.length = this.size - ple2.offset;
        }
        int codepage = -1;
        Iterator i3 = propertyList.iterator();
        while (codepage == -1 && i3.hasNext()) {
            ple2 = (PropertyListEntry)i3.next();
            if (ple2.id != 1) continue;
            int o2 = (int)(this.offset + (long)ple2.offset);
            long type = LittleEndian.getUInt(src, o2);
            o2 += 4;
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = LittleEndian.getUShort(src, o2);
        }
        int i1 = 0;
        for (PropertyListEntry ple2 : propertyList) {
            Property p2 = new Property(ple2.id, src, this.offset + (long)ple2.offset, ple2.length, codepage);
            if (p2.getID() == 1L) {
                p2 = new Property(p2.getID(), p2.getType(), codepage);
            }
            this.properties[i1++] = p2;
        }
        this.dictionary = (Map)this.getProperty(0L);
    }

    public Object getProperty(long id) {
        this.wasNull = false;
        for (int i2 = 0; i2 < this.properties.length; ++i2) {
            if (id != this.properties[i2].getID()) continue;
            return this.properties[i2].getValue();
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(long id) {
        Object o2 = this.getProperty(id);
        if (o2 == null) {
            return 0;
        }
        if (!(o2 instanceof Long) && !(o2 instanceof Integer)) {
            throw new HPSFRuntimeException("This property is not an integer type, but " + o2.getClass().getName() + ".");
        }
        Number i2 = (Number)o2;
        return i2.intValue();
    }

    protected boolean getPropertyBooleanValue(int id) {
        Boolean b2 = (Boolean)this.getProperty(id);
        if (b2 == null) {
            return false;
        }
        return b2;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(long pid) {
        String s2 = null;
        if (this.dictionary != null) {
            s2 = this.dictionary.get(pid);
        }
        if (s2 == null) {
            s2 = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s2 == null) {
            s2 = "[undefined]";
        }
        return s2;
    }

    public boolean equals(Object o2) {
        long id;
        int i2;
        if (o2 == null || !(o2 instanceof Section)) {
            return false;
        }
        Section s2 = (Section)o2;
        if (!s2.getFormatID().equals(this.getFormatID())) {
            return false;
        }
        Object[] pa1 = new Property[this.getProperties().length];
        Object[] pa2 = new Property[s2.getProperties().length];
        System.arraycopy(this.getProperties(), 0, pa1, 0, pa1.length);
        System.arraycopy(s2.getProperties(), 0, pa2, 0, pa2.length);
        Property p10 = null;
        Property p20 = null;
        for (i2 = 0; i2 < pa1.length; ++i2) {
            id = pa1[i2].getID();
            if (id == 0L) {
                p10 = pa1[i2];
                pa1 = this.remove((Property[])pa1, i2);
                --i2;
            }
            if (id != 1L) continue;
            pa1 = this.remove((Property[])pa1, i2);
            --i2;
        }
        for (i2 = 0; i2 < pa2.length; ++i2) {
            id = pa2[i2].getID();
            if (id == 0L) {
                p20 = pa2[i2];
                pa2 = this.remove((Property[])pa2, i2);
                --i2;
            }
            if (id != 1L) continue;
            pa2 = this.remove((Property[])pa2, i2);
            --i2;
        }
        if (pa1.length != pa2.length) {
            return false;
        }
        boolean dictionaryEqual = true;
        if (p10 != null && p20 != null) {
            dictionaryEqual = p10.getValue().equals(p20.getValue());
        } else if (p10 != null || p20 != null) {
            dictionaryEqual = false;
        }
        if (dictionaryEqual) {
            return Util.equals(pa1, pa2);
        }
        return false;
    }

    private Property[] remove(Property[] pa, int i2) {
        Property[] h2 = new Property[pa.length - 1];
        if (i2 > 0) {
            System.arraycopy(pa, 0, h2, 0, i2);
        }
        System.arraycopy(pa, i2 + 1, h2, i2, h2.length - i2);
        return h2;
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += (long)this.getFormatID().hashCode();
        Property[] pa = this.getProperties();
        for (int i2 = 0; i2 < pa.length; ++i2) {
            hashCode += (long)pa[i2].hashCode();
        }
        int returnHashCode = (int)(hashCode & 0xFFFFFFFFL);
        return returnHashCode;
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        Property[] pa = this.getProperties();
        b2.append(this.getClass().getName());
        b2.append('[');
        b2.append("formatID: ");
        b2.append(this.getFormatID());
        b2.append(", offset: ");
        b2.append(this.getOffset());
        b2.append(", propertyCount: ");
        b2.append(this.getPropertyCount());
        b2.append(", size: ");
        b2.append(this.getSize());
        b2.append(", properties: [\n");
        for (int i2 = 0; i2 < pa.length; ++i2) {
            b2.append(pa[i2].toString());
            b2.append(",\n");
        }
        b2.append(']');
        b2.append(']');
        return b2.toString();
    }

    public Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    public int getCodepage() {
        Integer codepage = (Integer)this.getProperty(1L);
        if (codepage == null) {
            return -1;
        }
        int cp = codepage;
        return cp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyListEntry
    implements Comparable<PropertyListEntry> {
        int id;
        int offset;
        int length;

        PropertyListEntry() {
        }

        @Override
        public int compareTo(PropertyListEntry o2) {
            int otherOffset = o2.offset;
            if (this.offset < otherOffset) {
                return -1;
            }
            if (this.offset == otherOffset) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            StringBuffer b2 = new StringBuffer();
            b2.append(this.getClass().getName());
            b2.append("[id=");
            b2.append(this.id);
            b2.append(", offset=");
            b2.append(this.offset);
            b2.append(", length=");
            b2.append(this.length);
            b2.append(']');
            return b2.toString();
        }
    }
}

