/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.poi.POIDocument;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.model.DrawingManager2;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.RecalcIdRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.SheetNameFormatter;
import org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFWorkbook
extends POIDocument
implements Workbook {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int MAX_STYLES = 4030;
    private static final int DEBUG = 1;
    public static final int INITIAL_CAPACITY = 3;
    private InternalWorkbook workbook;
    protected List<HSSFSheet> _sheets;
    private ArrayList<HSSFName> names;
    private Hashtable fonts;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private Row.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    private static POILogger log = POILogFactory.getLogger(HSSFWorkbook.class);
    private UDFFinder _udfFinder = UDFFinder.DEFAULT;
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};

    public static HSSFWorkbook create(InternalWorkbook book) {
        return new HSSFWorkbook(book);
    }

    public HSSFWorkbook() {
        this(InternalWorkbook.createWorkbook());
    }

    private HSSFWorkbook(InternalWorkbook book) {
        super((DirectoryNode)null);
        this.workbook = book;
        this._sheets = new ArrayList<HSSFSheet>(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this(fs, true);
    }

    public HSSFWorkbook(POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(fs.getRoot(), fs, preserveNodes);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directory) {
        String[] potentialNames = WORKBOOK_DIR_ENTRY_NAMES;
        for (int i2 = 0; i2 < potentialNames.length; ++i2) {
            String wbName = potentialNames[i2];
            try {
                directory.getEntry(wbName);
                return wbName;
            }
            catch (FileNotFoundException e2) {
                continue;
            }
        }
        try {
            directory.getEntry("Book");
            throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directory, POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(directory, preserveNodes);
    }

    public HSSFWorkbook(DirectoryNode directory, boolean preserveNodes) throws IOException {
        super(directory);
        String workbookName = HSSFWorkbook.getWorkbookDirEntryName(directory);
        this.preserveNodes = preserveNodes;
        if (!preserveNodes) {
            this.directory = null;
        }
        this._sheets = new ArrayList<HSSFSheet>(3);
        this.names = new ArrayList(3);
        DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
        List<Record> records = RecordFactory.createRecords(stream);
        this.workbook = InternalWorkbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int recOffset = this.workbook.getNumRecords();
        boolean sheetNum = false;
        this.convertLabelRecords(records, recOffset);
        RecordStream rs = new RecordStream(records, recOffset);
        while (rs.hasNext()) {
            InternalSheet sheet = InternalSheet.createSheet(rs);
            this._sheets.add(new HSSFSheet(this, sheet));
        }
        for (int i2 = 0; i2 < this.workbook.getNumNames(); ++i2) {
            NameRecord nameRecord = this.workbook.getNameRecord(i2);
            HSSFName name = new HSSFName(this, nameRecord, this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(name);
        }
    }

    public HSSFWorkbook(InputStream s2) throws IOException {
        this(s2, true);
    }

    public HSSFWorkbook(InputStream s2, boolean preserveNodes) throws IOException {
        this(new POIFSFileSystem(s2), preserveNodes);
    }

    private void setPropertiesFromWorkbook(InternalWorkbook book) {
        this.workbook = book;
    }

    private void convertLabelRecords(List records, int offset) {
        if (log.check(1)) {
            log.log(1, "convertLabelRecords called");
        }
        for (int k2 = offset; k2 < records.size(); ++k2) {
            Record rec = (Record)records.get(k2);
            if (rec.getSid() != 516) continue;
            LabelRecord oldrec = (LabelRecord)rec;
            records.remove(k2);
            LabelSSTRecord newrec = new LabelSSTRecord();
            int stringid = this.workbook.addSSTString(new UnicodeString(oldrec.getValue()));
            newrec.setRow(oldrec.getRow());
            newrec.setColumn(oldrec.getColumn());
            newrec.setXFIndex(oldrec.getXFIndex());
            newrec.setSSTIndex(stringid);
            records.add(k2, newrec);
        }
        if (log.check(1)) {
            log.log(1, "convertLabelRecords exit");
        }
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    @Override
    public void setSheetOrder(String sheetname, int pos) {
        int oldSheetIndex = this.getSheetIndex(sheetname);
        this._sheets.add(pos, this._sheets.remove(oldSheetIndex));
        this.workbook.setSheetOrder(sheetname, pos);
        FormulaShifter shifter = FormulaShifter.createForSheetShift(oldSheetIndex, pos);
        for (HSSFSheet sheet : this._sheets) {
            sheet.getSheet().updateFormulasAfterCellShift(shifter, -1);
        }
        this.workbook.updateNamesAfterCellShift(shifter);
    }

    private void validateSheetIndex(int index) {
        int lastSheetIx = this._sheets.size() - 1;
        if (index < 0 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range (0.." + lastSheetIx + ")");
        }
    }

    @Override
    public void setSelectedTab(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i2 = 0; i2 < nSheets; ++i2) {
            this.getSheetAt(i2).setSelected(i2 == index);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    public void setSelectedTab(short index) {
        this.setSelectedTab((int)index);
    }

    public void setSelectedTabs(int[] indexes) {
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            this.validateSheetIndex(indexes[i2]);
        }
        int nSheets = this._sheets.size();
        for (int i3 = 0; i3 < nSheets; ++i3) {
            boolean bSelect = false;
            for (int j2 = 0; j2 < indexes.length; ++j2) {
                if (indexes[j2] != i3) continue;
                bSelect = true;
                break;
            }
            this.getSheetAt(i3).setSelected(bSelect);
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)indexes.length);
    }

    @Override
    public void setActiveSheet(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        for (int i2 = 0; i2 < nSheets; ++i2) {
            this.getSheetAt(i2).setActive(i2 == index);
        }
        this.workbook.getWindowOne().setActiveSheetIndex(index);
    }

    @Override
    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    @Override
    public void setFirstVisibleTab(int index) {
        this.workbook.getWindowOne().setFirstVisibleTab(index);
    }

    public void setDisplayedTab(short index) {
        this.setFirstVisibleTab(index);
    }

    @Override
    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    @Override
    public void setSheetName(int sheetIx, String name) {
        if (name == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(name, sheetIx)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetName(sheetIx, name);
    }

    @Override
    public String getSheetName(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        return this.workbook.getSheetName(sheetIndex);
    }

    @Override
    public boolean isHidden() {
        return this.workbook.getWindowOne().getHidden();
    }

    @Override
    public void setHidden(boolean hiddenFlag) {
        this.workbook.getWindowOne().setHidden(hiddenFlag);
    }

    @Override
    public boolean isSheetHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetHidden(sheetIx);
    }

    @Override
    public boolean isSheetVeryHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetVeryHidden(sheetIx);
    }

    @Override
    public void setSheetHidden(int sheetIx, boolean hidden) {
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public void setSheetHidden(int sheetIx, int hidden) {
        this.validateSheetIndex(sheetIx);
        WorkbookUtil.validateSheetState(hidden);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    @Override
    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        for (int i2 = 0; i2 < this._sheets.size(); ++i2) {
            if (this._sheets.get(i2) != sheet) continue;
            return i2;
        }
        return -1;
    }

    public int getExternalSheetIndex(int internalSheetIndex) {
        return this.workbook.checkExternSheet(internalSheetIndex);
    }

    public String findSheetNameFromExternSheet(int externSheetIndex) {
        return this.workbook.findSheetNameFromExternSheet(externSheetIndex);
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        return this.workbook.resolveNameXText(refIndex, definedNameIndex);
    }

    @Override
    public HSSFSheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this);
        this._sheets.add(sheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    @Override
    public HSSFSheet cloneSheet(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        HSSFSheet srcSheet = this._sheets.get(sheetIndex);
        String srcName = this.workbook.getSheetName(sheetIndex);
        HSSFSheet clonedSheet = srcSheet.cloneSheet(this);
        clonedSheet.setSelected(false);
        clonedSheet.setActive(false);
        String name = this.getUniqueSheetName(srcName);
        int newSheetIndex = this._sheets.size();
        this._sheets.add(clonedSheet);
        this.workbook.setSheetName(newSheetIndex, name);
        int filterDbNameIndex = this.findExistingBuiltinNameRecordIdx(sheetIndex, (byte)13);
        if (filterDbNameIndex != -1) {
            NameRecord newNameRecord = this.workbook.cloneFilter(filterDbNameIndex, newSheetIndex);
            HSSFName newName = new HSSFName(this, newNameRecord);
            this.names.add(newName);
        }
        return clonedSheet;
    }

    private String getUniqueSheetName(String srcName) {
        String index;
        String name;
        int uniqueIndex = 2;
        String baseName = srcName;
        int bracketPos = srcName.lastIndexOf(40);
        if (bracketPos > 0 && srcName.endsWith(")")) {
            String suffix = srcName.substring(bracketPos + 1, srcName.length() - ")".length());
            try {
                uniqueIndex = Integer.parseInt(suffix.trim());
                baseName = srcName.substring(0, bracketPos).trim();
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        do {
            int n2 = ++uniqueIndex;
            ++uniqueIndex;
            index = Integer.toString(n2);
        } while (this.workbook.getSheetIndex(name = baseName.length() + index.length() + 2 < 31 ? baseName + " (" + index + ")" : baseName.substring(0, 31 - index.length() - 2) + "(" + index + ")") != -1);
        return name;
    }

    @Override
    public HSSFSheet createSheet(String sheetname) {
        if (sheetname == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(sheetname, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet sheet = new HSSFSheet(this);
        this.workbook.setSheetName(this._sheets.size(), sheetname);
        this._sheets.add(sheet);
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    @Override
    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        return this.workbook.getSheetIndexFromExternSheetIndex(externSheetNumber);
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] result = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(result);
        return result;
    }

    @Override
    public HSSFSheet getSheetAt(int index) {
        this.validateSheetIndex(index);
        return this._sheets.get(index);
    }

    @Override
    public HSSFSheet getSheet(String name) {
        HSSFSheet retval = null;
        for (int k2 = 0; k2 < this._sheets.size(); ++k2) {
            String sheetname = this.workbook.getSheetName(k2);
            if (!sheetname.equalsIgnoreCase(name)) continue;
            retval = this._sheets.get(k2);
        }
        return retval;
    }

    @Override
    public void removeSheetAt(int index) {
        this.validateSheetIndex(index);
        boolean wasActive = this.getSheetAt(index).isActive();
        boolean wasSelected = this.getSheetAt(index).isSelected();
        this._sheets.remove(index);
        this.workbook.removeSheet(index);
        int nSheets = this._sheets.size();
        if (nSheets < 1) {
            return;
        }
        int newSheetIndex = index;
        if (newSheetIndex >= nSheets) {
            newSheetIndex = nSheets - 1;
        }
        if (wasActive) {
            this.setActiveSheet(newSheetIndex);
        }
        if (wasSelected) {
            boolean someOtherSheetIsStillSelected = false;
            for (int i2 = 0; i2 < nSheets; ++i2) {
                if (!this.getSheetAt(i2).isSelected()) continue;
                someOtherSheetIsStillSelected = true;
                break;
            }
            if (!someOtherSheetIsStillSelected) {
                this.setSelectedTab(newSheetIndex);
            }
        }
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(backupValue ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    @Override
    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        HSSFSheet sheet = this.getSheetAt(sheetIndex);
        CellRangeAddress rows = null;
        CellRangeAddress cols = null;
        if (startRow != -1) {
            rows = new CellRangeAddress(startRow, endRow, -1, -1);
        }
        if (startColumn != -1) {
            cols = new CellRangeAddress(-1, -1, startColumn, endColumn);
        }
        sheet.setRepeatingRows(rows);
        sheet.setRepeatingColumns(cols);
    }

    int findExistingBuiltinNameRecordIdx(int sheetIndex, byte builtinCode) {
        for (int defNameIndex = 0; defNameIndex < this.names.size(); ++defNameIndex) {
            NameRecord r2 = this.workbook.getNameRecord(defNameIndex);
            if (r2 == null) {
                throw new RuntimeException("Unable to find all defined names to iterate over");
            }
            if (!r2.isBuiltInName() || r2.getBuiltInName() != builtinCode || r2.getSheetNumber() - 1 != sheetIndex) continue;
            return defNameIndex;
        }
        return -1;
    }

    HSSFName createBuiltInName(byte builtinCode, int sheetIndex) {
        NameRecord nameRecord = this.workbook.createBuiltInName(builtinCode, sheetIndex + 1);
        HSSFName newName = new HSSFName(this, nameRecord, null);
        this.names.add(newName);
        return newName;
    }

    HSSFName getBuiltInName(byte builtinCode, int sheetIndex) {
        int index = this.findExistingBuiltinNameRecordIdx(sheetIndex, builtinCode);
        if (index < 0) {
            return null;
        }
        return this.names.get(index);
    }

    @Override
    public HSSFFont createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        if (fontindex == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        return this.getFontAt(fontindex);
    }

    @Override
    public HSSFFont findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        for (short i2 = 0; i2 <= this.getNumberOfFonts(); i2 = (short)(i2 + 1)) {
            HSSFFont hssfFont;
            if (i2 == 4 || (hssfFont = this.getFontAt(i2)).getBoldweight() != boldWeight || hssfFont.getColor() != color || hssfFont.getFontHeight() != fontHeight || !hssfFont.getFontName().equals(name) || hssfFont.getItalic() != italic || hssfFont.getStrikeout() != strikeout || hssfFont.getTypeOffset() != typeOffset || hssfFont.getUnderline() != underline) continue;
            return hssfFont;
        }
        return null;
    }

    @Override
    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    @Override
    public HSSFFont getFontAt(short idx) {
        Short sIdx;
        if (this.fonts == null) {
            this.fonts = new Hashtable();
        }
        if (this.fonts.containsKey(sIdx = Short.valueOf(idx))) {
            return (HSSFFont)this.fonts.get(sIdx);
        }
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        this.fonts.put(sIdx, retval);
        return retval;
    }

    protected void resetFontCache() {
        this.fonts = new Hashtable();
    }

    @Override
    public HSSFCellStyle createCellStyle() {
        if (this.workbook.getNumExFormats() == 4030) {
            throw new IllegalStateException("The maximum number of cell styles was exceeded. You can define up to 4000 styles in a .xls workbook");
        }
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr, this);
        return style;
    }

    @Override
    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    @Override
    public HSSFCellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr, this);
        return style;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        ArrayList<String> excepts = new ArrayList<String>(1);
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        this.writeProperties(fs, excepts);
        if (this.preserveNodes) {
            excepts.add("Workbook");
            excepts.add("WORKBOOK");
            this.copyNodes(this.directory, fs.getRoot(), excepts);
            fs.getRoot().setStorageClsid(this.directory.getStorageClsid());
        }
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        if (log.check(1)) {
            log.log(1, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] sheets = this.getSheets();
        int nSheets = sheets.length;
        this.workbook.preSerialize();
        for (int i2 = 0; i2 < nSheets; ++i2) {
            sheets[i2].getSheet().preSerialize();
            sheets[i2].preSerialize();
        }
        int totalsize = this.workbook.getSize();
        SheetRecordCollector[] srCollectors = new SheetRecordCollector[nSheets];
        for (int k2 = 0; k2 < nSheets; ++k2) {
            this.workbook.setSheetBof(k2, totalsize);
            SheetRecordCollector src = new SheetRecordCollector();
            sheets[k2].getSheet().visitContainedRecords(src, totalsize);
            totalsize += src.getTotalSize();
            srCollectors[k2] = src;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        for (int k3 = 0; k3 < nSheets; ++k3) {
            SheetRecordCollector src = srCollectors[k3];
            int serializedSize = src.serialize(pos, retval);
            if (serializedSize != src.getTotalSize()) {
                throw new IllegalStateException("Actual serialized sheet size (" + serializedSize + ") differs from pre-calculated size (" + src.getTotalSize() + ") for sheet (" + k3 + ")");
            }
            pos += serializedSize;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index).getString();
    }

    InternalWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    @Override
    public HSSFName getName(String name) {
        int nameIndex = this.getNameIndex(name);
        if (nameIndex < 0) {
            return null;
        }
        return this.names.get(nameIndex);
    }

    @Override
    public HSSFName getNameAt(int nameIndex) {
        int nNames = this.names.size();
        if (nNames < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (nameIndex < 0 || nameIndex > nNames) {
            throw new IllegalArgumentException("Specified name index " + nameIndex + " is outside the allowable range (0.." + (nNames - 1) + ").");
        }
        return this.names.get(nameIndex);
    }

    public NameRecord getNameRecord(int nameIndex) {
        return this.getWorkbook().getNameRecord(nameIndex);
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    @Override
    public void setPrintArea(int sheetIndex, String reference) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            name = this.workbook.createBuiltInName((byte)6, sheetIndex + 1);
        }
        String[] parts = COMMA_PATTERN.split(reference);
        StringBuffer sb = new StringBuffer(32);
        for (int i2 = 0; i2 < parts.length; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            SheetNameFormatter.appendFormat(sb, this.getSheetName(sheetIndex));
            sb.append("!");
            sb.append(parts[i2]);
        }
        name.setNameDefinition(HSSFFormulaParser.parse(sb.toString(), this, 4, sheetIndex));
    }

    @Override
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        CellReference cell = new CellReference(startRow, startColumn, true, true);
        String reference = cell.formatAsString();
        cell = new CellReference(endRow, endColumn, true, true);
        reference = reference + ":" + cell.formatAsString();
        this.setPrintArea(sheetIndex, reference);
    }

    @Override
    public String getPrintArea(int sheetIndex) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this, name.getNameDefinition());
    }

    @Override
    public void removePrintArea(int sheetIndex) {
        this.getWorkbook().removeBuiltinRecord((byte)6, sheetIndex + 1);
    }

    @Override
    public HSSFName createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName newName = new HSSFName(this, nameRecord);
        this.names.add(newName);
        return newName;
    }

    @Override
    public int getNameIndex(String name) {
        for (int k2 = 0; k2 < this.names.size(); ++k2) {
            String nameName = this.getNameName(k2);
            if (!nameName.equalsIgnoreCase(name)) continue;
            return k2;
        }
        return -1;
    }

    int getNameIndex(HSSFName name) {
        for (int k2 = 0; k2 < this.names.size(); ++k2) {
            if (name != this.names.get(k2)) continue;
            return k2;
        }
        return -1;
    }

    @Override
    public void removeName(int index) {
        this.names.remove(index);
        this.workbook.removeName(index);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    @Override
    public void removeName(String name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    void removeName(HSSFName name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int loc = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] data = new byte[]{15, 0, 0, -16, 82, 0, 0, 0, 0, 0, 6, -16, 24, 0, 0, 0, 1, 8, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0, 0, 51, 0, 11, -16, 18, 0, 0, 0, -65, 0, 8, 0, 8, 0, -127, 1, 9, 0, 0, 8, -64, 1, 64, 0, 0, 8, 64, 0, 30, -15, 16, 0, 0, 0, 13, 0, 0, 8, 12, 0, 0, 8, 23, 0, 0, 8, -9, 0, 0, 16};
        UnknownRecord r2 = new UnknownRecord(235, data);
        this.workbook.getRecords().add(loc, r2);
    }

    public void dumpDrawingGroupRecords(boolean fat) {
        DrawingGroupRecord r2 = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        r2.decode();
        List<EscherRecord> escherRecords = r2.getEscherRecords();
        PrintWriter w2 = new PrintWriter(System.out);
        for (EscherRecord escherRecord : escherRecords) {
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w2, 0);
        }
        w2.flush();
    }

    void initDrawings() {
        DrawingManager2 mgr = this.workbook.findDrawingGroup();
        if (mgr != null) {
            for (int i2 = 0; i2 < this.getNumberOfSheets(); ++i2) {
                this.getSheetAt(i2).getDrawingPatriarch();
            }
        } else {
            this.workbook.createDrawingGroup();
        }
    }

    @Override
    public int addPicture(byte[] pictureData, int format) {
        this.initDrawings();
        byte[] uid = DigestUtils.md5((byte[])pictureData);
        EscherBitmapBlip blipRecord = new EscherBitmapBlip();
        blipRecord.setRecordId((short)(-4072 + format));
        switch (format) {
            case 2: {
                blipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                blipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                blipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                blipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                blipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                blipRecord.setOptions((short)31360);
            }
        }
        blipRecord.setUID(uid);
        blipRecord.setMarker((byte)-1);
        blipRecord.setPictureData(pictureData);
        EscherBSERecord r2 = new EscherBSERecord();
        r2.setRecordId((short)-4089);
        r2.setOptions((short)(2 | format << 4));
        r2.setBlipTypeMacOS((byte)format);
        r2.setBlipTypeWin32((byte)format);
        r2.setUid(uid);
        r2.setTag((short)255);
        r2.setSize(pictureData.length + 25);
        r2.setRef(0);
        r2.setOffset(0);
        r2.setBlipRecord(blipRecord);
        return this.workbook.addBSERecord(r2);
    }

    public List<HSSFPictureData> getAllPictures() {
        ArrayList<HSSFPictureData> pictures = new ArrayList<HSSFPictureData>();
        for (Record r2 : this.workbook.getRecords()) {
            if (!(r2 instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)r2).decode();
            List<EscherRecord> escherRecords = ((AbstractEscherHolderRecord)r2).getEscherRecords();
            this.searchForPictures(escherRecords, pictures);
        }
        return pictures;
    }

    private void searchForPictures(List<EscherRecord> escherRecords, List<HSSFPictureData> pictures) {
        for (EscherRecord escherRecord : escherRecords) {
            EscherBlipRecord blip;
            if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                HSSFPictureData picture = new HSSFPictureData(blip);
                pictures.add(picture);
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String password, String username) {
        this.workbook.writeProtectWorkbook(password, username);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List<HSSFObjectData> getAllEmbeddedObjects() {
        ArrayList<HSSFObjectData> objects = new ArrayList<HSSFObjectData>();
        for (int i2 = 0; i2 < this.getNumberOfSheets(); ++i2) {
            this.getAllEmbeddedObjects(this.getSheetAt(i2), objects);
        }
        return objects;
    }

    private void getAllEmbeddedObjects(HSSFSheet sheet, List<HSSFObjectData> objects) {
        HSSFPatriarch patriarch = sheet.getDrawingPatriarch();
        if (null == patriarch) {
            return;
        }
        for (HSSFShape shape : patriarch.getChildren()) {
            if (!(shape instanceof HSSFObjectData)) continue;
            objects.add((HSSFObjectData)shape);
        }
    }

    @Override
    public HSSFCreationHelper getCreationHelper() {
        return new HSSFCreationHelper(this);
    }

    UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    @Override
    public void addToolPack(UDFFinder toopack) {
        AggregatingUDFFinder udfs = (AggregatingUDFFinder)this._udfFinder;
        udfs.add(toopack);
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        InternalWorkbook iwb = this.getWorkbook();
        RecalcIdRecord recalc = iwb.getRecalcId();
        recalc.setEngineId(0);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        InternalWorkbook iwb = this.getWorkbook();
        RecalcIdRecord recalc = (RecalcIdRecord)iwb.findFirstRecordBySid((short)449);
        return recalc != null && recalc.getEngineId() != 0;
    }

    public boolean changeExternalReference(String oldUrl, String newUrl) {
        return this.workbook.changeExternalReference(oldUrl, newUrl);
    }

    public DirectoryNode getRootDirectory() {
        return this.directory;
    }

    private static final class SheetRecordCollector
    implements RecordAggregate.RecordVisitor {
        private List _list = new ArrayList(128);
        private int _totalSize = 0;

        public int getTotalSize() {
            return this._totalSize;
        }

        public void visitRecord(Record r2) {
            this._list.add(r2);
            this._totalSize += r2.getRecordSize();
        }

        public int serialize(int offset, byte[] data) {
            int result = 0;
            int nRecs = this._list.size();
            for (int i2 = 0; i2 < nRecs; ++i2) {
                Record rec = (Record)this._list.get(i2);
                result += rec.serialize(offset + result, data);
            }
            return result;
        }
    }
}

