/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionVerifier {
    private final byte[] salt;
    private final byte[] verifier;
    private final byte[] verifierHash;
    private final byte[] encryptedKey;
    private final int verifierHashSize;
    private final int spinCount;
    private final int algorithm;
    private final int cipherMode;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EncryptionVerifier(String descriptor) {
        NamedNodeMap keyData = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(descriptor.getBytes());
            NodeList keyEncryptor = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is).getElementsByTagName("keyEncryptor").item(0).getChildNodes();
            for (int i2 = 0; i2 < keyEncryptor.getLength(); ++i2) {
                Node node = keyEncryptor.item(i2);
                if (!node.getNodeName().equals("p:encryptedKey")) continue;
                keyData = node.getAttributes();
                break;
            }
            if (keyData == null) {
                throw new EncryptedDocumentException("");
            }
        }
        catch (Exception e2) {
            throw new EncryptedDocumentException("Unable to parse keyEncryptor");
        }
        this.spinCount = Integer.parseInt(keyData.getNamedItem("spinCount").getNodeValue());
        this.verifier = Base64.decodeBase64((byte[])keyData.getNamedItem("encryptedVerifierHashInput").getNodeValue().getBytes());
        this.salt = Base64.decodeBase64((byte[])keyData.getNamedItem("saltValue").getNodeValue().getBytes());
        this.encryptedKey = Base64.decodeBase64((byte[])keyData.getNamedItem("encryptedKeyValue").getNodeValue().getBytes());
        int saltSize = Integer.parseInt(keyData.getNamedItem("saltSize").getNodeValue());
        if (saltSize != this.salt.length) {
            throw new EncryptedDocumentException("Invalid salt size");
        }
        this.verifierHash = Base64.decodeBase64((byte[])keyData.getNamedItem("encryptedVerifierHashValue").getNodeValue().getBytes());
        int blockSize = Integer.parseInt(keyData.getNamedItem("blockSize").getNodeValue());
        String alg = keyData.getNamedItem("cipherAlgorithm").getNodeValue();
        if (!"AES".equals(alg)) throw new EncryptedDocumentException("Unsupported cipher");
        if (blockSize == 16) {
            this.algorithm = 26126;
        } else if (blockSize == 24) {
            this.algorithm = 26127;
        } else {
            if (blockSize != 32) throw new EncryptedDocumentException("Unsupported block size");
            this.algorithm = 26128;
        }
        String chain = keyData.getNamedItem("cipherChaining").getNodeValue();
        if ("ChainingModeCBC".equals(chain)) {
            this.cipherMode = 2;
        } else {
            if (!"ChainingModeCFB".equals(chain)) throw new EncryptedDocumentException("Unsupported chaining mode");
            this.cipherMode = 3;
        }
        this.verifierHashSize = Integer.parseInt(keyData.getNamedItem("hashSize").getNodeValue());
    }

    public EncryptionVerifier(DocumentInputStream is, int encryptedLength) {
        int saltSize = is.readInt();
        if (saltSize != 16) {
            throw new RuntimeException("Salt size != 16 !?");
        }
        this.salt = new byte[16];
        is.readFully(this.salt);
        this.verifier = new byte[16];
        is.readFully(this.verifier);
        this.verifierHashSize = is.readInt();
        this.verifierHash = new byte[encryptedLength];
        is.readFully(this.verifierHash);
        this.spinCount = 50000;
        this.algorithm = 26126;
        this.cipherMode = 1;
        this.encryptedKey = null;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getVerifier() {
        return this.verifier;
    }

    public byte[] getVerifierHash() {
        return this.verifierHash;
    }

    public int getSpinCount() {
        return this.spinCount;
    }

    public int getCipherMode() {
        return this.cipherMode;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }
}

