/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.poi.xslf.model.geom.CustomGeometry;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresetGeometries
extends LinkedHashMap<String, CustomGeometry> {
    private static PresetGeometries _inst;

    private PresetGeometries() {
        try {
            InputStream is = XMLSlideShow.class.getResourceAsStream("presetShapeDefinitions.xml");
            this.read(is);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void read(InputStream is) throws Exception {
        XmlObject obj = XmlObject.Factory.parse(is);
        for (XmlObject def : obj.selectPath("*/*")) {
            String name = def.getDomNode().getLocalName();
            CTCustomGeometry2D geom = CTCustomGeometry2D.Factory.parse(((Object)def).toString());
            if (this.containsKey(name)) {
                System.out.println("Duplicate definoition of " + name);
            }
            this.put(name, new CustomGeometry(geom));
        }
    }

    public static PresetGeometries getInstance() {
        if (_inst == null) {
            _inst = new PresetGeometries();
        }
        return _inst;
    }
}

