/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;

class TextFragment {
    final TextLayout _layout;
    final AttributedString _str;

    TextFragment(TextLayout layout, AttributedString str) {
        this._layout = layout;
        this._str = str;
    }

    void draw(Graphics2D graphics, double x2, double y) {
        if (this._str == null) {
            return;
        }
        double yBaseline = y + (double)this._layout.getAscent();
        Integer textMode = (Integer)graphics.getRenderingHint(XSLFRenderingHint.TEXT_RENDERING_MODE);
        if (textMode != null && textMode == 2) {
            this._layout.draw(graphics, (float)x2, (float)yBaseline);
        } else {
            graphics.drawString(this._str.getIterator(), (float)x2, (float)yBaseline);
        }
    }

    public float getHeight() {
        double h2 = Math.ceil(this._layout.getAscent()) + Math.ceil(this._layout.getDescent()) + (double)this._layout.getLeading();
        return (float)h2;
    }

    public float getWidth() {
        return this._layout.getAdvance();
    }

    public String getString() {
        if (this._str == null) {
            return "";
        }
        AttributedCharacterIterator it = this._str.getIterator();
        StringBuffer buf = new StringBuffer();
        char c2 = it.first();
        while (true) {
            if (c2 == '\uffff') break;
            buf.append(c2);
            c2 = it.next();
        }
        return buf.toString();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getString();
    }
}

