/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import org.apache.poi.xslf.usermodel.XSLFDrawing;
import org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLFSheet
extends POIXMLDocumentPart
implements XSLFShapeContainer {
    private XSLFCommonSlideData _commonSlideData;
    private XSLFDrawing _drawing;
    private List<XSLFShape> _shapes;
    private CTGroupShape _spTree;
    private List<XSLFTextShape> _placeholders;
    private Map<Integer, XSLFSimpleShape> _placeholderByIdMap;
    private Map<Integer, XSLFSimpleShape> _placeholderByTypeMap;

    public XSLFSheet() {
    }

    public XSLFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public XMLSlideShow getSlideShow() {
        for (POIXMLDocumentPart p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (!(p2 instanceof XMLSlideShow)) continue;
            return (XMLSlideShow)p2;
        }
        throw new IllegalStateException("SlideShow was not found");
    }

    protected List<XSLFShape> buildShapes(CTGroupShape spTree) {
        ArrayList<XSLFShape> shapes = new ArrayList<XSLFShape>();
        for (XmlObject ch : spTree.selectPath("*")) {
            XSLFShape shape;
            if (ch instanceof CTShape) {
                shape = XSLFAutoShape.create((CTShape)ch, this);
                shapes.add(shape);
                continue;
            }
            if (ch instanceof CTGroupShape) {
                shapes.add(new XSLFGroupShape((CTGroupShape)ch, this));
                continue;
            }
            if (ch instanceof CTConnector) {
                shapes.add(new XSLFConnectorShape((CTConnector)ch, this));
                continue;
            }
            if (ch instanceof CTPicture) {
                shapes.add(new XSLFPictureShape((CTPicture)ch, this));
                continue;
            }
            if (!(ch instanceof CTGraphicalObjectFrame)) continue;
            shape = XSLFGraphicFrame.create((CTGraphicalObjectFrame)ch, this);
            shapes.add(shape);
        }
        return shapes;
    }

    public abstract XmlObject getXmlObject();

    @Internal
    public XSLFCommonSlideData getCommonSlideData() {
        return this._commonSlideData;
    }

    protected void setCommonSlideData(CTCommonSlideData data) {
        this._commonSlideData = data == null ? null : new XSLFCommonSlideData(data);
    }

    private XSLFDrawing getDrawing() {
        if (this._drawing == null) {
            this._drawing = new XSLFDrawing(this, this.getSpTree());
        }
        return this._drawing;
    }

    private List<XSLFShape> getShapeList() {
        if (this._shapes == null) {
            this._shapes = this.buildShapes(this.getSpTree());
        }
        return this._shapes;
    }

    @Override
    public XSLFAutoShape createAutoShape() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFAutoShape sh = this.getDrawing().createAutoShape();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFFreeformShape createFreeform() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFFreeformShape sh = this.getDrawing().createFreeform();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFTextBox createTextBox() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFTextBox sh = this.getDrawing().createTextBox();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFConnectorShape createConnector() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFConnectorShape sh = this.getDrawing().createConnector();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFGroupShape createGroup() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFGroupShape sh = this.getDrawing().createGroup();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFPictureShape createPicture(int pictureIndex) {
        List<PackagePart> pics = this.getPackagePart().getPackage().getPartsByName(Pattern.compile("/ppt/media/image" + (pictureIndex + 1) + ".*?"));
        if (pics.size() == 0) {
            throw new IllegalArgumentException("Picture with index=" + pictureIndex + " was not found");
        }
        PackagePart pic = pics.get(0);
        PackageRelationship rel = this.getPackagePart().addRelationship(pic.getPartName(), TargetMode.INTERNAL, XSLFRelation.IMAGES.getRelation());
        this.addRelation(rel.getId(), new XSLFPictureData(pic, rel));
        XSLFPictureShape sh = this.getDrawing().createPicture(rel.getId());
        sh.resize();
        this.getShapeList().add(sh);
        return sh;
    }

    public XSLFTable createTable() {
        List<XSLFShape> shapes = this.getShapeList();
        XSLFTable sh = this.getDrawing().createTable();
        shapes.add(sh);
        return sh;
    }

    @Override
    public XSLFShape[] getShapes() {
        return this.getShapeList().toArray(new XSLFShape[this._shapes.size()]);
    }

    @Override
    public Iterator<XSLFShape> iterator() {
        return this.getShapeList().iterator();
    }

    @Override
    public boolean removeShape(XSLFShape xShape) {
        XmlObject obj = xShape.getXmlObject();
        CTGroupShape spTree = this.getSpTree();
        if (obj instanceof CTShape) {
            spTree.getSpList().remove(obj);
        } else if (obj instanceof CTGroupShape) {
            spTree.getGrpSpList().remove(obj);
        } else if (obj instanceof CTConnector) {
            spTree.getCxnSpList().remove(obj);
        } else {
            throw new IllegalArgumentException("Unsupported shape: " + xShape);
        }
        return this.getShapeList().remove(xShape);
    }

    @Override
    public void clear() {
        for (XSLFShape shape : this.getShapes()) {
            this.removeShape(shape);
        }
    }

    protected abstract String getRootElementName();

    protected CTGroupShape getSpTree() {
        if (this._spTree == null) {
            XmlObject root = this.getXmlObject();
            XmlObject[] sp = root.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:spTree");
            if (sp.length == 0) {
                throw new IllegalStateException("CTGroupShape was not found");
            }
            this._spTree = (CTGroupShape)sp[0];
        }
        return this._spTree;
    }

    @Override
    protected final void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
        map.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        map.put("http://schemas.openxmlformats.org/presentationml/2006/main", "p");
        xmlOptions.setSaveSuggestedPrefixes(map);
        String docName = this.getRootElementName();
        if (docName != null) {
            xmlOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/presentationml/2006/main", docName));
        }
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.getXmlObject().save(out, xmlOptions);
        out.close();
    }

    public XSLFSheet importContent(XSLFSheet src) {
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        this.getSpTree().set(src.getSpTree());
        List<XSLFShape> tgtShapes = this.getShapeList();
        List<XSLFShape> srcShapes = src.getShapeList();
        for (int i2 = 0; i2 < tgtShapes.size(); ++i2) {
            XSLFShape s1 = srcShapes.get(i2);
            XSLFShape s2 = tgtShapes.get(i2);
            s2.copy(s1);
        }
        return this;
    }

    public XSLFSheet appendContent(XSLFSheet src) {
        CTGroupShape spTree = this.getSpTree();
        int numShapes = this.getShapeList().size();
        CTGroupShape srcTree = src.getSpTree();
        for (XmlObject ch : srcTree.selectPath("*")) {
            if (ch instanceof CTShape) {
                spTree.addNewSp().set(ch);
                continue;
            }
            if (ch instanceof CTGroupShape) {
                spTree.addNewGrpSp().set(ch);
                continue;
            }
            if (ch instanceof CTConnector) {
                spTree.addNewCxnSp().set(ch);
                continue;
            }
            if (ch instanceof CTPicture) {
                spTree.addNewPic().set(ch);
                continue;
            }
            if (!(ch instanceof CTGraphicalObjectFrame)) continue;
            spTree.addNewGraphicFrame().set(ch);
        }
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        List<XSLFShape> tgtShapes = this.getShapeList();
        List<XSLFShape> srcShapes = src.getShapeList();
        for (int i2 = 0; i2 < srcShapes.size(); ++i2) {
            XSLFShape s1 = srcShapes.get(i2);
            XSLFShape s2 = tgtShapes.get(numShapes + i2);
            s2.copy(s1);
        }
        return this;
    }

    XSLFTheme getTheme() {
        return null;
    }

    public abstract XSLFSheet getMasterSheet();

    protected XSLFTextShape getTextShapeByType(Placeholder type) {
        for (XSLFShape shape : this.getShapes()) {
            XSLFTextShape txt;
            if (!(shape instanceof XSLFTextShape) || (txt = (XSLFTextShape)shape).getTextType() != type) continue;
            return txt;
        }
        return null;
    }

    XSLFSimpleShape getPlaceholder(CTPlaceholder ph) {
        XSLFSimpleShape shape = null;
        if (ph.isSetIdx()) {
            shape = this.getPlaceholderById((int)ph.getIdx());
        }
        if (shape == null && ph.isSetType()) {
            shape = this.getPlaceholderByType(ph.getType().intValue());
        }
        return shape;
    }

    void initPlaceholders() {
        if (this._placeholders == null) {
            this._placeholders = new ArrayList<XSLFTextShape>();
            this._placeholderByIdMap = new HashMap<Integer, XSLFSimpleShape>();
            this._placeholderByTypeMap = new HashMap<Integer, XSLFSimpleShape>();
            for (XSLFShape sh : this.getShapes()) {
                XSLFTextShape sShape;
                CTPlaceholder ph;
                if (!(sh instanceof XSLFTextShape) || (ph = (sShape = (XSLFTextShape)sh).getCTPlaceholder()) == null) continue;
                this._placeholders.add(sShape);
                if (ph.isSetIdx()) {
                    int idx = (int)ph.getIdx();
                    this._placeholderByIdMap.put(idx, sShape);
                }
                if (!ph.isSetType()) continue;
                this._placeholderByTypeMap.put(ph.getType().intValue(), sShape);
            }
        }
    }

    XSLFSimpleShape getPlaceholderById(int id) {
        this.initPlaceholders();
        return this._placeholderByIdMap.get(id);
    }

    XSLFSimpleShape getPlaceholderByType(int ordinal) {
        this.initPlaceholders();
        return this._placeholderByTypeMap.get(ordinal);
    }

    public XSLFTextShape getPlaceholder(int idx) {
        this.initPlaceholders();
        return this._placeholders.get(idx);
    }

    public XSLFTextShape[] getPlaceholders() {
        this.initPlaceholders();
        return this._placeholders.toArray(new XSLFTextShape[this._placeholders.size()]);
    }

    protected boolean canDraw(XSLFShape shape) {
        return true;
    }

    public boolean getFollowMasterGraphics() {
        return false;
    }

    public XSLFBackground getBackground() {
        return null;
    }

    public void draw(Graphics2D graphics) {
        XSLFSheet master = this.getMasterSheet();
        if (this.getFollowMasterGraphics() && master != null) {
            master.draw(graphics);
        }
        graphics.setRenderingHint(XSLFRenderingHint.GROUP_TRANSFORM, new AffineTransform());
        for (XSLFShape shape : this.getShapeList()) {
            if (!this.canDraw(shape)) continue;
            AffineTransform at = graphics.getTransform();
            graphics.setRenderingHint(XSLFRenderingHint.GSAVE, true);
            shape.applyTransform(graphics);
            shape.draw(graphics);
            graphics.setTransform(at);
            graphics.setRenderingHint(XSLFRenderingHint.GRESTORE, true);
        }
    }

    String importBlip(String blipId, PackagePart packagePart) {
        PackagePart blipPart;
        PackageRelationship blipRel = packagePart.getRelationship(blipId);
        try {
            blipPart = packagePart.getRelatedPart(blipRel);
        }
        catch (InvalidFormatException e2) {
            throw new POIXMLException(e2);
        }
        XSLFPictureData data = new XSLFPictureData(blipPart, null);
        XMLSlideShow ppt = this.getSlideShow();
        int pictureIdx = ppt.addPicture(data.getData(), data.getPictureType());
        PackagePart pic = ppt.getAllPictures().get(pictureIdx).getPackagePart();
        PackageRelationship rel = this.getPackagePart().addRelationship(pic.getPartName(), TargetMode.INTERNAL, blipRel.getRelationshipType());
        this.addRelation(rel.getId(), new XSLFPictureData(pic, rel));
        return rel.getId();
    }
}

