/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTPictureNonVisual;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;

public final class XSSFPicture
extends XSSFShape
implements Picture {
    private static final POILogger logger = POILogFactory.getLogger(XSSFPicture.class);
    private static float DEFAULT_COLUMN_WIDTH = 9.140625f;
    private static CTPicture prototype = null;
    private CTPicture ctPicture;

    protected XSSFPicture(XSSFDrawing drawing, CTPicture ctPicture) {
        this.drawing = drawing;
        this.ctPicture = ctPicture;
    }

    protected static CTPicture prototype() {
        if (prototype == null) {
            CTPicture pic = CTPicture.Factory.newInstance();
            CTPictureNonVisual nvpr = pic.addNewNvPicPr();
            CTNonVisualDrawingProps nvProps = nvpr.addNewCNvPr();
            nvProps.setId(1L);
            nvProps.setName("Picture 1");
            nvProps.setDescr("Picture");
            CTNonVisualPictureProperties nvPicProps = nvpr.addNewCNvPicPr();
            nvPicProps.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties blip = pic.addNewBlipFill();
            blip.addNewBlip().setEmbed("");
            blip.addNewStretch().addNewFillRect();
            CTShapeProperties sppr = pic.addNewSpPr();
            CTTransform2D t2d = sppr.addNewXfrm();
            CTPositiveSize2D ext = t2d.addNewExt();
            ext.setCx(0L);
            ext.setCy(0L);
            CTPoint2D off = t2d.addNewOff();
            off.setX(0L);
            off.setY(0L);
            CTPresetGeometry2D prstGeom = sppr.addNewPrstGeom();
            prstGeom.setPrst(STShapeType.RECT);
            prstGeom.addNewAvLst();
            prototype = pic;
        }
        return prototype;
    }

    protected void setPictureReference(PackageRelationship rel) {
        this.ctPicture.getBlipFill().getBlip().setEmbed(rel.getId());
    }

    @Internal
    public CTPicture getCTPicture() {
        return this.ctPicture;
    }

    public void resize() {
        this.resize(1.0);
    }

    public void resize(double scale) {
        XSSFClientAnchor anchor = (XSSFClientAnchor)this.getAnchor();
        XSSFClientAnchor pref = this.getPreferredSize(scale);
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2(col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    public XSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public XSSFClientAnchor getPreferredSize(double scale) {
        XSSFClientAnchor anchor = (XSSFClientAnchor)this.getAnchor();
        XSSFPictureData data = this.getPictureData();
        Dimension size = XSSFPicture.getImageDimension(data.getPackagePart(), data.getPictureType());
        double scaledWidth = size.getWidth() * scale;
        double scaledHeight = size.getHeight() * scale;
        float w2 = 0.0f;
        int col2 = anchor.getCol1();
        int dx2 = 0;
        while (!((double)(w2 += this.getColumnWidthInPixels(col2)) > scaledWidth)) {
            ++col2;
        }
        if ((double)w2 > scaledWidth) {
            double cw = this.getColumnWidthInPixels(col2);
            double delta = (double)w2 - scaledWidth;
            dx2 = (int)(9525.0 * (cw - delta));
        }
        anchor.setCol2(col2);
        anchor.setDx2(dx2);
        double h2 = 0.0;
        int row2 = anchor.getRow1();
        int dy2 = 0;
        while (!((h2 += (double)this.getRowHeightInPixels(row2)) > scaledHeight)) {
            ++row2;
        }
        if (h2 > scaledHeight) {
            double ch = this.getRowHeightInPixels(row2);
            double delta = h2 - scaledHeight;
            dy2 = (int)(9525.0 * (ch - delta));
        }
        anchor.setRow2(row2);
        anchor.setDy2(dy2);
        CTPositiveSize2D size2d = this.ctPicture.getSpPr().getXfrm().getExt();
        size2d.setCx((long)(scaledWidth * 9525.0));
        size2d.setCy((long)(scaledHeight * 9525.0));
        return anchor;
    }

    private float getColumnWidthInPixels(int columnIndex) {
        XSSFSheet sheet = (XSSFSheet)this.getDrawing().getParent();
        CTCol col = sheet.getColumnHelper().getColumn(columnIndex, false);
        double numChars = col == null || !col.isSetWidth() ? (double)DEFAULT_COLUMN_WIDTH : col.getWidth();
        return (float)numChars * 7.0017f;
    }

    private float getRowHeightInPixels(int rowIndex) {
        XSSFSheet sheet = (XSSFSheet)this.getDrawing().getParent();
        XSSFRow row = sheet.getRow(rowIndex);
        float height = row != null ? row.getHeightInPoints() : sheet.getDefaultRowHeightInPoints();
        return height * 96.0f / 72.0f;
    }

    protected static Dimension getImageDimension(PackagePart part, int type) {
        try {
            return ImageUtils.getImageDimension(part.getInputStream(), type);
        }
        catch (IOException e2) {
            logger.log(5, e2);
            return new Dimension();
        }
    }

    public XSSFPictureData getPictureData() {
        String blipId = this.ctPicture.getBlipFill().getBlip().getEmbed();
        return (XSSFPictureData)this.getDrawing().getRelationById(blipId);
    }

    protected CTShapeProperties getShapeProperties() {
        return this.ctPicture.getSpPr();
    }
}

