/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentReaderHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected final BarrierLock barrierLock = new BarrierLock();
    protected transient Object lastWrite;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object x2) {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            this.lastWrite = x2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry[] getTableForReading() {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            return this.table;
        }
    }

    private int p2capacity(int initialCapacity) {
        int result;
        int cap = initialCapacity;
        if (cap > 0x40000000 || cap < 0) {
            result = 0x40000000;
        } else {
            for (result = 4; result < cap; result <<= 1) {
            }
        }
        return result;
    }

    private static int hash(Object x2) {
        int h2 = x2.hashCode();
        return (h2 << 7) - h2 + (h2 >>> 9) + (h2 >>> 17);
    }

    protected boolean eq(Object x2, Object y) {
        return x2 == y || x2.equals(y);
    }

    public ConcurrentReaderHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int cap = this.p2capacity(initialCapacity);
        this.table = new Entry[cap];
        this.threshold = (int)((float)cap * loadFactor);
    }

    public ConcurrentReaderHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentReaderHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentReaderHashMap(Map t2) {
        this(Math.max((int)((float)t2.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t2);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Entry first;
        int hash = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (true) {
            if (e2 == null) {
                Entry[] reread = this.getTableForReading();
                if (tab == reread && first == tab[index]) {
                    return null;
                }
                tab = reread;
                index = hash & tab.length - 1;
                e2 = first = tab[index];
                continue;
            }
            if (e2.hash == hash && this.eq(key, e2.key)) {
                Object value = e2.value;
                if (value != null) {
                    return value;
                }
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    tab = this.table;
                }
                index = hash & tab.length - 1;
                e2 = first = tab[index];
                continue;
            }
            e2 = e2.next;
        }
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Entry first;
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (!(e2 == null || e2.hash == hash && this.eq(key, e2.key))) {
            e2 = e2.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (tab == this.table) {
                if (e2 == null) {
                    if (first == tab[index]) {
                        Entry newEntry;
                        tab[index] = newEntry = new Entry(hash, key, value, first);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(newEntry);
                        }
                        return null;
                    }
                } else {
                    Object oldValue = e2.value;
                    if (first == tab[index] && oldValue != null) {
                        e2.value = value;
                        return oldValue;
                    }
                }
            }
            return this.sput(key, value, hash);
        }
    }

    protected Object sput(Object key, Object value, int hash) {
        Entry first;
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (true) {
            if (e2 == null) {
                Entry newEntry;
                tab[index] = newEntry = new Entry(hash, key, value, first);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(newEntry);
                }
                return null;
            }
            if (e2.hash == hash && this.eq(key, e2.key)) {
                Object oldValue = e2.value;
                e2.value = value;
                return oldValue;
            }
            e2 = e2.next;
        }
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newCapacity = oldCapacity << 1;
        int mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        Entry[] newTable = new Entry[newCapacity];
        for (int i2 = 0; i2 < oldCapacity; ++i2) {
            int k2;
            Entry e2 = oldTable[i2];
            if (e2 == null) continue;
            int idx = e2.hash & mask;
            Entry next = e2.next;
            if (next == null) {
                newTable[idx] = e2;
                continue;
            }
            Entry lastRun = e2;
            int lastIdx = idx;
            Entry last = next;
            while (last != null) {
                k2 = last.hash & mask;
                if (k2 != lastIdx) {
                    lastIdx = k2;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            Entry p2 = e2;
            while (p2 != lastRun) {
                k2 = p2.hash & mask;
                newTable[k2] = new Entry(p2.hash, p2.key, p2.value, newTable[k2]);
                p2 = p2.next;
            }
        }
        this.table = newTable;
        this.recordModification(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Entry first;
        int hash = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        e2 = first;
        while (!(e2 == null || e2.hash == hash && this.eq(key, e2.key))) {
            e2 = e2.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (tab == this.table) {
                if (e2 == null) {
                    if (first == tab[index]) {
                        return null;
                    }
                } else {
                    Object oldValue = e2.value;
                    if (first == tab[index] && oldValue != null) {
                        e2.value = null;
                        --this.count;
                        Entry head = e2.next;
                        Entry p2 = first;
                        while (p2 != e2) {
                            head = new Entry(p2.hash, p2.key, p2.value, head);
                            p2 = p2.next;
                        }
                        tab[index] = head;
                        this.recordModification(head);
                        return oldValue;
                    }
                }
            }
            return this.sremove(key, hash);
        }
    }

    protected Object sremove(Object key, int hash) {
        Entry first;
        Entry[] tab = this.table;
        int index = hash & tab.length - 1;
        Entry e2 = first = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && this.eq(key, e2.key)) {
                Object oldValue = e2.value;
                e2.value = null;
                --this.count;
                Entry head = e2.next;
                Entry p2 = first;
                while (p2 != e2) {
                    head = new Entry(p2.hash, p2.key, p2.value, head);
                    p2 = p2.next;
                }
                tab[index] = head;
                this.recordModification(head);
                return oldValue;
            }
            e2 = e2.next;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.getTableForReading();
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (value.equals(e2.value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public synchronized void putAll(Map t2) {
        int n2 = t2.size();
        if (n2 == 0) {
            return;
        }
        while (n2 >= this.threshold) {
            this.rehash();
        }
        Iterator it = t2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        for (int i2 = 0; i2 < tab.length; ++i2) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                e2.value = null;
                e2 = e2.next;
            }
            tab[i2] = null;
        }
        this.count = 0;
        this.recordModification(tab);
    }

    public synchronized Object clone() {
        try {
            ConcurrentReaderHashMap t2 = (ConcurrentReaderHashMap)super.clone();
            t2.keySet = null;
            t2.entrySet = null;
            t2.values = null;
            Entry[] tab = this.table;
            Entry[] ttab = t2.table = new Entry[tab.length];
            for (int i2 = 0; i2 < tab.length; ++i2) {
                Entry first = null;
                Entry e2 = tab[i2];
                while (e2 != null) {
                    first = new Entry(e2.hash, e2.key, e2.value, first);
                    e2 = e2.next;
                }
                ttab[i2] = first;
            }
            return t2;
        }
        catch (CloneNotSupportedException e3) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry) {
        Object key = entry.getKey();
        Object v2 = this.get(key);
        if (v2 != null && v2.equals(entry.getValue())) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                s2.writeObject(entry.key);
                s2.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        int size = s2.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.put(key, value);
        }
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        protected HashIterator() {
            this.tab = ConcurrentReaderHashMap.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object v2 = this.entry.value;
                    if (v2 != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = v2;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return result;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReaderHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final int hash;
        protected final Object key;
        protected final Entry next;
        protected volatile Object value;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key.equals(e2.getKey()) && this.value.equals(e2.getValue());
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new HashIterator();
        }

        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o2;
            Object v2 = ConcurrentReaderHashMap.this.get(entry.getKey());
            return v2 != null && v2.equals(entry.getValue());
        }

        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            return ConcurrentReaderHashMap.this.findAndRemoveEntry((Map.Entry)o2);
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public boolean contains(Object o2) {
            return ConcurrentReaderHashMap.this.containsValue(o2);
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        public boolean contains(Object o2) {
            return ConcurrentReaderHashMap.this.containsKey(o2);
        }

        public boolean remove(Object o2) {
            return ConcurrentReaderHashMap.this.remove(o2) != null;
        }

        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }
    }

    protected static class BarrierLock
    implements Serializable {
        protected BarrierLock() {
        }
    }
}

