/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlFloat;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlLong;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.impl.common.XPath;
import org.apache.xmlbeans.impl.store.Cur;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Locale;
import org.apache.xmlbeans.impl.store.Path;
import org.apache.xmlbeans.impl.store.SaxonXBeansDelegate;
import org.w3c.dom.Node;

public abstract class Query {
    private static HashMap _saxonQueryCache;
    private static HashMap _xqrlQueryCache;
    private static Method _xqrlCompileQuery;
    private static boolean _xqrlAvailable;
    private static HashMap _xqrl2002QueryCache;
    private static Method _xqrl2002CompileQuery;
    private static boolean _xqrl2002Available;
    static final /* synthetic */ boolean $assertionsDisabled;

    abstract XmlObject[] objectExecute(Cur var1, XmlOptions var2);

    abstract XmlCursor cursorExecute(Cur var1, XmlOptions var2);

    static XmlObject[] objectExecQuery(Cur c2, String queryExpr, XmlOptions options) {
        return Query.getCompiledQuery(queryExpr, options).objectExecute(c2, options);
    }

    static XmlCursor cursorExecQuery(Cur c2, String queryExpr, XmlOptions options) {
        return Query.getCompiledQuery(queryExpr, options).cursorExecute(c2, options);
    }

    public static synchronized Query getCompiledQuery(String queryExpr, XmlOptions options) {
        return Query.getCompiledQuery(queryExpr, Path.getCurrentNodeVar(options), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Query getCompiledQuery(String queryExpr, String currentVar, XmlOptions options) {
        if (!$assertionsDisabled && queryExpr == null) {
            throw new AssertionError();
        }
        if (options != null && options.hasOption(Path._forceXqrl2002ForXpathXQuery)) {
            Query res = (Query)_xqrl2002QueryCache.get(queryExpr);
            if (res != null) {
                return res;
            }
            res = Query.getXqrl2002CompiledQuery(queryExpr, currentVar);
            if (res != null) {
                _xqrl2002QueryCache.put(queryExpr, res);
                return res;
            }
            throw new RuntimeException("No 2002 query engine found.");
        }
        HashMap boundary = new HashMap();
        int boundaryVal = 0;
        try {
            try {
                XPath.compileXPath(queryExpr, currentVar, boundary);
            }
            catch (XPath.XPathCompileException e2) {
                Object var7_7 = null;
                boundaryVal = boundary.get("$xmlbeans!ns_boundary") == null ? 0 : (Integer)boundary.get("$xmlbeans!ns_boundary");
            }
            Object var7_6 = null;
            boundaryVal = boundary.get("$xmlbeans!ns_boundary") == null ? 0 : (Integer)boundary.get("$xmlbeans!ns_boundary");
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            boundaryVal = boundary.get("$xmlbeans!ns_boundary") == null ? 0 : (Integer)boundary.get("$xmlbeans!ns_boundary");
            throw throwable;
        }
        Query query = (Query)_xqrlQueryCache.get(queryExpr);
        if (query != null) {
            return query;
        }
        query = Query.createXqrlCompiledQuery(queryExpr, currentVar);
        if (query != null) {
            _xqrlQueryCache.put(queryExpr, query);
            return query;
        }
        query = (Query)_saxonQueryCache.get(queryExpr);
        if (query != null) {
            return query;
        }
        query = SaxonQueryImpl.createSaxonCompiledQuery(queryExpr, currentVar, boundaryVal);
        if (query != null) {
            _saxonQueryCache.put(queryExpr, query);
            return query;
        }
        throw new RuntimeException("No query engine found");
    }

    public static synchronized String compileQuery(String queryExpr, XmlOptions options) {
        Query.getCompiledQuery(queryExpr, options);
        return queryExpr;
    }

    private static Query createXqrlCompiledQuery(String queryExpr, String currentVar) {
        if (!_xqrlAvailable) {
            return null;
        }
        if (_xqrlCompileQuery == null) {
            try {
                Class<?> xqrlImpl = Class.forName("org.apache.xmlbeans.impl.store.XqrlImpl");
                _xqrlCompileQuery = xqrlImpl.getDeclaredMethod("compileQuery", String.class, String.class, Boolean.class);
            }
            catch (ClassNotFoundException e2) {
                _xqrlAvailable = false;
                return null;
            }
            catch (Exception e3) {
                _xqrlAvailable = false;
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        Object[] args = new Object[]{queryExpr, currentVar, new Boolean(true)};
        try {
            return (Query)_xqrlCompileQuery.invoke(null, args);
        }
        catch (InvocationTargetException e4) {
            Throwable t2 = e4.getCause();
            throw new RuntimeException(t2.getMessage(), t2);
        }
        catch (IllegalAccessException e5) {
            throw new RuntimeException(e5.getMessage(), e5);
        }
    }

    private static Query getXqrl2002CompiledQuery(String queryExpr, String currentVar) {
        if (_xqrl2002Available && _xqrl2002CompileQuery == null) {
            try {
                Class<?> xqrlImpl = Class.forName("org.apache.xmlbeans.impl.store.Xqrl2002Impl");
                _xqrl2002CompileQuery = xqrlImpl.getDeclaredMethod("compileQuery", String.class, String.class, Boolean.class);
            }
            catch (ClassNotFoundException e2) {
                _xqrl2002Available = false;
                return null;
            }
            catch (Exception e3) {
                _xqrl2002Available = false;
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        Object[] args = new Object[]{queryExpr, currentVar, new Boolean(true)};
        try {
            return (Query)_xqrl2002CompileQuery.invoke(null, args);
        }
        catch (InvocationTargetException e4) {
            Throwable t2 = e4.getCause();
            throw new RuntimeException(t2.getMessage(), t2);
        }
        catch (IllegalAccessException e5) {
            throw new RuntimeException(e5.getMessage(), e5);
        }
    }

    static {
        $assertionsDisabled = !Query.class.desiredAssertionStatus();
        _saxonQueryCache = new HashMap();
        _xqrlQueryCache = new HashMap();
        _xqrlAvailable = true;
        _xqrl2002QueryCache = new HashMap();
        _xqrl2002Available = true;
    }

    private static final class SaxonQueryImpl
    extends Query {
        private SaxonXBeansDelegate.QueryInterface _xqueryImpl;
        static final /* synthetic */ boolean $assertionsDisabled;

        private SaxonQueryImpl(SaxonXBeansDelegate.QueryInterface xqueryImpl) {
            this._xqueryImpl = xqueryImpl;
        }

        public static Query createSaxonCompiledQuery(String queryExpr, String currentVar, int boundary) {
            if (!$assertionsDisabled && (currentVar.startsWith(".") || currentVar.startsWith(".."))) {
                throw new AssertionError();
            }
            SaxonXBeansDelegate.QueryInterface impl = SaxonXBeansDelegate.createQueryInstance(queryExpr, currentVar, boundary);
            if (impl == null) {
                return null;
            }
            return new SaxonQueryImpl(impl);
        }

        XmlObject[] objectExecute(Cur c2, XmlOptions options) {
            return new SaxonQueryEngine(this._xqueryImpl, c2, options).objectExecute();
        }

        XmlCursor cursorExecute(Cur c2, XmlOptions options) {
            return new SaxonQueryEngine(this._xqueryImpl, c2, options).cursorExecute();
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Query == null ? (class$org$apache$xmlbeans$impl$store$Query = Query.class$("org.apache.xmlbeans.impl.store.Query")) : class$org$apache$xmlbeans$impl$store$Query).desiredAssertionStatus();
        }

        private static class SaxonQueryEngine {
            private Cur _cur;
            private SaxonXBeansDelegate.QueryInterface _saxonImpl;
            private long _version;
            private XmlOptions _options;
            static final /* synthetic */ boolean $assertionsDisabled;

            public SaxonQueryEngine(SaxonXBeansDelegate.QueryInterface xqImpl, Cur c2, XmlOptions opt) {
                this._saxonImpl = xqImpl;
                this._version = c2._locale.version();
                this._cur = c2.weakCur(this);
                this._options = opt;
            }

            public XmlObject[] objectExecute() {
                if (this._cur == null || this._version != this._cur._locale.version()) {
                    // empty if block
                }
                Map bindings = (Map)XmlOptions.maskNull(this._options).get("XQUERY_VARIABLE_MAP");
                List resultsList = this._saxonImpl.execQuery(this._cur.getDom(), bindings);
                if (!$assertionsDisabled && resultsList.size() <= -1) {
                    throw new AssertionError();
                }
                XmlObject[] result = new XmlObject[resultsList.size()];
                for (int i2 = 0; i2 < resultsList.size(); ++i2) {
                    Locale l2 = Locale.getLocale(this._cur._locale._schemaTypeLoader, this._options);
                    l2.enter();
                    Object node = resultsList.get(i2);
                    Cur res = null;
                    try {
                        if (!(node instanceof Node)) {
                            res = l2.load("<xml-fragment/>").tempCur();
                            res.setValue(node.toString());
                            SchemaType type = this.getType(node);
                            Locale.autoTypeDocument(res, type, null);
                            result[i2] = res.getObject();
                        } else {
                            res = this.loadNode(l2, (Node)node);
                        }
                        result[i2] = res.getObject();
                    }
                    catch (XmlException e2) {
                        throw new RuntimeException(e2);
                    }
                    finally {
                        l2.exit();
                    }
                    res.release();
                }
                this.release();
                this._saxonImpl = null;
                return result;
            }

            private SchemaType getType(Object node) {
                SchemaType type = node instanceof Integer ? XmlInteger.type : (node instanceof Double ? XmlDouble.type : (node instanceof Long ? XmlLong.type : (node instanceof Float ? XmlFloat.type : (node instanceof BigDecimal ? XmlDecimal.type : (node instanceof Boolean ? XmlBoolean.type : (node instanceof String ? XmlString.type : (node instanceof Date ? XmlDate.type : XmlAnySimpleType.type)))))));
                return type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public XmlCursor cursorExecute() {
                if (this._cur == null || this._version != this._cur._locale.version()) {
                    // empty if block
                }
                Map bindings = (Map)XmlOptions.maskNull(this._options).get("XQUERY_VARIABLE_MAP");
                List resultsList = this._saxonImpl.execQuery(this._cur.getDom(), bindings);
                if (!$assertionsDisabled && resultsList.size() <= -1) {
                    throw new AssertionError();
                }
                this._saxonImpl = null;
                Locale locale = Locale.getLocale(this._cur._locale._schemaTypeLoader, this._options);
                locale.enter();
                Cur.CurLoadContext _context = new Cur.CurLoadContext(locale, this._options);
                Cursor resultCur = null;
                try {
                    for (int i2 = 0; i2 < resultsList.size(); ++i2) {
                        this.loadNodeHelper(locale, (Node)resultsList.get(i2), _context);
                    }
                    Cur c2 = ((Locale.LoadContext)_context).finish();
                    Locale.associateSourceName(c2, this._options);
                    Locale.autoTypeDocument(c2, null, this._options);
                    resultCur = new Cursor(c2);
                }
                catch (Exception e2) {
                }
                finally {
                    locale.exit();
                }
                this.release();
                return resultCur;
            }

            public void release() {
                if (this._cur != null) {
                    this._cur.release();
                    this._cur = null;
                }
            }

            private Cur loadNode(Locale locale, Node node) {
                Cur.CurLoadContext context = new Cur.CurLoadContext(locale, this._options);
                try {
                    this.loadNodeHelper(locale, node, context);
                    Cur c2 = ((Locale.LoadContext)context).finish();
                    Locale.associateSourceName(c2, this._options);
                    Locale.autoTypeDocument(c2, null, this._options);
                    return c2;
                }
                catch (Exception e2) {
                    throw new XmlRuntimeException(e2.getMessage(), e2);
                }
            }

            private void loadNodeHelper(Locale locale, Node node, Locale.LoadContext context) {
                if (node.getNodeType() == 2) {
                    QName attName = new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
                    context.attr(attName, node.getNodeValue());
                } else {
                    locale.loadNode(node, context);
                }
            }

            static {
                $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Query == null ? (class$org$apache$xmlbeans$impl$store$Query = Query.class$("org.apache.xmlbeans.impl.store.Query")) : class$org$apache$xmlbeans$impl$store$Query).desiredAssertionStatus();
            }
        }
    }
}

