/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.util.XsTypeConverter;
import org.apache.xmlbeans.impl.values.JavaDecimalHolder;
import org.apache.xmlbeans.impl.values.JavaLongHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaLongHolderEx
extends JavaLongHolder {
    private SchemaType _schemaType;

    public JavaLongHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    protected void set_text(String s2) {
        long v2;
        try {
            v2 = XsTypeConverter.lexLong(s2);
        }
        catch (Exception e2) {
            throw new XmlValueOutOfRangeException();
        }
        if (this._validateOnSet()) {
            JavaLongHolderEx.validateValue(v2, this._schemaType, _voorVc);
            JavaLongHolderEx.validateLexical(s2, this._schemaType, _voorVc);
        }
        super.set_long(v2);
    }

    protected void set_long(long v2) {
        if (this._validateOnSet()) {
            JavaLongHolderEx.validateValue(v2, this._schemaType, _voorVc);
        }
        super.set_long(v2);
    }

    public static void validateLexical(String v2, SchemaType sType, ValidationContext context) {
        JavaDecimalHolder.validateLexical(v2, context);
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v2)) {
            context.invalid("cvc-datatype-valid.1.1", new Object[]{"long", v2, QNameHelper.readable(sType)});
        }
    }

    private static void validateValue(long v2, SchemaType sType, ValidationContext context) {
        long m2;
        long m3;
        long m4;
        long m5;
        XmlAnySimpleType mine;
        XmlAnySimpleType td = sType.getFacet(7);
        if (td != null) {
            long m6 = JavaLongHolderEx.getLongValue(td);
            String temp = Long.toString(v2);
            int len = temp.length();
            if (len > 0 && temp.charAt(0) == '-') {
                --len;
            }
            if ((long)len > m6) {
                context.invalid("cvc-totalDigits-valid", new Object[]{new Integer(len), temp, new Long(m6), QNameHelper.readable(sType)});
                return;
            }
        }
        if ((mine = sType.getFacet(3)) != null && v2 <= (m5 = JavaLongHolderEx.getLongValue(mine))) {
            context.invalid("cvc-minExclusive-valid", new Object[]{"long", new Long(v2), new Long(m5), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType mini = sType.getFacet(4);
        if (mini != null && v2 < (m4 = JavaLongHolderEx.getLongValue(mini))) {
            context.invalid("cvc-minInclusive-valid", new Object[]{"long", new Long(v2), new Long(m4), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType maxi = sType.getFacet(5);
        if (maxi != null && v2 > (m3 = JavaLongHolderEx.getLongValue(maxi))) {
            context.invalid("cvc-maxInclusive-valid", new Object[]{"long", new Long(v2), new Long(m3), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType maxe = sType.getFacet(6);
        if (maxe != null && v2 >= (m2 = JavaLongHolderEx.getLongValue(maxe))) {
            context.invalid("cvc-maxExclusive-valid", new Object[]{"long", new Long(v2), new Long(m2), QNameHelper.readable(sType)});
            return;
        }
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (v2 != JavaLongHolderEx.getLongValue(vals[i2])) continue;
                return;
            }
            context.invalid("cvc-enumeration-valid", new Object[]{"long", new Long(v2), QNameHelper.readable(sType)});
        }
    }

    private static long getLongValue(XmlObject o2) {
        SchemaType s2 = o2.schemaType();
        switch (s2.getDecimalSize()) {
            case 1000001: {
                return ((XmlObjectBase)o2).bigDecimalValue().longValue();
            }
            case 1000000: {
                return ((XmlObjectBase)o2).bigIntegerValue().longValue();
            }
            case 64: {
                return ((XmlObjectBase)o2).longValue();
            }
        }
        throw new IllegalStateException("Bad facet type: " + s2);
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaLongHolderEx.validateLexical(lexical, this.schemaType(), ctx);
        JavaLongHolderEx.validateValue(this.longValue(), this.schemaType(), ctx);
    }
}

