/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;

public class NullEngine
implements BlockCipher {
    private boolean initialised;
    protected static final int BLOCK_SIZE = 1;

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Null";
    }

    public int getBlockSize() {
        return 1;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Null engine not initialised");
        }
        if (n2 + 1 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 1 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < 1; ++i2) {
            byArray2[n3 + i2] = byArray[n2 + i2];
        }
        return 1;
    }

    public void reset() {
    }
}

