/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        if (this.lookupPowX2 != null && Arrays.areEqual(byArray, (byte[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(Arrays.clone(byArray));
    }

    public void exponentiateX(long l2, byte[] byArray) {
        byte[] byArray2 = GCMUtil.oneAsBytes();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply(byArray2, (byte[])this.lookupPowX2.elementAt(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        System.arraycopy(byArray2, 0, byArray, 0, 16);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            byte[] byArray = (byte[])this.lookupPowX2.elementAt(n3 - 1);
            do {
                byArray = Arrays.clone(byArray);
                GCMUtil.multiply(byArray, byArray);
                this.lookupPowX2.addElement(byArray);
            } while (++n3 <= n2);
        }
    }
}

