/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.crypto.tls.TlsUtils;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new org.bouncycastle.asn1.x509.Certificate[0]);
    protected org.bouncycastle.asn1.x509.Certificate[] certs;

    protected static Certificate parse(InputStream inputStream) throws IOException {
        int n2;
        int n3 = TlsUtils.readUint24(inputStream);
        if (n3 == 0) {
            return EMPTY_CHAIN;
        }
        Vector<org.bouncycastle.asn1.x509.Certificate> vector = new Vector<org.bouncycastle.asn1.x509.Certificate>();
        while (n3 > 0) {
            n2 = TlsUtils.readUint24(inputStream);
            n3 -= 3 + n2;
            byte[] byArray = new byte[n2];
            TlsUtils.readFully(byArray, inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            vector.addElement(org.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Primitive));
            if (byteArrayInputStream.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        org.bouncycastle.asn1.x509.Certificate[] certificateArray = new org.bouncycastle.asn1.x509.Certificate[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            certificateArray[n2] = (org.bouncycastle.asn1.x509.Certificate)vector.elementAt(n2);
        }
        return new Certificate(certificateArray);
    }

    protected void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>();
        int n3 = 0;
        for (n2 = 0; n2 < this.certs.length; ++n2) {
            byArray = this.certs[n2].getEncoded("DER");
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.writeUint24(n3, outputStream);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byArray = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24(byArray, outputStream);
        }
    }

    public Certificate(org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        if (certificateArray == null) {
            throw new IllegalArgumentException("'certs' cannot be null");
        }
        this.certs = certificateArray;
    }

    public org.bouncycastle.asn1.x509.Certificate[] getCerts() {
        org.bouncycastle.asn1.x509.Certificate[] certificateArray = new org.bouncycastle.asn1.x509.Certificate[this.certs.length];
        System.arraycopy(this.certs, 0, certificateArray, 0, this.certs.length);
        return certificateArray;
    }

    public boolean isEmpty() {
        return this.certs.length == 0;
    }
}

