/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.tls.TlsBlockCipher;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsCipherFactory;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsStreamCipher;

public class DefaultTlsCipherFactory
implements TlsCipherFactory {
    public TlsCipher createCipher(TlsClientContext tlsClientContext, int n2, int n3) throws IOException {
        switch (n2) {
            case 7: {
                return this.createDESedeCipher(tlsClientContext, 24, n3);
            }
            case 8: {
                return this.createAESCipher(tlsClientContext, 16, n3);
            }
            case 9: {
                return this.createAESCipher(tlsClientContext, 32, n3);
            }
            case 2: {
                return this.createRC4Cipher(tlsClientContext, 16, n3);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsCipher createAESCipher(TlsClientContext tlsClientContext, int n2, int n3) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createDigest(n3), this.createDigest(n3), n2);
    }

    protected TlsCipher createRC4Cipher(TlsClientContext tlsClientContext, int n2, int n3) throws IOException {
        return new TlsStreamCipher(tlsClientContext, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createDigest(n3), this.createDigest(n3), n2);
    }

    protected TlsCipher createDESedeCipher(TlsClientContext tlsClientContext, int n2, int n3) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createDigest(n3), this.createDigest(n3), n2);
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected Digest createDigest(int n2) throws IOException {
        switch (n2) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

