/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected byte[] randomData;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsClientContext tlsClientContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n2) {
        this.context = tlsClientContext;
        this.randomData = new byte[256];
        tlsClientContext.getSecureRandom().nextBytes(this.randomData);
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize() + blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsClientContext, n3);
        int n4 = 0;
        this.writeMac = new TlsMac(tlsClientContext, digest, byArray, n4, digest.getDigestSize());
        this.readMac = new TlsMac(tlsClientContext, digest2, byArray, n4 += digest.getDigestSize(), digest2.getDigestSize());
        this.initCipher(true, blockCipher, byArray, n2, n4 += digest2.getDigestSize(), n4 + n2 * 2);
        this.initCipher(false, blockCipher2, byArray, n2, n4 += n2, n4 + n2 + blockCipher.getBlockSize());
    }

    protected void initCipher(boolean bl, BlockCipher blockCipher, byte[] byArray, int n2, int n3, int n4) {
        KeyParameter keyParameter = new KeyParameter(byArray, n3, n2);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n4, blockCipher.getBlockSize());
        blockCipher.init(bl, parametersWithIV);
    }

    public byte[] encodePlaintext(short s2, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        int n6 = this.encryptCipher.getBlockSize();
        int n7 = n6 - 1 - (n3 + this.writeMac.getSize()) % n6;
        boolean bl2 = bl = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl) {
            n5 = (255 - n7) / n6;
            int n8 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n5);
            n7 += n8 * n6;
        }
        n5 = n3 + this.writeMac.getSize() + n7 + 1;
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        byte[] byArray3 = this.writeMac.calculateMac(s2, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        int n9 = n3 + byArray3.length;
        for (n4 = 0; n4 <= n7; ++n4) {
            byArray2[n4 + n9] = (byte)n7;
        }
        for (n4 = 0; n4 < n5; n4 += n6) {
            this.encryptCipher.processBlock(byArray2, n4, byArray2, n4);
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(short s2, byte[] byArray, int n2, int n3) throws IOException {
        boolean bl;
        int n4;
        int n5;
        int n6 = this.decryptCipher.getBlockSize();
        int n7 = Math.max(n6, (n5 = this.readMac.getSize()) + 1);
        if (n3 < n7) {
            throw new TlsFatalAlert(50);
        }
        if (n3 % n6 != 0) {
            throw new TlsFatalAlert(21);
        }
        for (n4 = 0; n4 < n3; n4 += n6) {
            this.decryptCipher.processBlock(byArray, n2 + n4, byArray, n2 + n4);
        }
        n4 = n3;
        int n8 = this.checkPaddingConstantTime(byArray, n2, n4, n6, n5);
        int n9 = n4 - n8 - n5;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2 + n9, n2 + n9 + n5);
        byte[] byArray3 = this.readMac.calculateMacConstantTime(s2, byArray, n2, n9, n4 - n5, this.randomData);
        boolean bl2 = bl = !Arrays.constantTimeAreEqual(byArray3, byArray2);
        if (bl || n8 == 0) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n2, n2 + n9);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n2, int n3, int n4, int n5) {
        boolean bl;
        int n6 = n2 + n3;
        byte by = byArray[n6 - 1];
        int n7 = by & 0xFF;
        int n8 = n7 + 1;
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = bl = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (!bl && n8 > n4 || n5 + n8 > n3) {
            n8 = 0;
        } else {
            int n11 = n6 - n8;
            do {
                n10 = (byte)(n10 | byArray[n11++] ^ by);
            } while (n11 < n6);
            n9 = n8;
            if (n10 != 0) {
                n8 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n9 < 256) {
            n10 = (byte)(n10 | byArray2[n9++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n10);
        return n8;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n2) {
        int n3 = secureRandom.nextInt();
        int n4 = this.lowestBitSet(n3);
        return Math.min(n4, n2);
    }

    protected int lowestBitSet(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 0;
        while ((n2 & 1) == 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }
}

