/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    public static final GenericsType[] EMPTY_GENERICS_ARRAY = new GenericsType[0];

    public static GenericsType[] alignGenericTypes(GenericsType[] redirectGenericTypes, GenericsType[] parameterizedTypes, GenericsType[] alignmentTarget) {
        if (alignmentTarget == null) {
            return EMPTY_GENERICS_ARRAY;
        }
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            return alignmentTarget;
        }
        GenericsType[] generics = new GenericsType[alignmentTarget.length];
        for (GenericsType currentTarget : alignmentTarget) {
            GenericsType match = null;
            if (redirectGenericTypes != null) {
                for (int j2 = 0; j2 < redirectGenericTypes.length && match == null; ++j2) {
                    ClassNode[] upper;
                    GenericsType redirectGenericType = redirectGenericTypes[j2];
                    if (!redirectGenericType.isCompatibleWith(currentTarget.getType())) continue;
                    if (currentTarget.isPlaceholder() && redirectGenericType.isPlaceholder() && !currentTarget.getName().equals(redirectGenericType.getName())) {
                        boolean skip = false;
                        for (int k2 = j2 + 1; k2 < redirectGenericTypes.length && !skip; ++k2) {
                            GenericsType ogt = redirectGenericTypes[k2];
                            if (!ogt.isPlaceholder() || !ogt.isCompatibleWith(currentTarget.getType()) || !ogt.getName().equals(currentTarget.getName())) continue;
                            skip = true;
                        }
                        if (skip) continue;
                    }
                    match = parameterizedTypes[j2];
                    if (!currentTarget.isWildcard()) continue;
                    ClassNode lower = currentTarget.getLowerBound() != null ? match.getType() : null;
                    ClassNode[] currentUpper = currentTarget.getUpperBounds();
                    ClassNode[] classNodeArray = upper = currentUpper != null ? new ClassNode[currentUpper.length] : null;
                    if (upper != null) {
                        for (int k3 = 0; k3 < upper.length; ++k3) {
                            upper[k3] = currentUpper[k3].isGenericsPlaceHolder() ? match.getType() : currentUpper[k3];
                        }
                    }
                    match = new GenericsType(ClassHelper.makeWithoutCaching("?"), upper, lower);
                    match.setWildcard(true);
                }
            }
            if (match == null) {
                match = currentTarget;
            }
            generics[i] = match;
        }
        return generics;
    }

    public static GenericsType buildWildcardType(ClassNode ... types) {
        ClassNode base = ClassHelper.makeWithoutCaching("?");
        GenericsType gt = new GenericsType(base, types, null);
        gt.setWildcard(true);
        return gt;
    }

    public static Map<String, GenericsType> extractPlaceholders(ClassNode cn) {
        HashMap<String, GenericsType> ret = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(cn, ret);
        return ret;
    }

    public static void extractPlaceholders(ClassNode node, Map<String, GenericsType> map) {
        if (node == null) {
            return;
        }
        if (!node.isUsingGenerics() || !node.isRedirectNode()) {
            return;
        }
        GenericsType[] parameterized = node.getGenericsTypes();
        if (parameterized == null || parameterized.length == 0) {
            return;
        }
        GenericsType[] redirectGenericsTypes = node.redirect().getGenericsTypes();
        if (redirectGenericsTypes == null) {
            redirectGenericsTypes = parameterized;
        }
        for (int i2 = 0; i2 < redirectGenericsTypes.length; ++i2) {
            String name;
            GenericsType redirectType = redirectGenericsTypes[i2];
            if (!redirectType.isPlaceholder() || map.containsKey(name = redirectType.getName())) continue;
            map.put(name, parameterized[i2]);
        }
        if (node.isArray()) {
            GenericsUtils.extractPlaceholders(node.getComponentType(), map);
        }
    }

    public static ClassNode parameterizeInterfaceGenerics(ClassNode hint, ClassNode target) {
        return GenericsUtils.parameterizeType(hint, target);
    }

    public static ClassNode parameterizeType(ClassNode hint, ClassNode target) {
        ClassNode interfaceFromClassNode = null;
        if (hint.equals(target)) {
            interfaceFromClassNode = hint;
        }
        if (ClassHelper.OBJECT_TYPE.equals(target) && target.isUsingGenerics() && target.getGenericsTypes() != null && target.getGenericsTypes()[0].isPlaceholder()) {
            return ClassHelper.getWrapper(hint);
        }
        if (interfaceFromClassNode == null) {
            ClassNode[] interfaces;
            for (ClassNode node : interfaces = hint.getInterfaces()) {
                if (node.equals(target)) {
                    interfaceFromClassNode = node;
                    break;
                }
                if (!node.implementsInterface(target)) continue;
                return GenericsUtils.parameterizeType(GenericsUtils.parameterizeType(hint, node), target);
            }
        }
        if (interfaceFromClassNode == null && hint.getUnresolvedSuperClass() != null) {
            return GenericsUtils.parameterizeType(hint.getUnresolvedSuperClass(), target);
        }
        if (interfaceFromClassNode == null) {
            interfaceFromClassNode = hint;
        }
        HashMap<String, GenericsType> parameters = new HashMap<String, GenericsType>();
        GenericsUtils.extractPlaceholders(hint, parameters);
        ClassNode node = target.getPlainNodeReference();
        GenericsType[] interfaceGTs = interfaceFromClassNode.getGenericsTypes();
        if (interfaceGTs == null) {
            return target;
        }
        GenericsType[] types = new GenericsType[interfaceGTs.length];
        for (int i2 = 0; i2 < interfaceGTs.length; ++i2) {
            String name;
            GenericsType interfaceGT;
            types[i2] = interfaceGT = interfaceGTs[i2];
            if (!interfaceGT.isPlaceholder() || !parameters.containsKey(name = interfaceGT.getName())) continue;
            types[i2] = (GenericsType)parameters.get(name);
        }
        node.setGenericsTypes(types);
        return node;
    }
}

