/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import groovyjarjarantlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyConstructorDoc;
import org.codehaus.groovy.groovydoc.GroovyFieldDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAbstractableElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAnnotationRef;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleGroovyClassDocAssembler
extends VisitorAdapter
implements GroovyTokenTypes {
    private static final String FS = "/";
    private static final Pattern PREV_JAVADOC_COMMENT_PATTERN = Pattern.compile("(?s)/\\*\\*(.*?)\\*/");
    private final Stack<GroovySourceAST> stack;
    private Map<String, GroovyClassDoc> classDocs;
    private List<String> importedClassesAndPackages;
    private Map<String, String> aliases;
    private List<LinkArgument> links;
    private Properties properties;
    private SimpleGroovyFieldDoc currentFieldDoc;
    private SourceBuffer sourceBuffer;
    private String packagePath;
    private LineColumn lastLineCol;
    private boolean insideEnum;
    private Map<String, SimpleGroovyClassDoc> foundClasses;
    private boolean isGroovy;
    private boolean deferSetup;
    private String className;

    public SimpleGroovyClassDocAssembler(String packagePath, String file, SourceBuffer sourceBuffer, List<LinkArgument> links, Properties properties, boolean isGroovy) {
        this.sourceBuffer = sourceBuffer;
        this.packagePath = packagePath;
        this.links = links;
        this.properties = properties;
        this.isGroovy = isGroovy;
        this.stack = new Stack();
        this.classDocs = new HashMap<String, GroovyClassDoc>();
        this.className = file;
        if (file != null) {
            int idx = file.lastIndexOf(".");
            this.className = file.substring(0, idx);
        }
        this.deferSetup = packagePath.equals("DefaultPackage");
        this.importedClassesAndPackages = new ArrayList<String>();
        this.aliases = new HashMap<String, String>();
        if (!this.deferSetup) {
            this.setUpImports(packagePath, links, isGroovy, this.className);
        }
        this.lastLineCol = new LineColumn(1, 1);
    }

    private void setUpImports(String packagePath, List<LinkArgument> links, boolean isGroovy, String className) {
        this.importedClassesAndPackages.add(packagePath + "/*");
        if (isGroovy) {
            for (String pkg : ResolveVisitor.DEFAULT_IMPORTS) {
                this.importedClassesAndPackages.add(pkg.replace('.', '/') + "*");
            }
        } else {
            this.importedClassesAndPackages.add("java/lang/*");
        }
        SimpleGroovyClassDoc currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, this.aliases, className, links);
        currentClassDoc.setFullPathName(packagePath + FS + className);
        currentClassDoc.setGroovy(isGroovy);
        this.classDocs.put(currentClassDoc.getFullPathName(), currentClassDoc);
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        this.postProcessClassDocs();
        return this.classDocs;
    }

    @Override
    public void visitInterfaceDef(GroovySourceAST t2, int visit) {
        this.visitClassDef(t2, visit);
    }

    @Override
    public void visitEnumDef(GroovySourceAST t2, int visit) {
        this.visitClassDef(t2, visit);
        SimpleGroovyClassDoc currentClassDoc = this.getCurrentOrTopLevelClassDoc(t2);
        if (visit == 4 && currentClassDoc != null) {
            this.adjustForAutomaticEnumMethods(currentClassDoc);
        }
    }

    @Override
    public void visitAnnotationDef(GroovySourceAST t2, int visit) {
        this.visitClassDef(t2, visit);
    }

    @Override
    public void visitClassDef(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            String shortName;
            SimpleGroovyClassDoc parent = this.getCurrentClassDoc();
            String className = shortName = this.getIdentFor(t2);
            if (parent != null && this.isNested() && !this.insideAnonymousInnerClass()) {
                className = parent.name() + "." + className;
            } else {
                this.foundClasses = new HashMap<String, SimpleGroovyClassDoc>();
            }
            SimpleGroovyClassDoc current = (SimpleGroovyClassDoc)this.classDocs.get(this.packagePath + FS + className);
            if (current == null) {
                current = new SimpleGroovyClassDoc(this.importedClassesAndPackages, this.aliases, className, this.links);
                current.setGroovy(this.isGroovy);
            }
            current.setRawCommentText(this.getJavaDocCommentsBeforeNode(t2));
            current.setFullPathName(this.packagePath + FS + current.name());
            current.setTokenType(t2.getType());
            this.processAnnotations(t2, current);
            this.processModifiers(t2, current);
            this.classDocs.put(current.getFullPathName(), current);
            this.foundClasses.put(shortName, current);
            if (parent != null) {
                parent.addNested(current);
                current.setOuter(parent);
            }
        }
    }

    @Override
    public void visitPackageDef(GroovySourceAST t2, int visit) {
        if (visit == 1 && this.deferSetup) {
            String packageWithSlashes = this.extractImportPath(t2);
            this.setUpImports(packageWithSlashes, this.links, this.isGroovy, this.className);
        }
    }

    @Override
    public void visitImport(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            String importTextWithSlashesInsteadOfDots = this.extractImportPath(t2);
            GroovySourceAST child = t2.childOfType(112);
            if (child != null) {
                String alias = child.childOfType(89).getNextSibling().getText();
                child = child.childOfType(89);
                importTextWithSlashesInsteadOfDots = this.recurseDownImportBranch(child);
                this.aliases.put(alias, importTextWithSlashesInsteadOfDots);
            }
            this.importedClassesAndPackages.add(importTextWithSlashesInsteadOfDots);
        }
    }

    @Override
    public void visitExtendsClause(GroovySourceAST t2, int visit) {
        SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
        if (visit == 1) {
            for (GroovySourceAST superClassNode : this.findTypeNames(t2)) {
                String superClassName = this.extractName(superClassNode);
                if (currentClassDoc.isInterface()) {
                    currentClassDoc.addInterfaceName(superClassName);
                    continue;
                }
                currentClassDoc.setSuperClassName(superClassName);
            }
        }
    }

    @Override
    public void visitImplementsClause(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            for (GroovySourceAST classNode : this.findTypeNames(t2)) {
                this.getCurrentClassDoc().addInterfaceName(this.extractName(classNode));
            }
        }
    }

    private List<GroovySourceAST> findTypeNames(GroovySourceAST t2) {
        ArrayList<GroovySourceAST> types = new ArrayList<GroovySourceAST>();
        for (AST child = t2.getFirstChild(); child != null; child = child.getNextSibling()) {
            GroovySourceAST groovySourceAST = (GroovySourceAST)child;
            if (groovySourceAST.getType() == 12) {
                types.add((GroovySourceAST)groovySourceAST.getFirstChild());
                continue;
            }
            types.add(groovySourceAST);
        }
        return types;
    }

    @Override
    public void visitCtorIdent(GroovySourceAST t2, int visit) {
        if (visit == 1 && !this.insideEnum && !this.insideAnonymousInnerClass()) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            SimpleGroovyConstructorDoc currentConstructorDoc = new SimpleGroovyConstructorDoc(currentClassDoc.name(), currentClassDoc);
            currentConstructorDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t2));
            this.processModifiers(t2, currentConstructorDoc);
            this.addParametersTo(t2, currentConstructorDoc);
            this.processAnnotations(t2, currentConstructorDoc);
            currentClassDoc.add(currentConstructorDoc);
        }
    }

    @Override
    public void visitMethodDef(GroovySourceAST t2, int visit) {
        if (visit == 1 && !this.insideEnum && !this.insideAnonymousInnerClass()) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            if (currentClassDoc == null) {
                if ("true".equals(this.properties.getProperty("processScripts", "true"))) {
                    currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, this.aliases, this.className, this.links);
                    currentClassDoc.setFullPathName(this.packagePath + FS + this.className);
                    currentClassDoc.setPublic(true);
                    currentClassDoc.setScript(true);
                    currentClassDoc.setGroovy(this.isGroovy);
                    currentClassDoc.setSuperClassName("groovy/lang/Script");
                    if ("true".equals(this.properties.getProperty("includeMainForScripts", "true"))) {
                        currentClassDoc.add(this.createMainMethod(currentClassDoc));
                    }
                    this.classDocs.put(currentClassDoc.getFullPathName(), currentClassDoc);
                    if (this.foundClasses == null) {
                        this.foundClasses = new HashMap<String, SimpleGroovyClassDoc>();
                    }
                    this.foundClasses.put(this.className, currentClassDoc);
                } else {
                    return;
                }
            }
            SimpleGroovyMethodDoc currentMethodDoc = this.createMethod(t2, currentClassDoc);
            currentClassDoc.add(currentMethodDoc);
        }
    }

    private SimpleGroovyMethodDoc createMethod(GroovySourceAST t2, SimpleGroovyClassDoc currentClassDoc) {
        String methodName = this.getIdentFor(t2);
        SimpleGroovyMethodDoc currentMethodDoc = new SimpleGroovyMethodDoc(methodName, currentClassDoc);
        currentMethodDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t2));
        this.processModifiers(t2, currentMethodDoc);
        currentMethodDoc.setReturnType(new SimpleGroovyType(this.getTypeOrDefault(t2)));
        this.addParametersTo(t2, currentMethodDoc);
        this.processAnnotations(t2, currentMethodDoc);
        return currentMethodDoc;
    }

    private GroovyMethodDoc createMainMethod(SimpleGroovyClassDoc currentClassDoc) {
        SimpleGroovyMethodDoc mainMethod = new SimpleGroovyMethodDoc("main", currentClassDoc);
        mainMethod.setPublic(true);
        mainMethod.setStatic(true);
        mainMethod.setCommentText("Implicit main method for Groovy Scripts");
        mainMethod.setFirstSentenceCommentText(mainMethod.commentText());
        SimpleGroovyParameter args = new SimpleGroovyParameter("args");
        SimpleGroovyType argsType = new SimpleGroovyType("java.lang.String[]");
        args.setType(argsType);
        mainMethod.add(args);
        SimpleGroovyType returnType2 = new SimpleGroovyType("void");
        mainMethod.setReturnType(returnType2);
        return mainMethod;
    }

    @Override
    public void visitAnnotationFieldDef(GroovySourceAST t2, int visit) {
        if (this.isGroovy && visit == 1) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            SimpleGroovyMethodDoc currentMethodDoc = this.createMethod(t2, currentClassDoc);
            String defaultText = this.getDefaultValue(t2);
            if (defaultText != null) {
                String orig = currentMethodDoc.getRawCommentText();
                currentMethodDoc.setRawCommentText(orig + "\n* @default " + defaultText);
            }
            currentClassDoc.add(currentMethodDoc);
        } else if (visit == 1) {
            this.visitVariableDef(t2, visit);
            String defaultText = this.getDefaultValue(t2);
            if (this.isGroovy) {
                this.currentFieldDoc.setPublic(true);
            }
            if (defaultText != null) {
                this.currentFieldDoc.setConstantValueExpression(defaultText);
                String orig = this.currentFieldDoc.getRawCommentText();
                this.currentFieldDoc.setRawCommentText(orig + "\n* @default " + defaultText);
            }
        }
    }

    @Override
    public void visitEnumConstantDef(GroovySourceAST t2, int visit) {
        if (visit == 1) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            this.insideEnum = true;
            String enumConstantName = this.getIdentFor(t2);
            SimpleGroovyFieldDoc currentEnumConstantDoc = new SimpleGroovyFieldDoc(enumConstantName, currentClassDoc);
            currentEnumConstantDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t2));
            this.processModifiers(t2, currentEnumConstantDoc);
            String typeName = this.getTypeNodeAsText(t2.childOfType(12), currentClassDoc.getTypeDescription());
            currentEnumConstantDoc.setType(new SimpleGroovyType(typeName));
            currentClassDoc.addEnumConstant(currentEnumConstantDoc);
        } else if (visit == 4) {
            this.insideEnum = false;
        }
    }

    @Override
    public void visitVariableDef(GroovySourceAST t2, int visit) {
        SimpleGroovyClassDoc currentClassDoc;
        if (visit == 1 && !this.insideAnonymousInnerClass() && this.isFieldDefinition() && (currentClassDoc = this.getCurrentClassDoc()) != null) {
            String fieldName = this.getIdentFor(t2);
            this.currentFieldDoc = new SimpleGroovyFieldDoc(fieldName, currentClassDoc);
            this.currentFieldDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t2));
            boolean isProp = this.processModifiers(t2, this.currentFieldDoc);
            this.currentFieldDoc.setType(new SimpleGroovyType(this.getTypeOrDefault(t2)));
            this.processAnnotations(t2, this.currentFieldDoc);
            if (isProp) {
                currentClassDoc.addProperty(this.currentFieldDoc);
            } else {
                currentClassDoc.add(this.currentFieldDoc);
            }
        }
    }

    @Override
    public void visitAssign(GroovySourceAST t2, int visit) {
        this.gobbleComments(t2, visit);
    }

    @Override
    public void visitMethodCall(GroovySourceAST t2, int visit) {
        this.gobbleComments(t2, visit);
    }

    private void gobbleComments(GroovySourceAST t2, int visit) {
        SimpleGroovyClassDoc currentClassDoc;
        if (visit == 1 && ((currentClassDoc = this.getCurrentClassDoc()) == null || currentClassDoc.isScript()) && (t2.getLine() > this.lastLineCol.getLine() || t2.getLine() == this.lastLineCol.getLine() && t2.getColumn() > this.lastLineCol.getColumn())) {
            this.getJavaDocCommentsBeforeNode(t2);
            this.lastLineCol = new LineColumn(t2.getLine(), t2.getColumn());
        }
    }

    private void postProcessClassDocs() {
        for (GroovyClassDoc groovyClassDoc : this.classDocs.values()) {
            GroovyConstructorDoc[] constructors;
            SimpleGroovyClassDoc classDoc = (SimpleGroovyClassDoc)groovyClassDoc;
            if (!classDoc.isClass() || (constructors = classDoc.constructors()) == null || constructors.length != 0) continue;
            SimpleGroovyConstructorDoc constructorDoc = new SimpleGroovyConstructorDoc(classDoc.name(), classDoc);
            classDoc.add(constructorDoc);
        }
    }

    private boolean isNested() {
        return this.getCurrentClassDoc() != null;
    }

    private boolean isTopLevelConstruct(GroovySourceAST node) {
        if (node == null) {
            return false;
        }
        int type = node.getType();
        return type == 13 || type == 14 || type == 63 || type == 60;
    }

    private void adjustForAutomaticEnumMethods(SimpleGroovyClassDoc currentClassDoc) {
        SimpleGroovyMethodDoc valueOf = new SimpleGroovyMethodDoc("valueOf", currentClassDoc);
        valueOf.setRawCommentText("Returns the enum constant of this type with the specified name.");
        SimpleGroovyParameter parameter = new SimpleGroovyParameter("name");
        parameter.setTypeName("String");
        valueOf.add(parameter);
        valueOf.setReturnType(new SimpleGroovyType(currentClassDoc.name()));
        currentClassDoc.add(valueOf);
        SimpleGroovyMethodDoc values = new SimpleGroovyMethodDoc("values", currentClassDoc);
        values.setRawCommentText("Returns an array containing the constants of this enum type, in the order they are declared.");
        values.setReturnType(new SimpleGroovyType(currentClassDoc.name() + "[]"));
        currentClassDoc.add(values);
    }

    private String extractImportPath(GroovySourceAST t2) {
        return this.recurseDownImportBranch(this.getImportPathDotType(t2));
    }

    private GroovySourceAST getImportPathDotType(GroovySourceAST t2) {
        GroovySourceAST child = t2.childOfType(89);
        if (child == null) {
            child = t2.childOfType(86);
        }
        return child;
    }

    private String recurseDownImportBranch(GroovySourceAST t2) {
        if (t2 != null) {
            if (t2.getType() == 89) {
                GroovySourceAST firstChild = (GroovySourceAST)t2.getFirstChild();
                GroovySourceAST secondChild = (GroovySourceAST)firstChild.getNextSibling();
                return this.recurseDownImportBranch(firstChild) + FS + this.recurseDownImportBranch(secondChild);
            }
            if (t2.getType() == 86) {
                return t2.getText();
            }
            if (t2.getType() == 111) {
                return t2.getText();
            }
        }
        return "";
    }

    private void addAnnotationRef(SimpleGroovyProgramElementDoc node, GroovySourceAST t2) {
        GroovySourceAST classNode = t2.childOfType(86);
        if (classNode != null) {
            node.addAnnotationRef(new SimpleGroovyAnnotationRef(this.extractName(classNode), this.getChildTextFromSource(t2).trim()));
        }
    }

    private void addAnnotationRef(SimpleGroovyParameter node, GroovySourceAST t2) {
        GroovySourceAST classNode = t2.childOfType(86);
        if (classNode != null) {
            node.addAnnotationRef(new SimpleGroovyAnnotationRef(this.extractName(classNode), this.getChildTextFromSource(t2).trim()));
        }
    }

    private void addAnnotationRefs(SimpleGroovyProgramElementDoc node, List<GroovySourceAST> nodes) {
        for (GroovySourceAST t2 : nodes) {
            this.addAnnotationRef(node, t2);
        }
    }

    private void processAnnotations(GroovySourceAST t2, SimpleGroovyProgramElementDoc node) {
        GroovySourceAST modifiers = t2.childOfType(5);
        if (modifiers != null) {
            this.addAnnotationRefs(node, modifiers.childrenOfType(65));
        }
    }

    private String getDefaultValue(GroovySourceAST t2) {
        GroovySourceAST child = (GroovySourceAST)t2.getFirstChild();
        if (t2.getNumberOfChildren() != 4) {
            return null;
        }
        for (int i2 = 1; i2 < t2.getNumberOfChildren(); ++i2) {
            child = (GroovySourceAST)child.getNextSibling();
        }
        GroovySourceAST nodeToProcess = child;
        if (child.getType() != 68 && child.getNumberOfChildren() > 0) {
            nodeToProcess = (GroovySourceAST)child.getFirstChild();
        }
        return this.getChildTextFromSource(nodeToProcess, ";");
    }

    private String getChildTextFromSource(GroovySourceAST child) {
        return this.sourceBuffer.getSnippet(new LineColumn(child.getLine(), child.getColumn()), new LineColumn(child.getLineLast(), child.getColumnLast()));
    }

    private String getChildTextFromSource(GroovySourceAST child, String tokens) {
        String text = this.sourceBuffer.getSnippet(new LineColumn(child.getLine(), child.getColumn()), new LineColumn(child.getLine() + 1, 0));
        StringTokenizer st = new StringTokenizer(text, tokens);
        return st.nextToken();
    }

    private boolean isFieldDefinition() {
        GroovySourceAST parentNode = this.getParentNode();
        return parentNode != null && parentNode.getType() == 6;
    }

    private boolean insideAnonymousInnerClass() {
        GroovySourceAST grandParentNode = this.getGrandParentNode();
        return grandParentNode != null && grandParentNode.getType() == 157;
    }

    private boolean processModifiers(GroovySourceAST t2, SimpleGroovyAbstractableElementDoc memberOrClass) {
        GroovySourceAST modifiers = t2.childOfType(5);
        boolean hasNonPublicVisibility = false;
        boolean hasPublicVisibility = false;
        if (modifiers != null) {
            block8: for (AST currentModifier = modifiers.getFirstChild(); currentModifier != null; currentModifier = currentModifier.getNextSibling()) {
                int type = currentModifier.getType();
                switch (type) {
                    case 114: {
                        memberOrClass.setPublic(true);
                        hasPublicVisibility = true;
                        continue block8;
                    }
                    case 115: {
                        memberOrClass.setProtected(true);
                        hasNonPublicVisibility = true;
                        continue block8;
                    }
                    case 113: {
                        memberOrClass.setPrivate(true);
                        hasNonPublicVisibility = true;
                        continue block8;
                    }
                    case 82: {
                        memberOrClass.setStatic(true);
                        continue block8;
                    }
                    case 37: {
                        memberOrClass.setFinal(true);
                        continue block8;
                    }
                    case 38: {
                        memberOrClass.setAbstract(true);
                    }
                }
            }
            if (!hasNonPublicVisibility && this.isGroovy && !(memberOrClass instanceof GroovyFieldDoc)) {
                memberOrClass.setPublic(true);
            } else if (!(hasNonPublicVisibility || hasPublicVisibility || this.isGroovy)) {
                if (this.insideInterface(memberOrClass) || this.insideAnnotationDef(memberOrClass)) {
                    memberOrClass.setPublic(true);
                } else {
                    memberOrClass.setPackagePrivate(true);
                }
            }
            if (memberOrClass instanceof GroovyFieldDoc && !hasNonPublicVisibility && !hasPublicVisibility && this.isGroovy) {
                return true;
            }
        } else if (this.isGroovy && !(memberOrClass instanceof GroovyFieldDoc)) {
            memberOrClass.setPublic(true);
        } else if (!this.isGroovy) {
            if (this.insideInterface(memberOrClass) || this.insideAnnotationDef(memberOrClass)) {
                memberOrClass.setPublic(true);
            } else {
                memberOrClass.setPackagePrivate(true);
            }
        }
        return memberOrClass instanceof GroovyFieldDoc && this.isGroovy && !hasNonPublicVisibility & !hasPublicVisibility;
    }

    private boolean insideInterface(SimpleGroovyAbstractableElementDoc memberOrClass) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current == null || current == memberOrClass) {
            return false;
        }
        return current.isInterface();
    }

    private boolean insideAnnotationDef(SimpleGroovyAbstractableElementDoc memberOrClass) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current == null || current == memberOrClass) {
            return false;
        }
        return current.isAnnotationType();
    }

    private String getJavaDocCommentsBeforeNode(GroovySourceAST t2) {
        Matcher m2;
        String result = "";
        LineColumn thisLineCol = new LineColumn(t2.getLine(), t2.getColumn());
        String text = this.sourceBuffer.getSnippet(this.lastLineCol, thisLineCol);
        if (text != null && (m2 = PREV_JAVADOC_COMMENT_PATTERN.matcher(text)).find()) {
            result = m2.group(1);
        }
        if (this.isMajorType(t2)) {
            this.lastLineCol = thisLineCol;
        }
        return result;
    }

    private boolean isMajorType(GroovySourceAST t2) {
        if (t2 == null) {
            return false;
        }
        int tt = t2.getType();
        return tt == 13 || tt == 14 || tt == 8 || tt == 63 || tt == 60 || tt == 9 || tt == 67 || tt == 61 || tt == 45;
    }

    private String getText(GroovySourceAST node) {
        String returnValue = null;
        if (node != null) {
            returnValue = node.getText();
        }
        return returnValue;
    }

    private String extractName(GroovySourceAST typeNode) {
        String typeName = this.buildName(typeNode);
        if (!typeName.contains(FS)) {
            String slashName = FS + typeName;
            for (int i2 = this.importedClassesAndPackages.size() - 1; i2 >= 0; --i2) {
                String name = this.importedClassesAndPackages.get(i2);
                if (!name.endsWith(slashName)) continue;
                typeName = name;
                break;
            }
        }
        return typeName;
    }

    private String buildName(GroovySourceAST t2) {
        if (t2 != null) {
            if (t2.getType() == 89) {
                GroovySourceAST firstChild = (GroovySourceAST)t2.getFirstChild();
                GroovySourceAST secondChild = (GroovySourceAST)firstChild.getNextSibling();
                return this.buildName(firstChild) + FS + this.buildName(secondChild);
            }
            if (t2.getType() == 86) {
                return t2.getText();
            }
        }
        return "";
    }

    private String getTypeOrDefault(GroovySourceAST t2) {
        GroovySourceAST typeNode = t2.childOfType(12);
        return this.getTypeNodeAsText(typeNode, "def");
    }

    private String getTypeNodeAsText(GroovySourceAST typeNode, String defaultText) {
        if (typeNode != null && typeNode.getType() == 12 && typeNode.getNumberOfChildren() > 0) {
            return this.getAsText(typeNode, defaultText);
        }
        return defaultText;
    }

    private String getAsText(GroovySourceAST typeNode, String defaultText) {
        GroovySourceAST child = (GroovySourceAST)typeNode.getFirstChild();
        return this.getAsTextCurrent(child, defaultText);
    }

    private String getAsTextCurrent(GroovySourceAST node, String defaultText) {
        switch (node.getType()) {
            case 103: {
                return "boolean";
            }
            case 104: {
                return "byte";
            }
            case 105: {
                return "char";
            }
            case 110: {
                return "double";
            }
            case 108: {
                return "float";
            }
            case 107: {
                return "int";
            }
            case 109: {
                return "long";
            }
            case 106: {
                return "short";
            }
            case 102: {
                return "void";
            }
            case 16: {
                String componentType = this.getAsText(node, defaultText);
                if (!componentType.equals("def")) {
                    return componentType + "[]";
                }
                return "java/lang/Object[]";
            }
            case 86: {
                return node.getText();
            }
            case 89: {
                ArrayList<String> result = new ArrayList<String>();
                for (GroovySourceAST child = (GroovySourceAST)node.getFirstChild(); child != null; child = (GroovySourceAST)child.getNextSibling()) {
                    if (child.getType() == 86) {
                        result.add(child.getText());
                        continue;
                    }
                    if (child.getType() != 89) continue;
                    result.add(this.getAsTextCurrent(child, defaultText));
                }
                return DefaultGroovyMethods.join(result, FS);
            }
        }
        return defaultText;
    }

    private void addParametersTo(GroovySourceAST t2, SimpleGroovyExecutableMemberDoc executableMemberDoc) {
        GroovySourceAST parametersNode = t2.childOfType(19);
        if (parametersNode != null && parametersNode.getNumberOfChildren() > 0) {
            for (GroovySourceAST currentNode = (GroovySourceAST)parametersNode.getFirstChild(); currentNode != null; currentNode = (GroovySourceAST)currentNode.getNextSibling()) {
                String parameterTypeName = this.getTypeOrDefault(currentNode);
                String parameterName = this.getText(currentNode.childOfType(86));
                SimpleGroovyParameter parameter = new SimpleGroovyParameter(parameterName);
                parameter.setVararg(currentNode.getType() == 46);
                parameter.setTypeName(parameterTypeName);
                GroovySourceAST modifiers = currentNode.childOfType(5);
                if (modifiers != null) {
                    List<GroovySourceAST> annotations = modifiers.childrenOfType(65);
                    for (GroovySourceAST a2 : annotations) {
                        this.addAnnotationRef(parameter, a2);
                    }
                }
                executableMemberDoc.add(parameter);
                if (currentNode.getNumberOfChildren() != 4) continue;
                this.handleDefaultValue(currentNode, parameter);
            }
        }
    }

    private void handleDefaultValue(GroovySourceAST currentNode, SimpleGroovyParameter parameter) {
        GroovySourceAST paramPart = (GroovySourceAST)currentNode.getFirstChild();
        for (int i2 = 1; i2 < currentNode.getNumberOfChildren(); ++i2) {
            paramPart = (GroovySourceAST)paramPart.getNextSibling();
        }
        GroovySourceAST nodeToProcess = paramPart;
        if (paramPart.getNumberOfChildren() > 0) {
            nodeToProcess = (GroovySourceAST)paramPart.getFirstChild();
        }
        parameter.setDefaultValue(this.getChildTextFromSource(nodeToProcess, ",)"));
    }

    @Override
    public void push(GroovySourceAST t2) {
        this.stack.push(t2);
    }

    @Override
    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        GroovySourceAST parentNode = null;
        GroovySourceAST currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            parentNode = this.stack.peek();
        }
        this.stack.push(currentNode);
        return parentNode;
    }

    private GroovySourceAST getGrandParentNode() {
        GroovySourceAST grandParentNode = null;
        GroovySourceAST currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            GroovySourceAST parentNode = this.stack.pop();
            if (!this.stack.empty()) {
                grandParentNode = this.stack.peek();
            }
            this.stack.push(parentNode);
        }
        this.stack.push(currentNode);
        return grandParentNode;
    }

    private SimpleGroovyClassDoc getCurrentOrTopLevelClassDoc(GroovySourceAST node) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current != null) {
            return current;
        }
        return this.foundClasses.get(this.getIdentFor(node));
    }

    private SimpleGroovyClassDoc getCurrentClassDoc() {
        if (this.stack.isEmpty()) {
            return null;
        }
        GroovySourceAST node = this.getParentNode();
        if (this.isTopLevelConstruct(node)) {
            return this.foundClasses.get(this.getIdentFor(node));
        }
        GroovySourceAST saved = this.stack.pop();
        SimpleGroovyClassDoc result = this.getCurrentClassDoc();
        this.stack.push(saved);
        return result;
    }

    private String getIdentFor(GroovySourceAST gpn) {
        return gpn.childOfType(86).getText();
    }
}

