/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j;

import java.awt.geom.Rectangle2D;

public class BarcodeDimension {
    private double width;
    private double height;
    private double widthPlusQuiet;
    private double heightPlusQuiet;
    private double xOffset;
    private double yOffset;

    public BarcodeDimension(double w2, double h2) {
        this.width = w2;
        this.height = h2;
        this.widthPlusQuiet = this.width;
        this.heightPlusQuiet = this.height;
        this.xOffset = 0.0;
        this.yOffset = 0.0;
    }

    public BarcodeDimension(double w2, double h2, double wpq, double hpq, double xoffset, double yoffset) {
        this.width = w2;
        this.height = h2;
        this.widthPlusQuiet = wpq;
        this.heightPlusQuiet = hpq;
        this.xOffset = xoffset;
        this.yOffset = yoffset;
    }

    public double getHeight() {
        return this.height;
    }

    public double getHeight(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    public double getHeightPlusQuiet() {
        return this.heightPlusQuiet;
    }

    public double getHeightPlusQuiet(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getWidthPlusQuiet();
        }
        return this.getHeightPlusQuiet();
    }

    public double getWidth() {
        return this.width;
    }

    public static int normalizeOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return 0;
            }
            case -270: 
            case 90: {
                return 90;
            }
            case -180: 
            case 180: {
                return 180;
            }
            case -90: 
            case 270: {
                return 270;
            }
        }
        throw new IllegalArgumentException("Orientation must be 0, 90, 180, 270, -90, -180 or -270");
    }

    public double getWidth(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    public double getWidthPlusQuiet() {
        return this.widthPlusQuiet;
    }

    public double getWidthPlusQuiet(int orientation) {
        if ((orientation = BarcodeDimension.normalizeOrientation(orientation)) % 180 != 0) {
            return this.getHeightPlusQuiet();
        }
        return this.getWidthPlusQuiet();
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Rectangle2D getBoundingRect() {
        Rectangle2D.Double r2 = new Rectangle2D.Double(0.0, 0.0, this.getWidthPlusQuiet(), this.getHeightPlusQuiet());
        return r2;
    }

    public Rectangle2D getContentRect() {
        Rectangle2D.Double r2 = new Rectangle2D.Double(this.getXOffset(), this.getYOffset(), this.getWidth(), this.getHeight());
        return r2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("[width=");
        sb.append(this.getWidth());
        sb.append("(");
        sb.append(this.getWidthPlusQuiet());
        sb.append("),height=");
        sb.append(this.getHeight());
        sb.append("(");
        sb.append(this.getHeightPlusQuiet());
        sb.append(")]");
        return sb.toString();
    }
}

