/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import java.awt.Dimension;
import org.krysalis.barcode4j.BarGroup;
import org.krysalis.barcode4j.ClassicBarcodeLogicHandler;
import org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.impl.pdf417.PDF417Constants;
import org.krysalis.barcode4j.impl.pdf417.PDF417ErrorCorrection;
import org.krysalis.barcode4j.impl.pdf417.PDF417HighLevelEncoder;

public class PDF417LogicImpl {
    public static int getNumberOfRows(int m2, int k2, int c2) {
        int r2 = PDF417LogicImpl.calculateNumberOfRows(m2, k2, c2);
        if (r2 > 90) {
            throw new IllegalArgumentException("The message doesn't fit in the configured symbol size. The resultant number of rows for this barcode exceeds 90. Please increase the number of columns or decrease the error correction level to reduce the number of rows.");
        }
        if (r2 < 3) {
            throw new IllegalArgumentException("The message is too short for the configured symbol size. The resultant number of rows is less than 3. Please decrease the number of columns or increase the error correction level to increase the number of rows.");
        }
        return r2;
    }

    public static int calculateNumberOfRows(int m2, int k2, int c2) {
        int r2 = (m2 + 1 + k2) / c2 + 1;
        if (c2 * r2 >= m2 + 1 + k2 + c2) {
            --r2;
        }
        return r2;
    }

    public static int getNumberOfPadCodewords(int m2, int k2, int c2, int r2) {
        int n2 = c2 * r2 - k2;
        if (n2 > m2 + 1) {
            return n2 - m2 - 1;
        }
        return 0;
    }

    public static int getNumberOfDataCodewords(int m2, int errorCorrectionLevel, int c2) {
        int k2 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        int r2 = PDF417LogicImpl.getNumberOfRows(m2, k2, c2);
        return c2 * r2 - k2;
    }

    private static void encodeChar(int pattern, int len, ClassicBarcodeLogicHandler logic) {
        int map = 1 << len - 1;
        boolean last = (pattern & map) != 0;
        int width = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            boolean black;
            boolean bl = black = (pattern & map) != 0;
            if (last == black) {
                ++width;
            } else {
                logic.addBar(last, width);
                last = black;
                width = 1;
            }
            map >>= 1;
        }
        logic.addBar(last, width);
    }

    private static void encodeLowLevel(String fullCodewords, int c2, int r2, int errorCorrectionLevel, TwoDimBarcodeLogicHandler logic) {
        int idx = 0;
        for (int y = 0; y < r2; ++y) {
            int right;
            int left;
            int cluster = y % 3;
            logic.startRow();
            logic.startBarGroup(BarGroup.START_CHARACTER, null);
            PDF417LogicImpl.encodeChar(130728, 17, logic);
            logic.endBarGroup();
            if (cluster == 0) {
                left = 30 * (y / 3) + (r2 - 1) / 3;
                right = 30 * (y / 3) + (c2 - 1);
            } else if (cluster == 1) {
                left = 30 * (y / 3) + errorCorrectionLevel * 3 + (r2 - 1) % 3;
                right = 30 * (y / 3) + (r2 - 1) / 3;
            } else {
                left = 30 * (y / 3) + (c2 - 1);
                right = 30 * (y / 3) + errorCorrectionLevel * 3 + (r2 - 1) % 3;
            }
            logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
            int pattern = PDF417Constants.CODEWORD_TABLE[cluster][left];
            PDF417LogicImpl.encodeChar(pattern, 17, logic);
            logic.endBarGroup();
            for (int x2 = 0; x2 < c2; ++x2) {
                logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
                pattern = PDF417Constants.CODEWORD_TABLE[cluster][fullCodewords.charAt(idx)];
                PDF417LogicImpl.encodeChar(pattern, 17, logic);
                logic.endBarGroup();
                ++idx;
            }
            logic.startBarGroup(BarGroup.MSG_CHARACTER, null);
            pattern = PDF417Constants.CODEWORD_TABLE[cluster][right];
            PDF417LogicImpl.encodeChar(pattern, 17, logic);
            logic.endBarGroup();
            logic.startBarGroup(BarGroup.STOP_CHARACTER, null);
            PDF417LogicImpl.encodeChar(260649, 18, logic);
            logic.endBarGroup();
            logic.endRow();
        }
    }

    public static void generateBarcodeLogic(TwoDimBarcodeLogicHandler logic, String msg, PDF417Bean pdf417Bean) {
        int errorCorrectionLevel = pdf417Bean.getErrorCorrectionLevel();
        int errorCorrectionCodeWords = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(errorCorrectionLevel);
        String highLevel = PDF417HighLevelEncoder.encodeHighLevel(msg);
        int sourceCodeWords = highLevel.length();
        Dimension dimension = PDF417LogicImpl.determineDimensions(pdf417Bean, sourceCodeWords);
        if (dimension == null) {
            throw new IllegalArgumentException("Unable to fit message in columns");
        }
        int rows = dimension.height;
        int cols = dimension.width;
        int pad = PDF417LogicImpl.getNumberOfPadCodewords(sourceCodeWords, errorCorrectionCodeWords, cols, rows);
        int n2 = PDF417LogicImpl.getNumberOfDataCodewords(sourceCodeWords, errorCorrectionLevel, cols);
        if (n2 > 929) {
            throw new IllegalArgumentException("Encoded message contains to many code words, message to big (" + msg.length() + " bytes)");
        }
        StringBuffer sb = new StringBuffer(n2);
        sb.append((char)n2);
        sb.append(highLevel);
        for (int i2 = 0; i2 < pad; ++i2) {
            sb.append('\u0384');
        }
        String dataCodewords = sb.toString();
        String ec = PDF417ErrorCorrection.generateErrorCorrection(dataCodewords, errorCorrectionLevel);
        String fullCodewords = dataCodewords + ec;
        logic.startBarcode(msg, msg);
        PDF417LogicImpl.encodeLowLevel(fullCodewords, cols, rows, errorCorrectionLevel, logic);
        logic.endBarcode();
    }

    public static Dimension determineDimensions(PDF417Bean pdf417Bean, int sourceCodeWords) {
        int rows;
        int minCols = pdf417Bean.getMinCols();
        int maxCols = pdf417Bean.getMaxCols();
        int maxRows = pdf417Bean.getMaxRows();
        int minRows = pdf417Bean.getMinRows();
        double preferredRatio = pdf417Bean.getWidthToHeightRatio();
        double ratio = 0.0;
        Dimension dimension = null;
        int errorCorrectionCodeWords = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(pdf417Bean.getErrorCorrectionLevel());
        for (int cols = minCols; cols <= maxCols && (rows = PDF417LogicImpl.calculateNumberOfRows(sourceCodeWords, errorCorrectionCodeWords, cols)) >= minRows; ++cols) {
            if (rows > maxRows) continue;
            double newRatio = (double)(17 * cols + 69) * pdf417Bean.getModuleWidth() / ((double)rows * pdf417Bean.getBarHeight());
            if (dimension != null && Math.abs(newRatio - preferredRatio) > Math.abs(ratio - preferredRatio)) continue;
            ratio = newRatio;
            dimension = new Dimension(cols, rows);
        }
        return dimension;
    }
}

