/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.Locale;
import java.util.regex.Pattern;
import org.simpleframework.xml.transform.InvalidFormatException;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocaleTransform
implements Transform<Locale> {
    private final Pattern pattern = Pattern.compile("_");

    @Override
    public Locale read(String locale) throws Exception {
        String[] list = this.pattern.split(locale);
        if (list.length < 1) {
            throw new InvalidFormatException("Invalid locale %s", locale);
        }
        return this.read(list);
    }

    private Locale read(String[] locale) throws Exception {
        String[] list = new String[]{"", "", ""};
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (i2 >= locale.length) continue;
            list[i2] = locale[i2];
        }
        return new Locale(list[0], list[1], list[2]);
    }

    @Override
    public String write(Locale locale) {
        return locale.toString();
    }
}

