/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.regex.Pattern;
import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringArrayTransform
implements Transform<String[]> {
    private final Pattern pattern;
    private final String token;

    public StringArrayTransform() {
        this(",");
    }

    public StringArrayTransform(String token) {
        this.pattern = Pattern.compile(token);
        this.token = token;
    }

    @Override
    public String[] read(String value) {
        return this.read(value, this.token);
    }

    private String[] read(String value, String token) {
        String[] list = this.pattern.split(value);
        for (int i2 = 0; i2 < list.length; ++i2) {
            String text = list[i2];
            if (text == null) continue;
            list[i2] = text.trim();
        }
        return list;
    }

    @Override
    public String write(String[] list) {
        return this.write(list, this.token);
    }

    private String write(String[] list, String token) {
        StringBuilder text = new StringBuilder();
        for (int i2 = 0; i2 < list.length; ++i2) {
            String item = list[i2];
            if (item == null) continue;
            if (text.length() > 0) {
                text.append(token);
                text.append(' ');
            }
            text.append(item);
        }
        return text.toString();
    }
}

