/*
 * Decompiled with CFR 0.152.
 */
package tangram.dbf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Vector;
import tangram.dbf.TngDbfField;
import tangram.dbf.TngDbfUtils;
import tangram.library.Nat;

public class TngDbfHeader {
    private static final byte SIG_DBASE_III = 3;
    private byte signature = (byte)3;
    private byte year;
    private byte month;
    private byte day;
    private int numberOfRecords;
    private short headerLength;
    private short recordLength;
    private short reserv1;
    private byte incompleteTransaction;
    private byte encryptionFlag;
    private int freeRecordThread;
    private int reserv2;
    private int reserv3;
    private byte mdxFlag;
    private byte languageDriver;
    private short reserv4;
    private TngDbfField[] fieldArray;
    private byte terminator1 = (byte)13;

    public String toString() {
        return this.year + "/" + this.month + "/" + this.day + "\n" + Nat.x("Po\u010det z\u00e1znamov:") + " " + this.numberOfRecords + "\n" + Nat.x("D\u013a\u017eka hlavi\u010dky:") + " " + this.headerLength;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecords(int count) {
        this.numberOfRecords = count;
    }

    public TngDbfField[] getFields() {
        return this.fieldArray;
    }

    public void setFields(TngDbfField[] fields) {
        this.fieldArray = fields;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void read(DataInput dataInput) throws IOException {
        this.signature = dataInput.readByte();
        this.year = dataInput.readByte();
        this.month = dataInput.readByte();
        this.day = dataInput.readByte();
        this.numberOfRecords = TngDbfUtils.readLittleEndianInt(dataInput);
        this.headerLength = TngDbfUtils.readLittleEndianShort(dataInput);
        this.recordLength = TngDbfUtils.readLittleEndianShort(dataInput);
        this.reserv1 = TngDbfUtils.readLittleEndianShort(dataInput);
        this.incompleteTransaction = dataInput.readByte();
        this.encryptionFlag = dataInput.readByte();
        this.freeRecordThread = TngDbfUtils.readLittleEndianInt(dataInput);
        this.reserv2 = dataInput.readInt();
        this.reserv3 = dataInput.readInt();
        this.mdxFlag = dataInput.readByte();
        this.languageDriver = dataInput.readByte();
        this.reserv4 = TngDbfUtils.readLittleEndianShort(dataInput);
        Vector<TngDbfField> v_fields = new Vector<TngDbfField>();
        TngDbfField field = TngDbfField.createField(dataInput);
        while (field != null) {
            v_fields.addElement(field);
            field = TngDbfField.createField(dataInput);
        }
        this.fieldArray = new TngDbfField[v_fields.size()];
        for (int i2 = 0; i2 < this.fieldArray.length; ++i2) {
            this.fieldArray[i2] = (TngDbfField)v_fields.elementAt(i2);
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.signature);
        GregorianCalendar calendar = new GregorianCalendar();
        this.year = (byte)(calendar.get(1) - 1900);
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        dataOutput.writeByte(this.year);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
        this.numberOfRecords = TngDbfUtils.littleEndian(this.numberOfRecords);
        dataOutput.writeInt(this.numberOfRecords);
        this.headerLength = this.findHeaderLength();
        dataOutput.writeShort(TngDbfUtils.littleEndian(this.headerLength));
        this.recordLength = this.findRecordLength();
        dataOutput.writeShort(TngDbfUtils.littleEndian(this.recordLength));
        dataOutput.writeShort(TngDbfUtils.littleEndian(this.reserv1));
        dataOutput.writeByte(this.incompleteTransaction);
        dataOutput.writeByte(this.encryptionFlag);
        dataOutput.writeInt(TngDbfUtils.littleEndian(this.freeRecordThread));
        dataOutput.writeInt(TngDbfUtils.littleEndian(this.reserv2));
        dataOutput.writeInt(TngDbfUtils.littleEndian(this.reserv3));
        dataOutput.writeByte(this.mdxFlag);
        dataOutput.writeByte(this.languageDriver);
        dataOutput.writeShort(TngDbfUtils.littleEndian(this.reserv4));
        for (int i2 = 0; i2 < this.fieldArray.length; ++i2) {
            this.fieldArray[i2].write(dataOutput);
        }
        dataOutput.writeByte(this.terminator1);
    }

    private short findHeaderLength() {
        return (short)(32 + 32 * this.fieldArray.length + 1);
    }

    private short findRecordLength() {
        int recordLength = 0;
        for (int i2 = 0; i2 < this.fieldArray.length; ++i2) {
            recordLength += this.fieldArray[i2].getFieldLength();
        }
        return (short)(recordLength + 1);
    }
}

