/*
 * Decompiled with CFR 0.152.
 */
package tangram.devices;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import tangram.devices.TngPorts;
import tangram.devices.TngReadersListener;
import tangram.interfaces.TngReadable;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public final class TngCardReaderDuha
implements TngReadable,
SerialPortEventListener {
    public static String DEF_COMPORT_PARAMS = "9600,N,8,1";
    public boolean LOGGING = false;
    private boolean opened;
    private String port;
    private TngReadersListener listener;
    private InputStream inputStream;
    private SerialPort serialPort;
    private StringBuilder inputBuffer = new StringBuilder(9);

    @Override
    public String getName() {
        return Nat.x("\u010c\u00edta\u010dka kariet DUHA");
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public void setListener(TngReadersListener listener) {
        this.listener = listener;
    }

    @Override
    public void open() throws Exception {
        this.close();
        if (this.listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.serialPortOpen(this.port);
        this.opened = true;
    }

    @Override
    public void close() {
        this.serialPortClose();
        this.opened = false;
    }

    private void serialPortOpen(String port) throws Exception {
        if (this.LOGGING) {
            System.out.println(Nat.nox("Otv\u00e1ranie CardReaderDuha portu %1", port));
        }
        this.serialPort = TngPorts.openSerial(Nat.x("\u010c\u00edta\u010dka \u010dipov\u00fdch kariet DUHA"), port, DEF_COMPORT_PARAMS);
        this.inputStream = this.serialPort.getInputStream();
        if (this.inputStream == null) {
            throw new Exception(Nat.x("S\u00e9riov\u00fd port %1 nie je mo\u017en\u00e9 otvori\u0165 pre \u010d\u00edtanie", port));
        }
        this.serialPort.addEventListener(this);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.setFlowControlMode(0);
    }

    private void serialPortClose() {
        if (this.serialPort == null) {
            return;
        }
        try {
            if (this.LOGGING) {
                System.out.println(Nat.nox("Zatv\u00e1ranie CardReaderDuha portu %1", this.serialPort.getName()));
            }
            this.inputStream.close();
            this.inputStream = null;
            this.serialPort.close();
            this.serialPort = null;
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    @Override
    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() != 1) {
            return;
        }
        try {
            int c2;
            while (true) {
                c2 = this.inputStream.read();
                if (this.LOGGING) {
                    System.out.println("CardReaderDuha read: " + c2);
                }
                if (c2 < 0) {
                    return;
                }
                if (c2 < 48) break;
                if (this.inputBuffer.length() > 9) {
                    if (this.LOGGING) {
                        System.err.println("CardReaderDuha read too long packet");
                    }
                    this.inputBuffer.setLength(0);
                }
                this.inputBuffer.append((char)c2);
            }
            if (this.inputBuffer.length() == 9 && this.inputBuffer.charAt(0) == ';') {
                String card = this.inputBuffer.substring(1);
                this.cardReaded(card);
            }
            if (c2 < 48) {
                this.inputBuffer.setLength(0);
            }
        }
        catch (Throwable e2) {
            TngUtilities.exceptionLog(e2);
        }
    }

    private synchronized void cardReaded(String cardcode) {
        this.listener.codeReaded(this, cardcode, 1);
    }
}

