/*
 * Decompiled with CFR 0.152.
 */
package tangram.devices;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.util.Enumeration;
import java.util.Vector;
import tangram.library.Nat;
import tangram.library.TngUtilities;

public class TngPorts {
    private static Vector<String> cachedPorts = null;

    public static Vector<String> getSerialPorts() {
        if (cachedPorts == null) {
            TngPorts.refreshSerialPorts();
        }
        return cachedPorts;
    }

    public static void refreshSerialPorts() {
        Vector<String> ports = new Vector<String>(10);
        Enumeration e2 = CommPortIdentifier.getPortIdentifiers();
        while (e2.hasMoreElements()) {
            CommPortIdentifier p2 = (CommPortIdentifier)e2.nextElement();
            if (p2.getPortType() != 1) continue;
            ports.add(p2.getName());
        }
        cachedPorts = ports;
    }

    public static String[] getSerialPorts(String defParams) {
        return TngPorts.expandSerialPorts(null, defParams, true);
    }

    public static String[] expandSerialPorts(Vector<String> ports, String defParams, boolean firstEmpty) {
        if (ports == null) {
            ports = TngPorts.getSerialPorts();
        }
        int i2 = 0;
        String[] ret = new String[ports.size() + (firstEmpty ? 1 : 0)];
        if (firstEmpty) {
            ret[i2++] = "";
        }
        for (int p2 = 0; p2 < ports.size(); ++p2) {
            ret[i2++] = TngPorts.expandSerialPort(ports.get(p2), defParams);
        }
        return ret;
    }

    public static String expandSerialPort(String port, String defParams) {
        if (port == null || port.length() == 0 || defParams == null || defParams.length() == 0) {
            return port;
        }
        if (port.indexOf(44) > 0) {
            return port;
        }
        return port + " " + defParams;
    }

    public static SerialPort openSerialSingle(String info, String port) throws Exception {
        return TngPorts.openSerial(info, port, null);
    }

    public static SerialPort openSerial(String device, String port, String defParams) throws Exception {
        port = TngPorts.expandSerialPort(port, defParams);
        DevicePortParams params = TngPorts.getSerialPortParams(device, port, null);
        String desc = device + " (" + port + ")";
        try {
            CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier(params.portName);
            SerialPort serialPort = (SerialPort)portId.open(desc, 100);
            serialPort.setSerialPortParams(params.baudRate, params.dataBits, params.stopBits, params.parity);
            return serialPort;
        }
        catch (Exception e2) {
            throw new Exception(Nat.x("Chyba otv\u00e1rania s\u00e9riov\u00e9ho portu: %1", desc) + "\n" + e2.toString());
        }
    }

    public static DevicePortParams getSerialPortParams(String device, String port, DevicePortParams params) throws Exception {
        if (port == null || port.trim().length() == 0) {
            throw new Exception(Nat.x("Nezadan\u00fd s\u00e9riov\u00fd port: %1", device));
        }
        port = port.trim();
        String desc = device + " (" + port + ")";
        int p2 = port.indexOf(32);
        if (p2 <= 0) {
            throw new Exception(Nat.x("Nezadan\u00e9 parametre s\u00e9riov\u00e9ho portu: %1", desc));
        }
        if (params == null) {
            params = new DevicePortParams();
        }
        params.portName = port.substring(0, p2);
        String h2 = port.substring(p2 + 1);
        String[] prm = TngUtilities.strTokenizeNotNull(h2, ',');
        if (prm.length != 4) {
            throw new Exception(Nat.x("Nespr\u00e1vne parametre s\u00e9riov\u00e9ho portu: %1", desc));
        }
        params.baudRate = TngUtilities.strToInt(prm[0].trim(), -1);
        params.dataBits = TngUtilities.strToInt(prm[2].trim(), -1);
        params.stopBits = TngUtilities.strToInt(prm[3].trim(), -1);
        h2 = prm[1].trim().toUpperCase();
        params.parity = h2.endsWith("N") ? 0 : (h2.endsWith("E") ? 2 : (h2.endsWith("O") ? 1 : (h2.endsWith("S") ? 4 : (h2.endsWith("M") ? 3 : -1))));
        if (params.portName.length() == 0 || params.baudRate <= 0 || params.dataBits < 5 || params.stopBits < 0 || params.parity < 0) {
            throw new Exception(Nat.x("Nespr\u00e1vne parametre s\u00e9riov\u00e9ho portu: %1", desc));
        }
        return params;
    }

    public static class DevicePortParams {
        public String portName;
        public int baudRate;
        public int dataBits;
        public int stopBits;
        public int parity;
    }
}

