/*
 * Decompiled with CFR 0.152.
 */
package tangram.devices;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.SwingUtilities;
import tangram.devices.TngBarcodeReader;
import tangram.devices.TngCardReaderAhl;
import tangram.devices.TngCardReaderAr;
import tangram.devices.TngCardReaderDuha;
import tangram.devices.TngCardReaderGp;
import tangram.devices.TngCardReaderKaba;
import tangram.devices.TngReadersListener;
import tangram.interfaces.TngReadable;
import tangram.library.Nat;
import tangram.library.TngActivity;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;

public class TngReaders
implements TngReadersListener {
    public static final String READER_NONE = "";
    public static final String READER_EAN = "EAN";
    public static final String READER_AR = "AR";
    public static final String READER_GP = "GP";
    public static final String READER_KABA = "KABA";
    public static final String READER_DUHA = "DUHA";
    public static final String READER_AHL = "AHL";
    private TngReadable barcodeReader1;
    private TngReadable barcodeReader2;
    private TngReadable cardReader;
    private int cardreaderBits;

    @Override
    public void codeReaded(Object device, String code, int type) {
        this.sendCodeInvokeLater(device, code, type);
    }

    public boolean isCardReader() {
        return this.cardReader != null;
    }

    public void open(String barcode1Port, String barcode2Port, String cardreaderType, String cardreaderPort, int cardreaderBits) {
        this.cardreaderBits = cardreaderBits;
        this.barcodeReader1 = this.createReader(READER_EAN, barcode1Port);
        this.barcodeReader2 = this.createReader(READER_EAN, barcode2Port);
        this.cardReader = this.createReader(cardreaderType, cardreaderPort);
    }

    public void close() {
        if (this.barcodeReader1 != null) {
            this.barcodeReader1.close();
        }
        if (this.barcodeReader2 != null) {
            this.barcodeReader2.close();
        }
        if (this.cardReader != null) {
            this.cardReader.close();
        }
        this.barcodeReader1 = null;
        this.barcodeReader2 = null;
        this.cardReader = null;
    }

    private TngReadable createReader(String type, String port) {
        if (port == null || port.length() == 0) {
            return null;
        }
        TngReadable reader = null;
        try {
            if (READER_EAN.equals(type)) {
                reader = new TngBarcodeReader();
            } else if (READER_AR.equals(type)) {
                reader = new TngCardReaderAr();
            } else if (READER_GP.equals(type)) {
                reader = new TngCardReaderGp();
            } else if (READER_KABA.equals(type)) {
                reader = new TngCardReaderKaba();
            } else if (READER_DUHA.equals(type)) {
                reader = new TngCardReaderDuha();
            } else if (READER_AHL.equals(type)) {
                reader = new TngCardReaderAhl();
            } else {
                return null;
            }
            reader.setListener(this);
            reader.setPort(port);
            reader.open();
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
        return reader;
    }

    private synchronized void sendCodeInvokeLater(final Object device, final String code, final int type) {
        TngActivity.reset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TngReaders.this.sendCodeOnInvokeLater(device, code, type);
            }
        });
    }

    private void sendCodeOnInvokeLater(Object device, String code, int type) {
        try {
            KeyboardFocusManager k2;
            Window focusedWindow;
            if (type == 1 && this.cardreaderBits > 0) {
                code = this.hexStringBits(code, this.cardreaderBits, 10);
            }
            if ((focusedWindow = (k2 = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusedWindow()) == null) {
                return;
            }
            if (!focusedWindow.isShowing()) {
                TngReaders.showMsgUnusedCode(code);
                return;
            }
            TngReadersListener listener = this.findReadersListener(focusedWindow);
            if (listener == null) {
                TngReaders.showMsgUnusedCode(code);
            } else {
                listener.codeReaded(device, code, type);
            }
        }
        catch (Throwable e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    public TngReadersListener findReadersListener(Container container) {
        if (container == null) {
            return null;
        }
        if (container instanceof TngReadersListener) {
            return (TngReadersListener)((Object)container);
        }
        Component[] component = container.getComponents();
        for (int i2 = 0; i2 < component.length; ++i2) {
            TngReadersListener listener;
            Component c2 = component[i2];
            if (c2 instanceof TngReadersListener) {
                return (TngReadersListener)((Object)c2);
            }
            if (!(c2 instanceof Container) || (listener = this.findReadersListener((Container)c2)) == null) continue;
            return listener;
        }
        return null;
    }

    public static void showMsgUnusedCode(String code) {
        TngSwing.msgWarning(Nat.x("Na\u010d\u00edtan\u00fd k\u00f3d %1 nie je mo\u017en\u00e9 pou\u017ei\u0165 v aktu\u00e1lnom okne", code));
    }

    private String hexStringBits(String hexString, int bits, int chars) {
        if (bits < 1 || bits > 63) {
            throw new IllegalArgumentException("Bits count is illegal");
        }
        if (hexString == null || hexString.length() == 0) {
            return hexString;
        }
        long val = Long.parseLong(hexString, 16);
        long mask = (1L << bits) - 1L;
        String h2 = Long.toHexString(val &= mask).toUpperCase();
        h2 = TngUtilities.strPadRight(h2, chars, '0');
        return h2;
    }
}

