/*
 * Decompiled with CFR 0.152.
 */
package tangram.dm;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import tangram.dm.Column;
import tangram.dm.Index;
import tangram.dm.SchemaInfo;
import tangram.dm.Table;
import tangram.dm.Version;
import tangram.exception.TngExceptionSql;
import tangram.library.Nat;
import tangram.library.TngConnection;

public final class SchemaAccessorSql {
    private SchemaAccessorSql() {
    }

    public static SchemaInfo readSchemaInfo(TngConnection connection) throws Exception {
        Object[] o2 = connection.queryObjects("SELECT projekt,verzia,xo,xd FROM verzie WHERE verzia IS NOT NULL ORDER BY verzia DESC");
        if (o2 == null) {
            throw new Exception(Nat.x("V tabu\u013eke VERZIE nebol najden\u00fd \u017eiaden korektn\u00fd z\u00e1znam"));
        }
        SchemaInfo info = new SchemaInfo();
        info.project = (String)o2[0];
        info.version = new Version(o2[1].toString());
        info.modifiedBy = (String)o2[2];
        info.modifiedDate = (Date)o2[3];
        if (info.project == null) {
            throw new Exception(Nat.x("V tabu\u013eke VERZIE bola najden\u00e1 verzia %1, ale nie je zn\u00e1my projekt", info.version));
        }
        return info;
    }

    public static boolean existsTable(TngConnection connection, String name) throws TngExceptionSql {
        return null != connection.queryObject("SELECT 1 FROM all_tables where table_name='" + name + "' AND owner=sys_context('userenv','current_schema')");
    }

    public static Table readTable(TngConnection connection, String tableName) throws Exception {
        Table table = new Table();
        table.name = tableName;
        SchemaAccessorSql.readTableColumns(connection, tableName, table.columns, false);
        return table;
    }

    public static void readTables(TngConnection connection, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT table_name FROM all_tables WHERE owner=sys_context('userenv','current_schema') ORDER BY table_name");
    }

    public static void readPackages(TngConnection connection, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT name FROM all_source WHERE type='PACKAGE' AND owner=sys_context('userenv','current_schema') GROUP BY name ORDER BY name");
    }

    public static void readTableIndexes(TngConnection connection, String tableName, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT owner||'.'||index_name FROM all_indexes WHERE table_name='" + tableName + "' AND table_owner=sys_context('userenv','current_schema') ORDER BY owner,index_name");
    }

    public static void readTableTriggers(TngConnection connection, String tableName, List<String> names) throws TngExceptionSql {
        names.clear();
        connection.addQueryRows(names, "SELECT owner||'.'||trigger_name FROM all_triggers WHERE table_name='" + tableName + "' AND table_owner=sys_context('userenv','current_schema') ORDER BY owner,trigger_name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTableColumns(TngConnection connection, String tableName, List<Column> columns, boolean allColumns) throws Exception {
        columns.clear();
        Statement st = null;
        try {
            String h2 = "";
            if (!allColumns) {
                h2 = " and substr(column_name,1,2)!='X_'";
            }
            st = connection.execStatement(st, "SELECT column_name,data_type,char_length,data_precision,data_scale,nullable,data_default FROM all_tab_columns WHERE table_name='" + tableName + "'" + h2 + " AND owner=sys_context('userenv','current_schema') ORDER BY column_id");
            ResultSet rs = st.getResultSet();
            while (rs.next()) {
                String name = rs.getString(1);
                String type = rs.getString(2);
                int length = rs.getInt(3);
                int precision = rs.getInt(4);
                int scale = rs.getInt(5);
                boolean notNull = !"Y".equals(rs.getString(6));
                String defaultValue = rs.getString(7);
                if (defaultValue != null && (defaultValue = defaultValue.trim()).equalsIgnoreCase("NULL")) {
                    defaultValue = null;
                }
                if (type.startsWith("TIMESTAMP")) {
                    int n2 = type.indexOf(40);
                    if (n2 > 0) {
                        type = type.substring(0, n2);
                    }
                    precision = scale;
                    scale = 0;
                }
                Column column = new Column();
                column.name = name;
                column.type = type;
                column.precision = precision == 0 ? length : precision;
                column.scale = scale;
                column.notNull = notNull;
                column.defaultValue = defaultValue;
                columns.add(column);
            }
            connection.close(st);
        }
        catch (Throwable throwable) {
            connection.close(st);
            throw throwable;
        }
    }

    public static String getIndexDDL(String tableName, Index idx) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE ");
        if (!idx.type.equals("NON_UNIQUE")) {
            ddl.append(idx.type);
            ddl.append(' ');
        }
        ddl.append("INDEX ");
        ddl.append(tableName);
        ddl.append('_');
        ddl.append(idx.name);
        ddl.append(" ON ");
        ddl.append(tableName);
        ddl.append('(');
        ddl.append(idx.definition);
        ddl.append(')');
        return ddl.toString();
    }

    public static String getTableDDL(Table table) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE ");
        if (table.globaltemp) {
            ddl.append("GLOBAL TEMPORARY ");
        }
        ddl.append("TABLE ");
        ddl.append(table.name);
        ddl.append('(');
        ddl.append('\n');
        for (int i2 = 0; i2 < table.columns.size(); ++i2) {
            if (i2 > 0) {
                ddl.append(',');
                ddl.append('\n');
            }
            SchemaAccessorSql.addColumnDDL(ddl, table.columns.get(i2));
        }
        ddl.append('\n');
        ddl.append(')');
        if (table.globaltemp) {
            ddl.append(" ON COMMIT PRESERVE ROWS");
        }
        return ddl.toString();
    }

    protected static void addColumnDDL(StringBuilder ddl, Column column) {
        ddl.append(column.name);
        ddl.append(' ');
        String physType = SchemaAccessorSql.columnTypeToPhys(column.type);
        SchemaAccessorSql.addColumnDDL(ddl, physType, column.precision, column.scale, column.defaultValue, column.notNull);
    }

    protected static void addColumnDDL(StringBuilder ddl, String type, int precision, int scale, String defaultValue, boolean notNull) {
        ddl.append(type);
        if (precision != 0 && !"LONG".equals(type)) {
            ddl.append('(');
            ddl.append(precision);
            if (scale != 0) {
                ddl.append(',');
                ddl.append(scale);
            }
            ddl.append(')');
        }
        if (defaultValue != null) {
            ddl.append(" DEFAULT ");
            ddl.append(defaultValue);
        }
        if (notNull) {
            ddl.append(" NOT NULL");
        } else {
            ddl.append(" NULL");
        }
    }

    public static String columnTypeToPhys(String type) {
        if (type.equals("TIMESTAMP")) {
            return "DATE";
        }
        return type;
    }
}

